/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.auth.service.impl;

import com.cyberway.msf.commons.auth.service.AuthenticationService;
import com.cyberway.msf.commons.auth.support.CommonsAuthProperties;
import com.cyberway.msf.commons.auth.util.JwtUtils;
import com.cyberway.msf.commons.cache.RedisUtils;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;

@Service
public class AuthenticationServiceImpl
implements AuthenticationService {
    private static final Logger logger = LoggerFactory.getLogger(AuthenticationServiceImpl.class);
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private JwtUtils jwtUtils;
    @Autowired
    private CommonsAuthProperties commonsAuthProperties;

    @Override
    public Boolean authenticate(ServerHttpRequest request) {
        logger.debug("AuthenticationServiceImpl -> authenticate() starts..");
        String token = this.getTokenFromHeader(request);
        if (StringUtils.isNotEmpty((CharSequence)token) && this.isTokenValid(token).booleanValue() && this.isTokenInRedis(token).booleanValue()) {
            return this.refreshToken(token, this.commonsAuthProperties.getTokenTime());
        }
        return false;
    }

    @Override
    public Object getApiList(ServerHttpRequest request) {
        Object apiList = new ArrayList();
        String token = this.getTokenFromHeader(request);
        JwtUtils.JwtResult jwtResult = this.checkToken(token);
        if (jwtResult.isSuccess()) {
            apiList = this.redisUtils.getOrigin(String.format("resourcesURL:%s", jwtResult.getUid()));
        }
        return apiList;
    }

    @Override
    public Boolean isTokenValid(ServerHttpRequest request) {
        String token = this.getTokenFromHeader(request);
        return this.isTokenValid(token);
    }

    @Override
    public Boolean isTokenInRedis(ServerHttpRequest request) {
        String token = this.getTokenFromHeader(request);
        return this.isTokenInRedis(token);
    }

    @Override
    public Boolean isUserLogged(ServerHttpRequest request) {
        String token = this.getTokenFromHeader(request);
        if (this.isTokenValid(token).booleanValue()) {
            JwtUtils.JwtResult jwtResult = this.checkToken(token);
            String userId = jwtResult.getUid();
            return this.redisUtils.getOrigin(String.format("auth_user_token_%s", userId)) != null;
        }
        return false;
    }

    private Boolean isTokenValid(String token) {
        Boolean isValid = true;
        if (StringUtils.isBlank((CharSequence)token)) {
            isValid = false;
        } else {
            JwtUtils.JwtResult jwtResult = this.checkToken(token);
            if (!jwtResult.isSuccess()) {
                isValid = false;
            }
        }
        return isValid;
    }

    private JwtUtils.JwtResult checkToken(String token) {
        logger.debug("Start to check token");
        JwtUtils.JwtResult jwtResult = this.jwtUtils.checkToken(token);
        logger.debug("End to check token with result : {}", (Object)jwtResult);
        return jwtResult;
    }

    private Boolean isTokenInRedis(String token) {
        if (token == null) {
            return false;
        }
        Object user = this.redisUtils.getOrigin("auth_user_token_" + token);
        logger.debug("Get user in redis with token ({}) : {}", (Object)token, user);
        return user != null;
    }

    private Boolean refreshToken(String token, Long expireTime) {
        String key = "auth_user_token_" + token;
        Object user = this.redisUtils.getOrigin(key);
        logger.debug("Get user from redis : {}", user);
        if (user == null) {
            logger.warn("user is not in redis");
            return false;
        }
        logger.debug("Refresh {} in redis to {} seconds", (Object)key, (Object)expireTime);
        this.redisUtils.setOrigin(key, user, expireTime.longValue());
        logger.debug(" The expireTime is : {}  ", (Object)expireTime);
        return true;
    }

    private String getTokenFromHeader(ServerHttpRequest request) {
        String token = "" + StringUtils.join((Iterable)request.getHeaders().get((Object)"Authorization"), (char)',');
        logger.debug("The token is : {}", (Object)token);
        return token;
    }
}

