/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.support.script.mvel;

import com.cyberway.msf.commons.base.support.script.mvel.Model;
import com.cyberway.msf.commons.base.support.script.mvel.ModelImpl;
import com.cyberway.msf.commons.base.support.script.mvel.ModelUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.mvel2.MVEL;

public class MvelModel<T>
implements Model<T> {
    public static final String ROOT_VAR = "root";
    private static ConcurrentHashMap<String, Serializable> COMPILED_GET = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Serializable> COMPILED_SET = new ConcurrentHashMap();
    private Object root;
    private String expression;
    private Model<T> defaultValue;
    private Map<String, Object> variables = new HashMap<String, Object>();

    public MvelModel(String expression) {
        this(null, expression);
    }

    public MvelModel(Object root, String expression) {
        assert (!StringUtils.isBlank((CharSequence)expression));
        this.root = root;
        this.expression = expression;
    }

    public Object getRoot() {
        return this.root instanceof Model ? ModelUtils.getObject((Model)this.root) : this.root;
    }

    public String getExpression() {
        return this.expression;
    }

    protected Serializable getCompiledGetExpression() {
        String expression = this.getExpression();
        Serializable compiled = COMPILED_GET.get(expression);
        if (compiled == null) {
            compiled = MVEL.compileExpression((String)expression);
            COMPILED_GET.put(expression, compiled);
        }
        return compiled;
    }

    protected Serializable getCompiledSetExpression() {
        String expression = this.getExpression();
        Serializable compiled = COMPILED_SET.get(expression);
        if (compiled == null) {
            compiled = MVEL.compileSetExpression((String)expression);
            COMPILED_SET.put(expression, compiled);
        }
        return compiled;
    }

    public MvelModel<T> withDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue instanceof Model ? (ModelImpl<Object>)defaultValue : ModelImpl.of(defaultValue);
        return this;
    }

    public MvelModel<T> addVariable(String name, Object value) {
        this.variables.put(name, value);
        return this;
    }

    @Override
    public T getObject() {
        Object result = null;
        Serializable compiled = this.getCompiledGetExpression();
        result = compiled != null ? MVEL.executeExpression((Object)compiled, (Object)this.getRoot(), this.newVariableMap()) : MVEL.eval((String)this.getExpression(), (Object)this.getRoot(), this.newVariableMap());
        if (result == null) {
            result = ModelUtils.getObject(this.defaultValue);
        }
        return (T)result;
    }

    @Override
    public void setObject(T value) {
        MVEL.executeSetExpression((Serializable)this.getCompiledSetExpression(), (Object)this.getRoot(), value);
    }

    protected Map<String, Object> newVariableMap() {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        for (Map.Entry<String, Object> pair : this.variables.entrySet()) {
            String name = pair.getKey();
            Object value = pair.getValue() instanceof Model ? ModelUtils.getObject((Model)pair.getValue()) : pair.getValue();
            ctx.put(name, value);
        }
        ctx.put(ROOT_VAR, this.getRoot());
        return ctx;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append(ROOT_VAR, this.getRoot()).append("expression", (Object)this.getExpression()).build();
    }
}

