/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.util;

import com.cyberway.msf.commons.model.base.BusinessFullHierarchicalEntityWithOrg;
import com.cyberway.msf.core.model.tree.ZtreeNode;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class TreeUtils {
    private TreeUtils() {
    }

    public static List<ZtreeNode> getTree(List<? extends BusinessFullHierarchicalEntityWithOrg> rootNodes, List<? extends BusinessFullHierarchicalEntityWithOrg> childNodes, String type) {
        ArrayList<ZtreeNode> ztreeNodes = new ArrayList<ZtreeNode>();
        if (CollectionUtils.isNotEmpty(rootNodes)) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)childNodes.size());
            rootNodes.forEach(entity -> ztreeNodes.add(TreeUtils.generateNodes(entity, map, childNodes, type)));
        }
        return ztreeNodes;
    }

    public static List<ZtreeNode> getTree(List<? extends BusinessFullHierarchicalEntityWithOrg> rootNodes, List<? extends BusinessFullHierarchicalEntityWithOrg> childNodes) {
        return TreeUtils.getTree(rootNodes, childNodes, null);
    }

    private static ZtreeNode generateNodes(BusinessFullHierarchicalEntityWithOrg entity, Map<String, String> map, List<? extends BusinessFullHierarchicalEntityWithOrg> childNodes, String type) {
        ZtreeNode ztreeNode = new ZtreeNode((String)((Object)entity.getId()), type, entity.getName());
        ArrayList childrenZtreeNodes = new ArrayList();
        if (CollectionUtils.isNotEmpty(childNodes)) {
            childNodes.stream().filter(childEntity -> !map.containsKey(childEntity.getId())).filter(childEntity -> StringUtils.equals((CharSequence)childEntity.getParent(), (CharSequence)((String)((Object)entity.getId())))).forEach(childEntity -> {
                map.put((String)((Object)childEntity.getId()), childEntity.getParent());
                childrenZtreeNodes.add(TreeUtils.generateNodes(childEntity, map, childNodes, type));
            });
        }
        ztreeNode.setChildren(childrenZtreeNodes);
        ztreeNode.setIsParent(Boolean.valueOf(childrenZtreeNodes.isEmpty()));
        return ztreeNode;
    }
}

