/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.controller;

import com.cyberway.msf.commons.api.result.ApiResponseResult;
import com.cyberway.msf.commons.api.result.ApiResultCode;
import com.cyberway.msf.commons.base.support.constant.CommonsBaseConstants;
import com.cyberway.msf.commons.base.support.converter.ErrorCodeConverter;
import com.cyberway.msf.commons.base.util.MessageUtils;
import com.cyberway.msf.commons.core.exception.BaseException;
import com.cyberway.msf.commons.core.i18n.I18nUtils;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

public class BaseHandleExceptionController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String API_PREFIX = "/api/";
    @Autowired
    protected ErrorCodeConverter errorCodeConverter;
    @Autowired
    private I18nUtils i18nUtils;

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    protected Object exception(Exception exception, HttpServletRequest request, HttpServletResponse response) {
        this.logger.warn("got a Exception", (Throwable)exception);
        String message = "";
        String exceptionCode = "";
        int httpStatus = HttpStatus.INTERNAL_SERVER_ERROR.value();
        if (exception instanceof BaseException) {
            return this.handleBaseException((BaseException)exception, request, response);
        }
        if (exception instanceof MissingServletRequestParameterException) {
            exceptionCode = ApiResultCode.REQUIRE_PARAM_IS_NOT_PRESENT.getResultCode();
            httpStatus = HttpStatus.BAD_REQUEST.value();
            MissingServletRequestParameterException e = (MissingServletRequestParameterException)exception;
            message = MessageUtils.getErrorMessage(ApiResultCode.REQUIRE_PARAM_IS_NOT_PRESENT, e.getParameterType(), e.getParameterName());
        } else if (exception instanceof HttpMessageNotReadableException) {
            httpStatus = HttpStatus.BAD_REQUEST.value();
            exceptionCode = ApiResultCode.REQUIRE_PARAM_IS_ERROR.getResultCode();
            message = MessageUtils.getErrorMessage(ApiResultCode.REQUIRE_PARAM_IS_ERROR, new Object[0]);
        } else if (exception instanceof DataIntegrityViolationException) {
            exceptionCode = ApiResultCode.REFERENCE_DATA_ERROR.getResultCode();
            message = MessageUtils.getErrorMessage(ApiResultCode.REFERENCE_DATA_ERROR, new Object[0]);
        } else if (exception instanceof MethodArgumentNotValidException) {
            FieldError error = ((MethodArgumentNotValidException)exception).getBindingResult().getFieldError();
            String code = "";
            httpStatus = HttpStatus.BAD_REQUEST.value();
            if (null != error) {
                switch (code = code + error.getCode()) {
                    case "NotBlank": 
                    case "NotEmpty": 
                    case "NotNull": {
                        exceptionCode = ApiResultCode.PARAM_IS_NULL.getResultCode();
                        message = MessageUtils.getErrorMessage(ApiResultCode.PARAM_IS_NULL, error.getField());
                        break;
                    }
                    default: {
                        exceptionCode = ApiResultCode.INVALID_PARAM_VALUE.getResultCode();
                        message = MessageUtils.getErrorMessage(ApiResultCode.INVALID_PARAM_VALUE, error.getField(), error.getDefaultMessage());
                        break;
                    }
                }
            } else {
                exceptionCode = ApiResultCode.INVALID_PARAM_ERROR.getResultCode();
                message = MessageUtils.getErrorMessage(ApiResultCode.INVALID_PARAM_ERROR, new Object[0]);
            }
        } else if (exception instanceof BadSqlGrammarException) {
            SQLException sqlException = ((BadSqlGrammarException)exception).getSQLException();
            String defaultMessage = sqlException.getMessage();
            if (CommonsBaseConstants.SORT_STRING_ERROR_PATTERN.matcher(defaultMessage).matches()) {
                String sort = StringUtils.substringAfter((String)StringUtils.substringBeforeLast((String)defaultMessage, (String)"' in 'order clause'"), (String)"Unknown column '");
                exceptionCode = ApiResultCode.SORT_STRING_ERROR.getResultCode();
                message = message + MessageUtils.getErrorMessage(ApiResultCode.SORT_STRING_ERROR, sort);
            } else {
                exceptionCode = ApiResultCode.BAD_SQL_GRAMMAR.getResultCode();
                message = message + MessageUtils.getErrorMessage(ApiResultCode.BAD_SQL_GRAMMAR, new Object[0]);
            }
        } else {
            this.logger.error(exception.getMessage(), (Throwable)exception);
            exceptionCode = ApiResultCode.UNKNOWN_SYSTEM_ERROR.getResultCode();
            message = message + MessageUtils.getErrorMessage(ApiResultCode.UNKNOWN_SYSTEM_ERROR, new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)exceptionCode)) {
            exceptionCode = ApiResultCode.UNKNOWN_SYSTEM_ERROR.getResultCode();
        }
        response.setStatus(httpStatus);
        if (this.isApiRequest(request)) {
            return new ApiResponseResult(exceptionCode, message);
        }
        return String.format("%s:%s", exceptionCode, message);
    }

    private Object handleBaseException(BaseException baseException, HttpServletRequest request, HttpServletResponse response) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(baseException.getMessage(), (Throwable)baseException);
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info("Request [{}] throw a BaseException:{}", (Object)request.getRequestURI(), (Object)baseException.getMessage());
        }
        response.setStatus(this.errorCodeConverter.convertErrorCodeToHttpStatus(baseException.getCode()));
        String message = StringUtils.isNotBlank((CharSequence)baseException.getCode()) ? this.i18nUtils.getMessage(baseException.getCode(), baseException.getMessage(), request, baseException.getValues()) : (baseException.getValues() == null ? baseException.getMessage() : String.format(baseException.getMessage(), baseException.getValues()));
        String code = (String)StringUtils.defaultIfBlank((CharSequence)baseException.getCode(), (CharSequence)ApiResultCode.UNKNOWN_SYSTEM_ERROR.getResultCode());
        if (this.isApiRequest(request)) {
            return new ApiResponseResult(code, message);
        }
        return String.format("%s:%s", code, message);
    }

    protected boolean isApiRequest(HttpServletRequest request) {
        return StringUtils.contains((CharSequence)request.getRequestURI(), (CharSequence)API_PREFIX);
    }
}

