/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.service;

import com.cyberway.msf.commons.api.result.ApiResultCode;
import com.cyberway.msf.commons.base.mapper.BaseMapper;
import com.cyberway.msf.commons.base.service.BaseService;
import com.cyberway.msf.commons.base.support.configuration.CommonsBaseProperties;
import com.cyberway.msf.commons.base.util.BusinessPreconditions;
import com.cyberway.msf.commons.base.util.MessageUtils;
import com.cyberway.msf.commons.base.util.PageUtils;
import com.cyberway.msf.commons.base.util.SqlUtils;
import com.cyberway.msf.commons.base.util.UserUtils;
import com.cyberway.msf.commons.core.exception.BaseException;
import com.cyberway.msf.commons.model.annotation.AssociatedTable;
import com.cyberway.msf.commons.model.base.BusinessFullHierarchicalEntityWithOrg;
import com.cyberway.msf.commons.model.base.EntityImpl;
import com.cyberway.msf.commons.model.filter.FieldType;
import com.cyberway.msf.commons.model.filter.Filter;
import com.cyberway.msf.commons.model.filter.FilterModel;
import com.cyberway.msf.commons.model.filter.Operation;
import com.cyberway.msf.commons.model.page.PageDataModel;
import com.cyberway.msf.commons.model.page.PageModel;
import com.cyberway.msf.commons.model.user.UserInfo;
import com.cyberway.msf.core.model.organization.Organization;
import java.lang.reflect.ParameterizedType;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import tk.mybatis.mapper.MapperException;
import tk.mybatis.mapper.entity.EntityColumn;
import tk.mybatis.mapper.entity.Example;
import tk.mybatis.mapper.mapperhelper.EntityHelper;
import tk.mybatis.mapper.util.Sqls;

public class BaseServiceImpl<T>
implements BaseService<T> {
    @Autowired
    private BaseMapper<T> baseMapper;
    @Autowired
    protected RestTemplate restTemplate;
    @Autowired
    private CommonsBaseProperties commonsBaseProperties;

    @Override
    public T selectById(Object primaryKey) {
        Class entityClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        Set columnSet = EntityHelper.getColumns((Class)entityClass);
        for (EntityColumn entityColumn : columnSet) {
            if (!entityColumn.getEntityField().isAnnotationPresent(AssociatedTable.class)) continue;
            return (T)this.baseMapper.multiTableSelectByPrimaryKey(primaryKey);
        }
        return (T)this.baseMapper.selectByPrimaryKey(primaryKey);
    }

    @Override
    public List<T> selectAll() {
        return this.baseMapper.selectAll();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int delete(Object primaryKey) {
        try {
            return this.baseMapper.deleteByPrimaryKey(primaryKey);
        }
        catch (DataIntegrityViolationException e) {
            throw new BaseException(ApiResultCode.DELETE_FAIL_REFERENCE.getResultCode(), ApiResultCode.DELETE_FAIL_REFERENCE.getResultMessage());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int batchDelete(List<String> primaryKeys) {
        BusinessPreconditions.checkArgument(CollectionUtils.isNotEmpty(primaryKeys), MessageUtils.buildException(ApiResultCode.PARAM_IS_NULL, "ids"));
        try {
            List primaryKeysWithoutBlank = primaryKeys.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(primaryKeysWithoutBlank)) {
                return 0;
            }
            return this.baseMapper.deleteByIds(StringUtils.join((Iterable)primaryKeysWithoutBlank.stream().map(s -> StringUtils.wrap((String)s, (char)'\'')).collect(Collectors.toList()), (String)","));
        }
        catch (DataIntegrityViolationException e) {
            throw new BaseException(ApiResultCode.DELETE_FAIL_REFERENCE.getResultCode(), ApiResultCode.DELETE_FAIL_REFERENCE.getResultMessage());
        }
    }

    @Override
    public List<T> selectByExample(Object example) {
        return this.baseMapper.selectByExample(example);
    }

    @Override
    public List<T> selectByFilters(FilterModel filterModel) {
        Class entityClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        Example example = new Example(entityClass);
        Boolean multiFlag = false;
        Set columnSet = EntityHelper.getColumns((Class)entityClass);
        for (EntityColumn entityColumn : columnSet) {
            if (!entityColumn.getEntityField().isAnnotationPresent(AssociatedTable.class)) continue;
            multiFlag = true;
            break;
        }
        try {
            this.generaExample(example, filterModel);
            if (multiFlag.booleanValue()) {
                return this.baseMapper.multiTableSelectByExample(example);
            }
            return this.selectByExample(example);
        }
        catch (MapperException e) {
            throw MessageUtils.buildException(ApiResultCode.QUERY_DATA_FAIL, e.getMessage());
        }
    }

    @Override
    public PageDataModel<T> selectByFiltersPaging(FilterModel filterModel) {
        Class entityClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        PageUtils.sortAndPagination((PageModel)filterModel, entityClass);
        Example example = new Example(entityClass);
        Boolean multiFlag = false;
        Set columnSet = EntityHelper.getColumns((Class)entityClass);
        for (EntityColumn entityColumn : columnSet) {
            if (!entityColumn.getEntityField().isAnnotationPresent(AssociatedTable.class)) continue;
            multiFlag = true;
            break;
        }
        try {
            this.generaExample(example, filterModel);
            if (multiFlag.booleanValue()) {
                return PageUtils.getPageDataModel((PageModel)filterModel, this.baseMapper.multiTableSelectByExample(example));
            }
            return PageUtils.getPageDataModel((PageModel)filterModel, this.selectByExample(example));
        }
        catch (MapperException e) {
            throw MessageUtils.buildException(ApiResultCode.QUERY_DATA_FAIL, e.getMessage());
        }
    }

    private void generaExample(Example example, FilterModel filterModel) {
        if (filterModel == null || CollectionUtils.isEmpty((Collection)filterModel.getFilters())) {
            return;
        }
        Example.Criteria criteria = example.createCriteria();
        for (Filter filter : filterModel.getFilters()) {
            Operation operation = filter.getOperation();
            String field = StringUtils.substring((String)filter.getField(), (int)(StringUtils.indexOf((CharSequence)filter.getField(), (CharSequence)".") + 1));
            Object value = filter.getValue();
            if (value == null) continue;
            if (FieldType.Date.equals((Object)filter.getFieldType())) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime((Date)value);
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                if (Operation.GreaterThan.equals((Object)operation) || Operation.GreaterThanEq.equals((Object)operation)) {
                    value = calendar.getTime();
                }
                if (Operation.LessThan.equals((Object)operation) || Operation.LessThanEq.equals((Object)operation)) {
                    calendar.add(5, 1);
                    value = calendar.getTime();
                }
            }
            switch (operation) {
                case Eq: {
                    criteria.andEqualTo(field, value);
                    break;
                }
                case NotEq: {
                    criteria.andNotEqualTo(field, value);
                    break;
                }
                case StartsWith: {
                    if (!FieldType.String.equals((Object)filter.getFieldType())) break;
                    criteria.andLike(field, SqlUtils.matchStart((String)value));
                    break;
                }
                case EndsWith: {
                    if (!FieldType.String.equals((Object)filter.getFieldType())) break;
                    criteria.andLike(field, SqlUtils.matchEnd((String)value));
                    break;
                }
                case Contains: {
                    if (!FieldType.String.equals((Object)filter.getFieldType())) break;
                    criteria.andLike(field, SqlUtils.matchAnywhere((String)value));
                    break;
                }
                case NotContains: {
                    if (!FieldType.String.equals((Object)filter.getFieldType())) break;
                    criteria.andNotLike(field, SqlUtils.matchAnywhere((String)value));
                    break;
                }
                case LessThan: {
                    criteria.andLessThan(field, value);
                }
                case GreaterThan: {
                    criteria.andGreaterThan(field, value);
                }
                case LessThanEq: {
                    criteria.andLessThanOrEqualTo(field, value);
                }
                case GreaterThanEq: {
                    criteria.andGreaterThanOrEqualTo(field, value);
                }
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int updateAll(T entity) {
        this.validateData(entity);
        this.beforeSave(entity);
        this.getFullHierarchicalEntity(entity);
        return this.baseMapper.updateByPrimaryKey(entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int update(T entity) {
        this.validateData(entity);
        this.beforeSave(entity);
        this.getFullHierarchicalEntity(entity);
        return this.baseMapper.updateByPrimaryKeySelective(entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int insert(T entity) {
        this.validateData(entity);
        this.beforeSave(entity);
        this.getFullHierarchicalEntity(entity);
        return this.baseMapper.insertSelective(entity);
    }

    @Override
    public Boolean containsByEntity(T entity) {
        return this.baseMapper.selectCount(entity) > 0;
    }

    @Override
    public Boolean contains(Object example) {
        return this.baseMapper.selectCountByExample(example) > 0;
    }

    @Override
    public UserInfo getLoggedInUser() {
        return UserUtils.getLoggedInUser();
    }

    @Override
    public Object getLoggedInUserVo() {
        return this.restTemplate.postForObject(this.commonsBaseProperties.getUrl().getLoggedInUser(), (Object)this.getHttpEntity(), Object.class, new Object[0]);
    }

    @Override
    public String getOrgId() {
        return (String)this.restTemplate.postForObject(this.commonsBaseProperties.getUrl().getOrgId(), (Object)this.getHttpEntity(), String.class, new Object[0]);
    }

    @Override
    public Organization getOrg() {
        return (Organization)this.restTemplate.postForObject(this.commonsBaseProperties.getUrl().getOrg(), (Object)this.getHttpEntity(), Organization.class, new Object[0]);
    }

    @Override
    public Organization getOrg(String orgId) {
        return (Organization)this.restTemplate.postForObject(this.commonsBaseProperties.getUrl().getOrgByOrgId(), (Object)this.getHttpEntity(), Organization.class, new Object[]{orgId});
    }

    protected void validateData(T entity) {
    }

    protected void beforeSave(T entity) {
    }

    protected void validateUnique(Class<?> clazz, EntityImpl<String> entity, String property, Object value, ApiResultCode exceptionResultCode) {
        this.validateUnique(clazz, entity, property, value, exceptionResultCode, false);
    }

    protected void validateUnique(Class<?> clazz, EntityImpl<String> entity, String property, Object value, ApiResultCode exceptionResultCode, Boolean ignoreDeleted) {
        Sqls sqls = Sqls.custom().andNotEqualTo("id", (Object)StringUtils.defaultString((String)((String)((Object)entity.getId())))).andEqualTo(property, value);
        if (ignoreDeleted.booleanValue()) {
            sqls.andEqualTo("deleted", (Object)Boolean.FALSE);
        }
        if (CollectionUtils.isNotEmpty(this.selectByExample(Example.builder(clazz).where(sqls).build()))) {
            throw MessageUtils.buildException(exceptionResultCode, value);
        }
    }

    protected void validateBySqls(Class<?> clazz, Sqls sqls, ApiResultCode exceptionResultCode, Object ... errorArgs) {
        if (CollectionUtils.isNotEmpty(this.selectByExample(Example.builder(clazz).where(sqls).build()))) {
            throw MessageUtils.buildException(exceptionResultCode, errorArgs);
        }
    }

    private HttpEntity getHttpEntity() {
        HttpHeaders headers = new HttpHeaders();
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attributes != null) {
            HttpServletRequest request = attributes.getRequest();
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String key = (String)headerNames.nextElement();
                String value = request.getHeader(key);
                headers.add(key, value);
            }
        }
        return new HttpEntity((MultiValueMap)headers);
    }

    private void getFullHierarchicalEntity(T entity) {
        if (BusinessFullHierarchicalEntityWithOrg.class.isAssignableFrom(entity.getClass())) {
            String parent = ((BusinessFullHierarchicalEntityWithOrg)entity).getParent();
            if (StringUtils.isEmpty((CharSequence)parent)) {
                ((BusinessFullHierarchicalEntityWithOrg)entity).setFullPathName(((BusinessFullHierarchicalEntityWithOrg)entity).getName());
                return;
            }
            BusinessFullHierarchicalEntityWithOrg parentEntity = (BusinessFullHierarchicalEntityWithOrg)this.selectById(parent);
            if (null == parentEntity) {
                ((BusinessFullHierarchicalEntityWithOrg)entity).setFullPathName(((BusinessFullHierarchicalEntityWithOrg)entity).getName());
                return;
            }
            String parentAllParent = StringUtils.isBlank((CharSequence)parentEntity.getAllParent()) ? "" : " " + parentEntity.getAllParent();
            ((BusinessFullHierarchicalEntityWithOrg)entity).setAllParent(parent + parentAllParent);
            String parentFullPathName = StringUtils.isBlank((CharSequence)parentEntity.getFullPathName()) ? "" : parentEntity.getFullPathName() + '/';
            ((BusinessFullHierarchicalEntityWithOrg)entity).setFullPathName(parentFullPathName + ((BusinessFullHierarchicalEntityWithOrg)entity).getName());
        }
    }

    protected Integer getStructure() {
        return this.commonsBaseProperties.getStructure();
    }
}

