/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.support.annotation.api;

import com.cyberway.msf.commons.api.result.ApiResultCode;
import com.cyberway.msf.commons.base.util.MessageUtils;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.condition.RequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class ApiVersionCondition
implements RequestCondition<ApiVersionCondition> {
    private static final Pattern VERSION_PATTERN = Pattern.compile("^v(([1-9]\\d*\\.\\d*|0\\.\\d*[1-9]\\d*)|[1-9]\\d*)$");
    private double apiVersion;

    ApiVersionCondition(double apiVersion) {
        this.apiVersion = apiVersion;
    }

    public double getApiVersion() {
        return this.apiVersion;
    }

    public ApiVersionCondition combine(ApiVersionCondition apiVersionCondition) {
        return new ApiVersionCondition(apiVersionCondition.getApiVersion());
    }

    public ApiVersionCondition getMatchingCondition(HttpServletRequest httpServletRequest) {
        String header = httpServletRequest.getHeader("X-API-VERSION");
        String url = httpServletRequest.getRequestURI();
        Boolean isEmptyHeader = StringUtils.isEmpty((CharSequence)header);
        Boolean versionExist = false;
        Double version = null;
        if (!isEmptyHeader.booleanValue()) {
            Matcher m = VERSION_PATTERN.matcher(header);
            if (m.matches()) {
                version = Double.valueOf(header.substring(1));
                if (version == this.apiVersion) {
                    return this;
                }
            } else {
                throw MessageUtils.buildException(ApiResultCode.API_VERSION_ERROR, new Object[0]);
            }
        }
        ServletContext servletContext = httpServletRequest.getSession().getServletContext();
        WebApplicationContext appContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
        Map allRequestMappings = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)appContext, HandlerMapping.class, (boolean)true, (boolean)false);
        for (HandlerMapping handlerMapping : allRequestMappings.values()) {
            if (!(handlerMapping instanceof RequestMappingHandlerMapping)) continue;
            RequestMappingHandlerMapping requestMappingHandlerMapping = (RequestMappingHandlerMapping)handlerMapping;
            Map handlerMethods = requestMappingHandlerMapping.getHandlerMethods();
            for (Map.Entry requestMappingInfoHandlerMethodEntry : handlerMethods.entrySet()) {
                ApiVersionCondition apiVersionCondition;
                double apiVersion;
                RequestMappingInfo requestMappingInfo = (RequestMappingInfo)requestMappingInfoHandlerMethodEntry.getKey();
                PatternsRequestCondition patternsCondition = requestMappingInfo.getPatternsCondition();
                if (isEmptyHeader.booleanValue() && patternsCondition.getPatterns().contains(url) && requestMappingInfo.getCustomCondition() == null) {
                    return null;
                }
                if (isEmptyHeader.booleanValue() || !patternsCondition.getPatterns().contains(url) || requestMappingInfo.getCustomCondition() == null || (apiVersion = (apiVersionCondition = (ApiVersionCondition)requestMappingInfo.getCustomCondition()).getApiVersion()) != version) continue;
                versionExist = true;
            }
        }
        if (isEmptyHeader.booleanValue()) {
            return this;
        }
        if (!versionExist.booleanValue()) {
            throw MessageUtils.buildException(ApiResultCode.API_VERSION_NOT_EXIST, new Object[0]);
        }
        return null;
    }

    public int compareTo(ApiVersionCondition apiVersionCondition, HttpServletRequest httpServletRequest) {
        double compare = this.apiVersion - apiVersionCondition.getApiVersion();
        return compare > 0.0 ? 1 : (compare < 0.0 ? -1 : 0);
    }
}

