/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.support.configuration;

import com.cyberway.msf.commons.base.support.configuration.CommonsBaseProperties;
import com.cyberway.msf.commons.base.support.converter.BaseErrorCodeConverter;
import com.cyberway.msf.commons.base.support.converter.ErrorCodeConverter;
import com.cyberway.msf.commons.base.support.interceptor.MapperInterceptor;
import com.cyberway.msf.commons.base.support.interceptor.QueryInterceptor;
import com.cyberway.msf.commons.base.util.MessageUtils;
import com.cyberway.msf.commons.base.util.UserUtils;
import com.cyberway.msf.commons.core.i18n.I18nUtils;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableConfigurationProperties(value={CommonsBaseProperties.class})
public class CommonsBaseConfig {
    @Autowired
    private List<SqlSessionFactory> sqlSessionFactoryList;

    @Bean
    @LoadBalanced
    public RestTemplate restTemplate() {
        return new RestTemplate();
    }

    @Bean
    @ConditionalOnMissingBean(value={UserUtils.class})
    public UserUtils userUtils() {
        return new UserUtils();
    }

    @Bean
    @ConditionalOnMissingBean(value={MessageUtils.class})
    @ConditionalOnBean(value={I18nUtils.class})
    public MessageUtils messageUtils(Environment environment, I18nUtils i18nUtils) {
        return new MessageUtils(environment, i18nUtils);
    }

    @Bean
    @ConditionalOnMissingBean(value={ErrorCodeConverter.class})
    public ErrorCodeConverter errorCodeConverter() {
        return new BaseErrorCodeConverter();
    }

    @PostConstruct
    public void addMapperInterceptor() {
        MapperInterceptor mapperInterceptor = new MapperInterceptor();
        QueryInterceptor queryInterceptor = new QueryInterceptor();
        for (SqlSessionFactory sqlSessionFactory : this.sqlSessionFactoryList) {
            sqlSessionFactory.getConfiguration().addInterceptor((Interceptor)mapperInterceptor);
            sqlSessionFactory.getConfiguration().addInterceptor((Interceptor)queryInterceptor);
        }
    }
}

