/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.support.interceptor;

import feign.RequestInterceptor;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Configuration
public class FeignInterceptor {
    private Logger logger = LoggerFactory.getLogger(FeignInterceptor.class);

    @Bean
    public RequestInterceptor requestInterceptor() {
        return template -> {
            HttpServletRequest request;
            Enumeration headerNames;
            ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            if (attributes != null && (headerNames = (request = attributes.getRequest()).getHeaderNames()) != null) {
                while (headerNames.hasMoreElements()) {
                    String name = (String)headerNames.nextElement();
                    String values = request.getHeader(name);
                    template.header(name, new String[]{values});
                }
            }
        };
    }
}

