/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.support.interceptor;

import com.cyberway.msf.commons.base.support.constant.CommonsBaseConstants;
import com.cyberway.msf.commons.base.support.interceptor.OrgFilter;
import com.cyberway.msf.commons.base.util.UserUtils;
import com.cyberway.msf.commons.model.user.UserInfo;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class QueryInterceptor
implements Interceptor {
    private static final Logger logger = LoggerFactory.getLogger(QueryInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        CacheKey cacheKey;
        BoundSql boundSql;
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        Object parameter = args[1];
        RowBounds rowBounds = (RowBounds)args[2];
        ResultHandler resultHandler = (ResultHandler)args[3];
        Executor executor = (Executor)invocation.getTarget();
        if (args.length == 4) {
            boundSql = ms.getBoundSql(parameter);
            cacheKey = executor.createCacheKey(ms, parameter, rowBounds, boundSql);
        } else {
            cacheKey = (CacheKey)args[4];
            boundSql = (BoundSql)args[5];
        }
        String orgSql = this.getOrgSql(ms, boundSql, parameter, rowBounds, cacheKey);
        BoundSql orgBoundSql = new BoundSql(ms.getConfiguration(), orgSql, boundSql.getParameterMappings(), parameter);
        for (ParameterMapping mapping : boundSql.getParameterMappings()) {
            String prop = mapping.getProperty();
            if (!boundSql.hasAdditionalParameter(prop)) continue;
            orgBoundSql.setAdditionalParameter(prop, boundSql.getAdditionalParameter(prop));
        }
        return executor.query(ms, parameter, rowBounds, resultHandler, cacheKey, orgBoundSql);
    }

    private String getOrgSql(MappedStatement ms, BoundSql boundSql, Object parameter, RowBounds rowBounds, CacheKey cacheSql) {
        String sql = boundSql.getSql();
        String org = "";
        UserInfo userInfo = UserUtils.getLoggedInUser();
        if (userInfo == null) {
            logger.warn("login user is null.");
            return sql;
        }
        org = userInfo.getOrg();
        String id = ms.getId();
        if (StringUtils.isEmpty((CharSequence)id)) {
            return sql;
        }
        String className = id.substring(0, id.lastIndexOf("."));
        try {
            Class<?> cls = Class.forName(className);
            if (!cls.isAnnotationPresent(OrgFilter.class)) {
                return sql;
            }
            String value = cls.getAnnotation(OrgFilter.class).value();
            String orgStr = this.getOrgStr(org, value);
            sql = CommonsBaseConstants.WHERE.matcher(sql).find() ? CommonsBaseConstants.WHERE.matcher(sql).replaceAll(orgStr + "AND ") : (CommonsBaseConstants.ORDER.matcher(sql).find() ? CommonsBaseConstants.ORDER.matcher(sql).replaceAll(orgStr + "ORDER ") : (CommonsBaseConstants.LIMIT.matcher(sql).find() ? CommonsBaseConstants.LIMIT.matcher(sql).replaceAll(orgStr + "LIMIT ") : sql + orgStr));
        }
        catch (ClassNotFoundException e) {
            logger.warn("Class OrgFilter do not found.");
        }
        return sql;
    }

    private String getOrgStr(String org, String value) {
        StringBuilder sb = new StringBuilder(40);
        sb.append(" WHERE ");
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            sb.append(value).append('.');
        }
        sb.append("org ").append("=").append('\'').append(org).append('\'').append(" ");
        return sb.toString();
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }
}

