/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.support.multitable;

import com.cyberway.msf.commons.base.support.multitable.IExample;
import com.cyberway.msf.commons.base.support.multitable.MultiTableResultCode;
import com.cyberway.msf.commons.base.util.MessageUtils;
import com.cyberway.msf.commons.core.exception.BaseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tk.mybatis.mapper.entity.Example;

public abstract class BaseExample
extends Example
implements IExample {
    private static final Logger logger = LoggerFactory.getLogger(BaseExample.class);
    private boolean useMultipart;
    private List<String> equalsWhereKey;
    private List<Object> equalsWhereValue;
    private List<String> greaterThanWhereKey;
    private List<Object> greaterThanWhereValue;
    private List<String> lessThanWhereKey;
    private List<Object> lessThanWhereValue;
    private List<String> notEqualsWhereKey;
    private List<Object> notEqualsWhereValue;
    private List<String> tableName;
    private Map<String, String> tableMap;
    private List<String> tableAlias;
    private List<String> inFields;
    private List<Object> inValue1;
    private List<Object> inValue2;
    private List<String> likeFields;
    private List<String> likeValues;

    public BaseExample(Class<?> entityClass) {
        super(entityClass);
    }

    public BaseExample(Class<?> entityClass, boolean exists) {
        super(entityClass, exists);
    }

    public BaseExample(Class<?> entityClass, boolean exists, boolean notNull) {
        super(entityClass, exists, notNull);
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    @Override
    public void end() throws BaseException {
        if (this.tableName == null || this.tableName.size() == 0) {
            throw MessageUtils.buildException(MultiTableResultCode.NO_TABLE_NAME, new Object[0]);
        }
        if (this.equalsWhereKey != null && this.equalsWhereKey.size() > 0 && this.equalsWhereKey.size() != this.equalsWhereValue.size()) {
            throw new IllegalArgumentException("\u201c=\u201d\u67e5\u8be2\u7684\u5b57\u6bb5\u4e0e\u503c\u7684\u6570\u91cf\u4e0d\u4e00\u81f4\uff01");
        }
        if (this.greaterThanWhereKey != null && this.greaterThanWhereKey.size() > 0 && this.greaterThanWhereKey.size() != this.greaterThanWhereValue.size()) {
            throw new IllegalArgumentException("\u201c>\u201d\u67e5\u8be2\u7684\u5b57\u6bb5\u4e0e\u503c\u7684\u6570\u91cf\u4e0d\u4e00\u81f4\uff01");
        }
        if (this.lessThanWhereKey != null && this.lessThanWhereKey.size() > 0 && this.lessThanWhereKey.size() != this.lessThanWhereValue.size()) {
            throw new IllegalArgumentException("\u201c<\u201d\u67e5\u8be2\u7684\u5b57\u6bb5\u4e0e\u503c\u7684\u6570\u91cf\u4e0d\u4e00\u81f4\uff01");
        }
        if (this.notEqualsWhereKey != null && this.notEqualsWhereKey.size() > 0 && this.notEqualsWhereKey.size() != this.notEqualsWhereValue.size()) {
            throw new IllegalArgumentException("\u201c!=\u201d\u67e5\u8be2\u7684\u5b57\u6bb5\u4e0e\u503c\u7684\u6570\u91cf\u4e0d\u4e00\u81f4\uff01");
        }
        if (this.tableAlias != null && this.tableAlias.size() != this.tableName.size()) {
            throw new IllegalArgumentException("\u4f7f\u7528\u522b\u540d\u65f6\uff0c\u522b\u540d\u6570\u91cf\u4e0e\u8868\u540d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        if (this.inFields == null && this.likeFields == null) {
            if (this.inValue1 != null && this.inValue1.size() != 0) {
                throw new BaseException("\u5728\u6ca1\u6709inField\u5b57\u6bb5\u65f6\u4e0d\u5141\u8bb8\u4f7f\u7528in()\u65b9\u6cd5\u589e\u52a0\u503c\u3002");
            }
            return;
        }
        if (this.inFields.size() == 1 && (this.inValue1 == null || this.inValue1.size() == 0)) {
            throw new BaseException("SelectWithInExample\u7c7b\u5728inFields\u4e0d\u4e3a\u7a7a\u65f6\uff0c\u5fc5\u9700\u6709value\u4e0e\u5176\u5bf9\u5e94\uff01");
        }
        if (this.inFields.size() == 2 && (this.inValue2 == null || this.inValue2.size() == 0)) {
            logger.debug("inFields\u4e2d\u7684\u5b57\u6bb5\u6570\u91cf\u4e0einValue\u4e2d\u4e0d\u7b26\uff0c\u5220\u9664\u4e86inFields\u4e2d\u7b2c\u4e8c\u4e2a\u5b57\u6bb5");
            this.inFields.remove(1);
        }
        this.inFields.forEach(str -> {
            if (StringUtils.isBlank((CharSequence)str)) {
                throw new BaseException("inField\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
        });
        if (this.likeFields != null && this.likeValues != null && this.likeFields.size() != this.likeValues.size()) {
            throw new BaseException("like\u67e5\u8be2\u65f6\u7684\u5b57\u6bb5\u4e0e\u503c\u7684\u6570\u91cf\u4e0d\u76f8\u7b49\uff01");
        }
        if (this.likeFields == null && this.likeValues != null || this.likeFields != null && this.likeValues == null) {
            throw new IllegalArgumentException("likeField \u548c likeValue\u5fc5\u987b\u6210\u5bf9\u51fa\u73b0\uff01\uff01");
        }
    }

    public BaseExample in(String inValue) {
        if (this.inFields == null) {
            throw new BaseException("\u5728\u6267\u884cin()\u65b9\u6cd5\u524d\u8bf7\u5148\u6267\u884caddInField()\u65b9\u6cd5\u589e\u52a0\u8981\u67e5\u8be2\u7684\u5b57\u6bb5\u3002");
        }
        int size = this.inFields.size();
        if (size == 1) {
            if (this.inValue1 == null || this.inValue1.size() == 0) {
                this.inValue1 = new ArrayList<Object>();
            }
            this.inValue1.add(inValue);
        } else if (size == 2) {
            if (this.inValue2 == null || this.inValue2.size() == 0) {
                this.inValue2 = new ArrayList<Object>();
            }
            this.inValue2.add(inValue);
        }
        return this;
    }

    public BaseExample in(List<String> inValue) {
        if (this.inFields == null) {
            throw new BaseException("\u5728\u6267\u884cin()\u65b9\u6cd5\u524d\u8bf7\u5148\u6267\u884caddInField()\u65b9\u6cd5\u589e\u52a0\u8981\u67e5\u8be2\u7684\u5b57\u6bb5\u3002");
        }
        int size = this.inFields.size();
        if (size == 1) {
            if (this.inValue1 == null || this.inValue1.size() == 0) {
                this.inValue1 = new ArrayList<Object>();
            }
            this.inValue1.addAll(inValue);
        } else if (size == 2) {
            if (this.inValue2 == null || this.inValue2.size() == 0) {
                this.inValue2 = new ArrayList<Object>();
            }
            this.inValue2.addAll(inValue);
        }
        return this;
    }

    public BaseExample addInField(String infield) {
        if (this.inFields == null || this.inFields.size() == 0) {
            this.inFields = new ArrayList<String>();
        }
        this.inFields.add(infield);
        return this;
    }

    public BaseExample like(String field, String likeValue) {
        if (this.likeFields == null || this.likeFields.size() == 0) {
            this.likeFields = new ArrayList<String>();
        }
        if (this.likeValues == null || this.likeValues.size() == 0) {
            this.likeValues = new ArrayList<String>();
        }
        this.likeFields.add(field);
        this.likeValues.add(likeValue);
        return this;
    }

    public BaseExample equalsWhere(String field, Object value) {
        if (this.equalsWhereKey == null) {
            this.equalsWhereKey = new LinkedList<String>();
            this.equalsWhereValue = new LinkedList<Object>();
        }
        this.equalsWhereKey.add(field);
        this.equalsWhereValue.add(value);
        return this;
    }

    public BaseExample greaterThanWhere(String field, Object value) {
        if (this.greaterThanWhereKey == null) {
            this.greaterThanWhereKey = new LinkedList<String>();
            this.greaterThanWhereValue = new LinkedList<Object>();
        }
        this.greaterThanWhereKey.add(field);
        this.greaterThanWhereValue.add(value);
        return this;
    }

    public BaseExample lessThanWhere(String field, Object value) {
        if (this.lessThanWhereKey == null) {
            this.lessThanWhereKey = new LinkedList<String>();
            this.lessThanWhereValue = new LinkedList<Object>();
        }
        this.lessThanWhereKey.add(field);
        this.lessThanWhereValue.add(value);
        return this;
    }

    public BaseExample notEqualsWhere(String field, Object value) {
        if (this.notEqualsWhereKey == null) {
            this.notEqualsWhereKey = new LinkedList<String>();
            this.notEqualsWhereValue = new LinkedList<Object>();
        }
        this.notEqualsWhereKey.add(field);
        this.notEqualsWhereValue.add(value);
        return this;
    }

    protected void addTableName(String tableName) {
        if (this.tableName == null) {
            this.tableName = new ArrayList<String>();
        }
        this.tableName.add(tableName);
    }

    public BaseExample addAlias(String alias, String tableName) {
        if (this.tableAlias == null) {
            this.tableAlias = new ArrayList<String>();
        }
        this.tableAlias.add(alias);
        if (this.tableMap == null) {
            this.tableMap = new HashMap<String, String>();
        }
        this.tableMap.put(alias, tableName);
        return this;
    }

    public List<String> getTableName() {
        return this.tableName;
    }

    public List<String> getTableAlias() {
        return this.tableAlias;
    }

    public Map<String, String> getTableMap() {
        return this.tableMap;
    }

    public List<String> getInFields() {
        return this.inFields;
    }

    public List<Object> getInValue1() {
        return this.inValue1;
    }

    public List<Object> getInValue2() {
        return this.inValue2;
    }

    public List<String> getLikeFields() {
        return this.likeFields;
    }

    public List<String> getLikeValues() {
        return this.likeValues;
    }

    public boolean isUseMultipart() {
        return this.useMultipart;
    }

    public List<String> getEqualsWhereKey() {
        return this.equalsWhereKey;
    }

    public List<Object> getEqualsWhereValue() {
        return this.equalsWhereValue;
    }

    public List<String> getGreaterThanWhereKey() {
        return this.greaterThanWhereKey;
    }

    public List<Object> getGreaterThanWhereValue() {
        return this.greaterThanWhereValue;
    }

    public List<String> getLessThanWhereKey() {
        return this.lessThanWhereKey;
    }

    public List<Object> getLessThanWhereValue() {
        return this.lessThanWhereValue;
    }

    public List<String> getNotEqualsWhereKey() {
        return this.notEqualsWhereKey;
    }

    public List<Object> getNotEqualsWhereValue() {
        return this.notEqualsWhereValue;
    }

    public void setUseMultipart(boolean useMultipart) {
        this.useMultipart = useMultipart;
    }
}

