/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.support.multitable;

import com.cyberway.msf.commons.model.annotation.AssociatedTable;
import java.util.Set;
import tk.mybatis.mapper.entity.EntityColumn;
import tk.mybatis.mapper.mapperhelper.EntityHelper;
import tk.mybatis.mapper.mapperhelper.SqlHelper;

public class CustomSqlHelper {
    private CustomSqlHelper() {
    }

    public static String selectOriginalColumns(Class<?> entityClass) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        sql.append(CustomSqlHelper.getAllColumnsWithDefaultAlias(entityClass));
        sql.append(" ");
        return sql.toString();
    }

    public static String getAllColumnsWithDefaultAlias(Class<?> entityClass) {
        Set columnSet = EntityHelper.getColumns(entityClass);
        StringBuilder sql = new StringBuilder();
        for (EntityColumn entityColumn : columnSet) {
            sql.append(" ").append(CustomSqlHelper.getDefaultAlias(entityClass).trim()).append(".").append(entityColumn.getColumn()).append(",");
        }
        return sql.substring(0, sql.length() - 1);
    }

    public static String getAssociatedColumnsWithDefaultAlias(Class<?> entityClass) {
        Set columnSet = EntityHelper.getColumns(entityClass);
        StringBuilder sql = new StringBuilder(",");
        for (EntityColumn entityColumn : columnSet) {
            if (!entityColumn.getEntityField().isAnnotationPresent(AssociatedTable.class)) continue;
            AssociatedTable associatedTable = (AssociatedTable)entityColumn.getEntityField().getAnnotation(AssociatedTable.class);
            sql.append(" ").append(CustomSqlHelper.getDefaultAlias(associatedTable.associatedClass()).trim()).append(".").append(associatedTable.associatedField()).append(" ").append(associatedTable.mappingField()).append(",");
        }
        return sql.length() == 1 ? "" : sql.substring(0, sql.length() - 1);
    }

    public static String getDefaultAlias(Class<?> entityClass) {
        StringBuilder sql = new StringBuilder(" ");
        return sql.append(entityClass.getSimpleName()).append(" ").toString();
    }

    public static String leftJoinWithDefaultAlias(Class<?> entityClass, EntityColumn entityColumn, AssociatedTable associatedTable, String defaultTableName) {
        StringBuilder sql = new StringBuilder();
        sql.append(" LEFT JOIN ");
        sql.append(SqlHelper.getDynamicTableName((Class)associatedTable.associatedClass(), (String)defaultTableName));
        sql.append(CustomSqlHelper.getDefaultAlias(associatedTable.associatedClass()));
        sql.append(" ON ");
        Set columnSet = EntityHelper.getPKColumns((Class)associatedTable.associatedClass());
        sql.append(associatedTable.mappingField().trim()).append(".").append(((EntityColumn)columnSet.iterator().next()).getEntityField().getName());
        sql.append(" = ");
        sql.append(CustomSqlHelper.getDefaultAlias(entityClass).trim()).append(".").append(entityColumn.getEntityField().getName());
        return sql.toString();
    }

    public static String wherePKColumnsWithDefaultAlias(Class<?> entityClass) {
        return CustomSqlHelper.wherePKColumnsWithDefaultAlias(entityClass, false);
    }

    public static String wherePKColumnsWithDefaultAlias(Class<?> entityClass, boolean useVersion) {
        return CustomSqlHelper.wherePKColumnsWithDefaultAlias(entityClass, null, useVersion);
    }

    public static String wherePKColumnsWithDefaultAlias(Class<?> entityClass, String entityName, boolean useVersion) {
        StringBuilder sql = new StringBuilder();
        sql.append("<where>");
        Set columnSet = EntityHelper.getPKColumns(entityClass);
        for (EntityColumn column : columnSet) {
            sql.append(" AND ");
            sql.append(CustomSqlHelper.getDefaultAlias(entityClass).trim()).append(".");
            sql.append(column.getColumnEqualsHolder(entityName));
        }
        if (useVersion) {
            sql.append(SqlHelper.whereVersion(entityClass));
        }
        sql.append("</where>");
        return sql.toString();
    }

    public static String exampleSelectColumnsWithDefaultAlias(Class<?> entityClass) {
        StringBuilder sql = new StringBuilder();
        sql.append("<choose>");
        sql.append("<when test=\"@tk.mybatis.mapper.util.OGNL@hasSelectColumns(_parameter)\">");
        sql.append("<foreach collection=\"_parameter.selectColumns\" item=\"selectColumn\" open=\"");
        sql.append(CustomSqlHelper.getDefaultAlias(entityClass).trim()).append(".");
        sql.append("\" separator=\",");
        sql.append(CustomSqlHelper.getDefaultAlias(entityClass).trim()).append(".");
        sql.append("\">");
        sql.append("${selectColumn}");
        sql.append("</foreach>");
        sql.append("</when>");
        sql.append("<otherwise>");
        sql.append(CustomSqlHelper.getAllColumnsWithDefaultAlias(entityClass));
        sql.append(CustomSqlHelper.getAssociatedColumnsWithDefaultAlias(entityClass));
        sql.append("</otherwise>");
        sql.append("</choose>");
        return sql.toString();
    }

    public static String exampleWhereClause(Class<?> entityClass) {
        return "<if test=\"_parameter != null\"><where>\n  <foreach collection=\"oredCriteria\" item=\"criteria\">\n    <if test=\"criteria.valid\">\n      ${@tk.mybatis.mapper.util.OGNL@andOr(criteria)}      <trim prefix=\"(\" prefixOverrides=\"and |or \" suffix=\")\">\n        <foreach collection=\"criteria.criteria\" item=\"criterion\">\n          <choose>\n            <when test=\"criterion.noValue\">\n              ${@tk.mybatis.mapper.util.OGNL@andOr(criterion)} " + CustomSqlHelper.getDefaultAlias(entityClass).trim() + ".${criterion.condition}\n            </when>\n            <when test=\"criterion.singleValue\">\n              ${@tk.mybatis.mapper.util.OGNL@andOr(criterion)} " + CustomSqlHelper.getDefaultAlias(entityClass).trim() + ".${criterion.condition} #{criterion.value}\n            </when>\n            <when test=\"criterion.betweenValue\">\n              ${@tk.mybatis.mapper.util.OGNL@andOr(criterion)} " + CustomSqlHelper.getDefaultAlias(entityClass).trim() + ".${criterion.condition} #{criterion.value} and #{criterion.secondValue}\n            </when>\n            <when test=\"criterion.listValue\">\n              ${@tk.mybatis.mapper.util.OGNL@andOr(criterion)} " + CustomSqlHelper.getDefaultAlias(entityClass).trim() + ".${criterion.condition}\n              <foreach close=\")\" collection=\"criterion.value\" item=\"listItem\" open=\"(\" separator=\",\">\n                #{listItem}\n              </foreach>\n            </when>\n          </choose>\n        </foreach>\n      </trim>\n    </if>\n  </foreach>\n</where></if>";
    }

    public static String getColumn() {
        return "<foreach collection=\"_parameter.fields\" index=\"index\" item=\"item\" separator=\",\">\r\n\t\t${item}\r\n\t</foreach> from  ${tableName[0]}";
    }

    public static String isUseAlias() {
        return "<if test=\"@com.cyberway.msf.commons.base.support.multitable.ExampleOGNL@useAlias(_parameter) \">\r\n\t\t\t${tableAlias[0]}\r\n\t\t</if>";
    }

    public static String isUseLeftJoin() {
        return "<if test=\"@com.cyberway.msf.commons.base.support.multitable.ExampleOGNL@useMultipartAndLeftJoin(_parameter)\">\r\n\t\t\tLEFT JOIN\r\n\t\t\t<foreach collection=\"tableAlias\" item=\"key\" index=\"index\" separator=\"\">\r\n\t\t\t\t<if test=\"index >= 1\">\r\n\t\t\t\t\t${tableName[1]} ${key}\r\n\t\t\t\t</if>\r\n\t\t\t</foreach>\r\n\t\t\tON ${leftJoinOn}\r\n\t\t</if>";
    }

    public static String useWhereAndEqualsWhere() {
        return "<if test=\"@com.cyberway.msf.commons.base.support.multitable.ExampleOGNL@useWhere(_parameter)\">\r\n\t\t\t<where>\r\n\t\t\t\t<if test=\"@com.cyberway.msf.commons.base.support.multitable.ExampleOGNL@useEqualsWhere(_parameter)\">\r\n\t\t\t\t\t<foreach collection=\"equalsWhereKey\" item=\"key\" index=\"index\" separator=\"AND\"> \t\t\t\t\t\t${key} = #{equalsWhereValue[${index}]} \t\t\t\t\t</foreach>\r\n\r\n\t\t\t\t\t<if test=\"@com.cyberway.msf.commons.base.support.multitable.ExampleOGNL@useGreaterAndLess(_parameter)\">\r\n\t\t\t\t\t\tAND\r\n\t\t\t\t\t</if>\r\n\t\t\t\t</if>";
    }

    public static String useGreaterThan() {
        return "<if test=\"@com.cyberway.msf.commons.base.support.multitable.ExampleOGNL@useGreaterThanWhere(_parameter)\">\r\n\t\t\t\t\t<foreach collection=\"greaterThanWhereKey\" item=\"key\" index=\"index\" separator=\"AND\"> \t\t\t\t\t\t${key} > #{greaterThanWhereValue[${index}]} \t\t\t\t\t</foreach>\r\n\t\t\t\t\t<if test=\"@com.cyberway.msf.commons.base.support.multitable.ExampleOGNL@useLessAndNotEquals(_parameter)\">\r\n\t\t\t\t\t\tAND\r\n\t\t\t\t\t</if>\r\n\t\t\t\t</if>";
    }

    public static String useLessThan() {
        return "<if test=\"@com.cyberway.msf.commons.base.support.multitable.ExampleOGNL@useLessThanWhere(_parameter)\">\r\n\t\t\t\t\t<foreach collection=\"lessThanWhereKey\" item=\"key\" index=\"index\" separator=\"AND\"> \t\t\t\t\t\t${key} &lt; #{lessThanWhereValue[${index}]} \t\t\t\t\t</foreach>\r\n\t\t\t\t\t<if test=\"@com.cyberway.msf.commons.base.support.multitable.ExampleOGNL@useNotEqualsWhere(_parameter)\">\r\n\t\t\t\t\t\tAND\r\n\t\t\t\t\t</if>\r\n\t\t\t\t</if>";
    }

    public static String useNotEquals() {
        return "<if test =\"@com.cyberway.msf.commons.base.support.multitable.ExampleOGNL@useNotEqualsWhere(_parameter)\">\r\n\t\t\t\t\t<foreach collection=\"notEqualsWhereKey\" item=\"key\" index=\"index\" separator=\"AND\"> \t\t\t\t\t\t${key} != #{notEqualsWhereValue[${index}]}  \t\t\t\t\t</foreach>\r\n\t\t\t\t</if>\r\n\t\t\t</where>\r\n\t\t</if>";
    }

    public static String notUseWhere() {
        return "<if test=\"@com.cyberway.msf.commons.base.support.multitable.ExampleOGNL@notUseWhere(_parameter)\">\r\n\t\t\tWHERE 1 = 1\r\n\t\t</if>";
    }

    public static String useIn() {
        return "<if test=\"@com.cyberway.msf.commons.base.support.multitable.ExampleOGNL@useIn(_parameter)\">\r\n\t\t\tAND\r\n\t\t\t<foreach collection=\"inFields\" item=\"field\" index=\"index\" separator=\"AND\">\r\n\t\t\t\t${field} in\r\n\t\t\t\t<choose>\r\n\t\t\t\t\t<when test=\"index == 0\">\r\n\t\t\t\t\t\t<foreach collection=\"inValue1\" item=\"value1\" index=\"index1\" separator=\",\" open=\"(\" close=\")\">\r\n\t\t\t\t\t\t\t#{value1}\r\n\t\t\t\t\t\t</foreach>\r\n\t\t\t\t\t</when>\r\n\t\t\t\t\t<otherwise>\r\n\t\t\t\t\t\t<foreach collection=\"inValue2\" item=\"value2\" index=\"index2\" separator=\",\" open=\"(\" close=\")\">\r\n\t\t\t\t\t\t\t#{value2}\r\n\t\t\t\t\t\t</foreach>\r\n\t\t\t\t\t</otherwise>\r\n\t\t\t\t</choose>\r\n\t\t\t</foreach>\r\n\t\t</if>";
    }

    public static String useLike() {
        return "<if test=\" @com.cyberway.msf.commons.base.support.multitable.ExampleOGNL@useLike(_parameter)\">\r\n\t\t\t<if test=\"@com.cyberway.msf.commons.base.support.multitable.ExampleOGNL@useIn(_parameter)\">\r\n\t\t\t\tAND\r\n\t\t\t</if>\r\n\t\t\t<foreach collection=\"likeFields\" item=\"field\" index=\"index\" separator=\"AND\">\r\n\t\t\t\t${field} LIKE #{likeValues[${index}]}\r\n\t\t\t</foreach>\r\n\t\t</if>";
    }

    public static String useGroup() {
        return "<if test=\"@com.cyberway.msf.commons.base.support.multitable.ExampleOGNL@useGroupBy(_parameter) \">\r\n\t\t\tGROUP BY ${groupBy}\r\n\t\t</if>";
    }

    public static String useOrder() {
        return "<if test=\"@com.cyberway.msf.commons.base.support.multitable.ExampleOGNL@useOrderBy(_parameter)\">\r\n\t\t\torder by \r\n\t\t\t<foreach collection=\"order.keys\" item=\"key\" index=\"index\" separator=\",\">\r\n\t\t\t\t${key} \t\t\t\t<choose>\r\n\t\t\t\t\t<when test=\"@com.cyberway.msf.commons.base.support.multitable.ExampleOGNL@orderByDesc(key,_parameter)\">\r\n\t\t\t\t\t\tDESC \r\n\t\t\t\t\t</when>\r\n\t\t\t\t\t<otherwise>\r\n\t\t\t\t\t\tASC\r\n\t\t\t\t\t</otherwise>\r\n\t\t\t\t</choose>\r\n\t\t\t</foreach>\r\n\t\t</if>";
    }
}

