/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.controller;

import com.cyberway.msf.commons.api.result.ApiResponseResult;
import com.cyberway.msf.commons.api.result.ApiResultCode;
import com.cyberway.msf.commons.base.controller.BaseVoController;
import com.cyberway.msf.commons.base.service.BaseService;
import com.cyberway.msf.commons.base.util.BusinessPreconditions;
import com.cyberway.msf.commons.base.util.MessageUtils;
import com.cyberway.msf.commons.model.base.EntityImpl;
import com.cyberway.msf.commons.model.filter.FilterModel;
import com.cyberway.msf.commons.model.page.PageDataModel;
import com.cyberway.msf.commons.model.valid.Insert;
import com.cyberway.msf.commons.model.valid.UpdateAll;
import com.cyberway.msf.commons.model.valid.UpdateSelected;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public class BaseController<T extends EntityImpl>
extends BaseVoController<T> {
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u8be6\u60c5", position=1)
    @GetMapping(value={"/{id}"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="id", paramType="path", required=true, dataType="string")})
    public ApiResponseResult<T> selectById(@PathVariable String id) {
        return this.getById(id, this.baseServiceImpl);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5217\u8868", position=1)
    @RequestMapping(value={"/list"}, method={RequestMethod.POST})
    @ApiImplicitParams(value={@ApiImplicitParam(name="filterModel", value="\u5206\u9875", paramType="body", required=true, dataType="FilterModel")})
    public ApiResponseResult<PageDataModel<T>> list(@RequestBody FilterModel filterModel) {
        ApiResponseResult res = null;
        PageDataModel pageDataModel = this.baseServiceImpl.selectByFiltersPaging(filterModel);
        res = new ApiResponseResult(ApiResultCode.SUCCESS, pageDataModel);
        return res;
    }

    @ApiOperation(value="\u65b0\u589e\u5b9e\u4f53", position=1)
    @PostMapping
    public ApiResponseResult insert(@RequestBody @Validated(value={Insert.class}) @Valid T entity) {
        return this.insert(entity, this.baseServiceImpl);
    }

    @ApiOperation(value="\u4fee\u6539\u5b9e\u4f53,\u53ea\u66f4\u65b0\u5c5e\u6027\u4e0d\u4e3anull\u7684\u5b57\u6bb5", position=1)
    @PutMapping(value={"/{id}"})
    public ApiResponseResult update(@PathVariable String id, @RequestBody @Validated(value={UpdateSelected.class}) @Valid T entity) {
        return this.update(id, entity, this.baseServiceImpl);
    }

    @ApiOperation(value="\u4fee\u6539\u5b9e\u4f53,\u4fee\u6539\u5168\u90e8\u5c5e\u6027")
    @PutMapping(value={"/updateAll/{id}"})
    public ApiResponseResult updateAll(@PathVariable String id, @RequestBody @Validated(value={UpdateAll.class}) @Valid T entity) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw MessageUtils.buildException(ApiResultCode.PARAM_IS_NULL, "id");
        }
        entity.setId((Serializable)((Object)id));
        int sum = this.baseServiceImpl.updateAll(entity);
        if (sum > 0) {
            return new ApiResponseResult(ApiResultCode.SUCCESS);
        }
        throw MessageUtils.buildException(ApiResultCode.UPDATE_DATA_FAIL, new Object[0]);
    }

    protected ApiResponseResult<T> getById(String id, BaseService<T> baseServiceImpl) {
        BusinessPreconditions.checkArgument(StringUtils.isNotEmpty((CharSequence)id), MessageUtils.buildException(ApiResultCode.PARAM_IS_NULL, "id"));
        EntityImpl entity = (EntityImpl)baseServiceImpl.selectById(id);
        if (null != entity) {
            return new ApiResponseResult(ApiResultCode.SUCCESS, (Object)entity);
        }
        throw MessageUtils.buildException(ApiResultCode.GET_DATA_NOT_EXIST, id);
    }

    protected ApiResponseResult<List<T>> selectByFilters(FilterModel filterModel, BaseService<T> baseServiceImpl) {
        BusinessPreconditions.checkArgument(filterModel != null, MessageUtils.buildException(ApiResultCode.PARAM_IS_NULL, new Object[0]));
        List<T> entities = baseServiceImpl.selectByFilters(filterModel);
        return new ApiResponseResult(ApiResultCode.SUCCESS, entities);
    }

    protected ApiResponseResult<Serializable> insert(T entity, BaseService<T> baseServiceImpl) {
        if (entity.getId() != null) {
            throw MessageUtils.buildException(ApiResultCode.PARAM_NOT_ALLOW, "id");
        }
        int sum = baseServiceImpl.insert(entity);
        if (sum > 0) {
            return new ApiResponseResult(ApiResultCode.SUCCESS, (Object)entity.getId());
        }
        throw MessageUtils.buildException(ApiResultCode.INSERT_DATA_FAIL, new Object[0]);
    }

    public ApiResponseResult<Integer> update(String id, T entity, BaseService<T> baseServiceImpl) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw MessageUtils.buildException(ApiResultCode.PARAM_IS_NULL, "id");
        }
        entity.setId((Serializable)((Object)id));
        int sum = baseServiceImpl.updateSelective(entity);
        if (sum > 0) {
            return new ApiResponseResult(ApiResultCode.SUCCESS);
        }
        throw MessageUtils.buildException(ApiResultCode.UPDATE_DATA_FAIL, new Object[0]);
    }
}

