/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.service;

import com.cyberway.msf.commons.api.result.ApiResultCode;
import com.cyberway.msf.commons.base.mapper.BaseMapper;
import com.cyberway.msf.commons.base.service.BaseEntityDelService;
import com.cyberway.msf.commons.base.service.BaseEntityServiceImpl;
import com.cyberway.msf.commons.base.util.BusinessPreconditions;
import com.cyberway.msf.commons.base.util.MessageUtils;
import com.cyberway.msf.commons.core.exception.BaseException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.transaction.annotation.Transactional;

public class BaseEntityDelServiceImpl<T>
extends BaseEntityServiceImpl
implements BaseEntityDelService<T> {
    @Autowired
    protected BaseMapper<T> baseMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int delete(Object primaryKey) {
        try {
            this.beforeDelete(primaryKey);
            int sum = this.baseMapper.deleteByPrimaryKey(primaryKey);
            if (sum > 0) {
                this.afterDelete(primaryKey);
            }
            return sum;
        }
        catch (DataIntegrityViolationException e) {
            throw new BaseException(ApiResultCode.DELETE_FAIL_REFERENCE.getResultCode(), ApiResultCode.DELETE_FAIL_REFERENCE.getResultMessage());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int batchDelete(List<String> primaryKeys) {
        BusinessPreconditions.checkArgument(CollectionUtils.isNotEmpty(primaryKeys), MessageUtils.buildException(ApiResultCode.PARAM_IS_NULL, "ids"));
        try {
            List primaryKeysWithoutBlank = primaryKeys.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(primaryKeysWithoutBlank)) {
                return 0;
            }
            this.beforeBatchDelete(primaryKeys);
            int sum = this.baseMapper.logicDeleteByIds(StringUtils.join((Iterable)primaryKeysWithoutBlank.stream().map(s -> StringUtils.wrap((String)s, (char)'\'')).collect(Collectors.toList()), (String)","));
            if (sum > 0) {
                this.afterBatchDelete(primaryKeys);
            }
            return sum;
        }
        catch (DataIntegrityViolationException e) {
            throw new BaseException(ApiResultCode.DELETE_FAIL_REFERENCE.getResultCode(), ApiResultCode.DELETE_FAIL_REFERENCE.getResultMessage());
        }
    }

    protected void beforeDelete(Object primaryKey) {
    }

    protected void beforeBatchDelete(List<String> primaryKeys) {
    }

    protected void afterDelete(Object primaryKey) {
    }

    protected void afterBatchDelete(List<String> primaryKeys) {
    }
}

