/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.support.configuration;

import com.cyberway.msf.commons.base.util.MqUtils;
import com.cyberway.msf.commons.base.util.MsUtils;
import com.cyberway.msf.commons.base.util.UserUtils;
import com.cyberway.msf.commons.model.user.UserInfo;
import java.util.Map;
import org.aopalliance.aop.Advice;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.listener.RabbitListenerContainerFactory;
import org.springframework.aop.AfterReturningAdvice;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.amqp.SimpleRabbitListenerContainerFactoryConfigurer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={RabbitTemplate.class})
public class MsConfig {
    @Bean
    @ConditionalOnMissingBean(value={MqUtils.class})
    public MqUtils mqUtils() {
        return new MqUtils();
    }

    @Bean
    @ConditionalOnMissingBean(value={MqUtils.class})
    public MsUtils msUtils() {
        return new MsUtils();
    }

    @Bean
    @ConditionalOnBean(value={ConnectionFactory.class, RabbitListenerContainerFactory.class})
    public SimpleRabbitListenerContainerFactory myContainerFactory(SimpleRabbitListenerContainerFactoryConfigurer configurer, ConnectionFactory connectionFactory) {
        SimpleRabbitListenerContainerFactory factory = new SimpleRabbitListenerContainerFactory();
        factory.setPrefetchCount(Integer.valueOf(1000));
        factory.setAfterReceivePostProcessors(new MessagePostProcessor[]{MsConfig::afterReceivePostProcessor});
        configurer.configure(factory, connectionFactory);
        return factory;
    }

    @Bean
    @ConditionalOnBean(value={CachingConnectionFactory.class})
    public RabbitTemplate rabbitTemplate(CachingConnectionFactory connectionFactory) {
        RabbitTemplate rabbitTemplate = new RabbitTemplate((ConnectionFactory)connectionFactory);
        rabbitTemplate.setBeforePublishPostProcessors(new MessagePostProcessor[]{MsConfig::beforePublishPostProcessor});
        return rabbitTemplate;
    }

    @Bean
    @ConditionalOnMissingBean
    public RabbitTemplateBeanPostProcessor rabbitTemplateBeanPostProcessor() {
        return new RabbitTemplateBeanPostProcessor();
    }

    private static Message beforePublishPostProcessor(Message message) throws AmqpException {
        UserInfo userInfo = UserUtils.getLoggedInUser();
        if (null != userInfo) {
            message.getMessageProperties().getHeaders().put("Authorization", userInfo.getToken());
        }
        return message;
    }

    private static Message afterReceivePostProcessor(Message message) throws AmqpException {
        Map header = message.getMessageProperties().getHeaders();
        String token = (String)header.get("Authorization");
        if (token != null) {
            UserInfo userInfo = UserUtils.getUserInfoByToken(token);
            UserUtils.setLocalUserInfo(userInfo, true);
        }
        return message;
    }

    class RabbitTemplateBeanPostProcessor
    implements BeanPostProcessor {
        RabbitTemplateBeanPostProcessor() {
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof RabbitTemplate) {
                RabbitTemplate rabbitTemplate = (RabbitTemplate)bean;
                rabbitTemplate.addBeforePublishPostProcessors(new MessagePostProcessor[]{x$0 -> MsConfig.beforePublishPostProcessor(x$0)});
            } else if (bean instanceof SimpleRabbitListenerContainerFactory) {
                SimpleRabbitListenerContainerFactory rabbitListenerContainerFactory = (SimpleRabbitListenerContainerFactory)bean;
                rabbitListenerContainerFactory.setAfterReceivePostProcessors(new MessagePostProcessor[]{x$0 -> MsConfig.afterReceivePostProcessor(x$0)});
                AfterReturningAdvice advice = (returnValue, method, args, target) -> UserUtils.resetLocalUserInfo();
                Object[] advices = rabbitListenerContainerFactory.getAdviceChain();
                advices = advices != null ? (Advice[])ArrayUtils.add((Object[])advices, (Object)advice) : new Advice[]{advice};
                rabbitListenerContainerFactory.setAdviceChain((Advice[])advices);
            }
            return bean;
        }
    }
}

