/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.support.interceptor;

import com.alibaba.fastjson.JSONObject;
import com.cyberway.msf.commons.base.support.constant.CommonsBaseConstants;
import com.cyberway.msf.commons.base.support.interceptor.OrgFilter;
import com.cyberway.msf.commons.base.util.UserUtils;
import com.cyberway.msf.commons.model.user.UserInfo;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tk.mybatis.mapper.MapperException;
import tk.mybatis.mapper.util.MsUtil;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class QueryInterceptor
implements Interceptor {
    private static final Logger logger = LoggerFactory.getLogger(QueryInterceptor.class);
    private static final List<String> MULTI_LIST = Arrays.asList("multiTableSelectByExample", "multiTableSelectByPrimaryKey", "multiTableSelectByExample_COUNT", "multiTableSelectByPrimaryKey_COUNT");
    private static final List<String> IGNORE_METHOD_LIST = Arrays.asList("selectByPrimaryKey", "existsWithPrimaryKey");

    public Object intercept(Invocation invocation) throws Throwable {
        CacheKey cacheKey;
        BoundSql boundSql;
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        String methodName = MsUtil.getMethodName((String)StringUtils.defaultString((String)ms.getId()));
        if (IGNORE_METHOD_LIST.contains(methodName)) {
            return invocation.proceed();
        }
        Object parameter = args[1];
        RowBounds rowBounds = (RowBounds)args[2];
        ResultHandler resultHandler = (ResultHandler)args[3];
        Executor executor = (Executor)invocation.getTarget();
        if (args.length == 4) {
            boundSql = ms.getBoundSql(parameter);
            cacheKey = executor.createCacheKey(ms, parameter, rowBounds, boundSql);
        } else {
            cacheKey = (CacheKey)args[4];
            boundSql = (BoundSql)args[5];
        }
        String orgSql = this.getOrgSql(ms, boundSql, parameter, rowBounds, cacheKey);
        BoundSql orgBoundSql = new BoundSql(ms.getConfiguration(), orgSql, boundSql.getParameterMappings(), parameter);
        for (ParameterMapping mapping : boundSql.getParameterMappings()) {
            String prop = mapping.getProperty();
            if (!boundSql.hasAdditionalParameter(prop)) continue;
            orgBoundSql.setAdditionalParameter(prop, boundSql.getAdditionalParameter(prop));
        }
        return executor.query(ms, parameter, rowBounds, resultHandler, cacheKey, orgBoundSql);
    }

    private String getOrgSql(MappedStatement ms, BoundSql boundSql, Object parameter, RowBounds rowBounds, CacheKey cacheSql) {
        String sql = boundSql.getSql();
        String orgId = "";
        String tenantId = "";
        JSONObject json = null;
        UserInfo userInfo = UserUtils.getLoggedInUser();
        if (userInfo == null) {
            if (CommonsBaseConstants.ORGFILTER_WITH_AND.matcher(sql).find()) {
                sql = CommonsBaseConstants.ORGFILTER_WITH_AND.matcher(sql).replaceAll("");
            } else if (CommonsBaseConstants.ORGFILTER.matcher(sql).find()) {
                sql = CommonsBaseConstants.ORGFILTER.matcher(sql).replaceAll("");
            }
            return sql;
        }
        orgId = userInfo.getOrgId();
        tenantId = userInfo.getTenantId();
        String id = ms.getId();
        if (StringUtils.isEmpty((CharSequence)id)) {
            return sql;
        }
        String orgStr = "";
        Class<?> cls = null;
        try {
            cls = MsUtil.getMapperClass((String)id);
        }
        catch (MapperException e) {
            logger.warn("\u5f53\u524d\u7f13\u5b58\u4e2d\u4e0d\u5b58\u5728\u8be5Mapper Class");
        }
        if (cls == null) {
            String className = id.substring(0, id.lastIndexOf("."));
            try {
                cls = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                logger.warn("\u65e0\u6cd5\u627e\u5230Mapper Class");
            }
        }
        if (cls != null && cls.isAnnotationPresent(OrgFilter.class)) {
            Method[] methods;
            if (MULTI_LIST.contains(MsUtil.getMethodName((String)id))) {
                sql = StringUtils.replace((String)sql, (String)"#_TENANTID", (String)("'" + tenantId + "'"));
                sql = StringUtils.replace((String)sql, (String)"#_ORGID", (String)("'" + orgId + "'"));
                return sql;
            }
            OrgFilter orgFilter = cls.getAnnotation(OrgFilter.class);
            String value = null;
            String mapperMethodName = MsUtil.getMethodName((String)id);
            for (Method method : methods = cls.getDeclaredMethods()) {
                if (!method.getName().equals(mapperMethodName) && !(method.getName() + "_COUNT").equals(mapperMethodName)) continue;
                if (method.isAnnotationPresent(OrgFilter.class)) {
                    orgFilter = method.getAnnotation(OrgFilter.class);
                }
                if (method.isAnnotationPresent(SelectProvider.class)) break;
                value = orgFilter.value();
                break;
            }
            if (orgFilter.ignore()) {
                return sql;
            }
            json = JSONObject.parseObject((String)userInfo.getJson());
            orgStr = json != null && StringUtils.isNotEmpty((CharSequence)json.getString(orgFilter.extra())) ? (!orgFilter.tenantOnly() ? this.getOrgStr(orgId, tenantId, value, orgFilter.extra(), json.getString(orgFilter.extra())) : this.getOrgStr(tenantId, value, orgFilter.extra(), json.getString(orgFilter.extra()))) : (!orgFilter.tenantOnly() ? this.getOrgStr(orgId, tenantId, value) : this.getOrgStr(tenantId, value));
            if (StringUtils.isEmpty((CharSequence)orgStr)) {
                return sql;
            }
            sql = CommonsBaseConstants.WHERE.matcher(sql).find() ? (CommonsBaseConstants.EXISTS.matcher(sql).find() ? CommonsBaseConstants.WHERE.matcher(sql).replaceFirst(orgStr + " AND ") : CommonsBaseConstants.WHERE.matcher(sql).replaceAll(orgStr + " AND ")) : (CommonsBaseConstants.GROUP.matcher(sql).find() ? CommonsBaseConstants.GROUP.matcher(sql).replaceAll(orgStr + " GROUP ") : (CommonsBaseConstants.ORDER.matcher(sql).find() ? CommonsBaseConstants.ORDER.matcher(sql).replaceAll(orgStr + " ORDER ") : (CommonsBaseConstants.LIMIT.matcher(sql).find() ? CommonsBaseConstants.LIMIT.matcher(sql).replaceAll(orgStr + " LIMIT ") : sql + orgStr)));
        }
        return sql;
    }

    private String getOrgStr(String tenantId, String value, String extra, String extraValue) {
        return this.getOrgStr(null, tenantId, value, extra, extraValue);
    }

    private String getOrgStr(String orgId, String tenantId, String value, String extra, String extraValue) {
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" WHERE ").append("(");
        String alias = "";
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            alias = value + '.';
        }
        if (StringUtils.isNotEmpty((CharSequence)extra) && StringUtils.isNotEmpty((CharSequence)extraValue)) {
            sb.append(alias).append(extra).append(" = ").append('\'').append(extraValue).append('\'').append(" AND ");
        }
        sb.append(alias).append("tenantId").append(" = ").append('\'').append(tenantId).append('\'').append(" ");
        if (StringUtils.isNotEmpty((CharSequence)orgId)) {
            sb.append(" AND ").append(alias).append("orgId").append(" = ").append('\'').append(orgId).append('\'').append(" ");
        }
        sb.append(")");
        return sb.toString();
    }

    private String getOrgStr(String orgId, String tenantId, String value) {
        return this.getOrgStr(orgId, tenantId, value, null, null);
    }

    private String getOrgStr(String tenantId, String value) {
        return this.getOrgStr(null, tenantId, value);
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }
}

