/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.util;

import com.alibaba.fastjson.JSON;
import com.cyberway.msf.commons.base.support.configuration.CommonsBaseProperties;
import com.cyberway.msf.commons.cache.RedisUtils;
import com.cyberway.msf.commons.model.user.UserInfo;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class UserUtils {
    private static final ThreadLocal<UserInfo> currentUserHolder = new ThreadLocal();
    private static final ThreadLocal<UserInfo> inheritableCurrentUserHolder = new InheritableThreadLocal<UserInfo>();
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private CommonsBaseProperties commonsBaseProperties;
    private static UserUtils userUtils;

    @PostConstruct
    public void init() {
        userUtils = this;
    }

    private static UserInfo getLocalUserInfo() {
        UserInfo userInfo = currentUserHolder.get();
        if (null == userInfo) {
            userInfo = inheritableCurrentUserHolder.get();
        }
        return userInfo;
    }

    public static void setLocalUserInfo(UserInfo userInfo, boolean inheritable) {
        if (userInfo == null) {
            UserUtils.resetLocalUserInfo();
        } else if (inheritable) {
            inheritableCurrentUserHolder.set(userInfo);
            currentUserHolder.remove();
        } else {
            currentUserHolder.set(userInfo);
            inheritableCurrentUserHolder.remove();
        }
    }

    public static void resetLocalUserInfo() {
        currentUserHolder.remove();
        inheritableCurrentUserHolder.remove();
    }

    public static String getCurrentToken() {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attributes != null) {
            HttpServletRequest request = attributes.getRequest();
            return request.getHeader("Authorization");
        }
        return null;
    }

    public static UserInfo getLoggedInUser() {
        String token = UserUtils.getCurrentToken();
        if (token == null) {
            return UserUtils.getLocalUserInfo();
        }
        String key = "auth_user_token_" + token;
        String userJson = (String)UserUtils.userUtils.redisUtils.getOrigin(key);
        if (null == userJson) {
            return null;
        }
        UserInfo userInfo = (UserInfo)JSON.parseObject((String)userJson, UserInfo.class);
        userInfo.setToken(token);
        return userInfo;
    }

    public static UserInfo getUserInfoByToken(String token) {
        if (token == null) {
            return null;
        }
        String key = "auth_user_token_" + token;
        String userJson = (String)UserUtils.userUtils.redisUtils.getOrigin(key);
        return null == userJson ? null : (UserInfo)JSON.parseObject((String)userJson, UserInfo.class);
    }

    public static String getOrgId() {
        UserInfo userInfo = UserUtils.getLoggedInUser();
        return userInfo == null ? "" : userInfo.getOrgId();
    }

    public static String getTenantId() {
        UserInfo userInfo = UserUtils.getLoggedInUser();
        return userInfo == null ? "" : userInfo.getTenantId();
    }

    public static Boolean isAdministrator() {
        UserInfo userInfo = UserUtils.getLoggedInUser();
        if (userInfo == null) {
            return false;
        }
        List roleTypes = (List)UserUtils.userUtils.redisUtils.getOrigin(String.format("roleType:%s", userInfo.getId()));
        return CollectionUtils.isNotEmpty((Collection)roleTypes) && roleTypes.contains("Administrator");
    }

    public static Boolean isSuperAdministrator() {
        UserInfo userInfo = UserUtils.getLoggedInUser();
        if (userInfo == null) {
            return false;
        }
        List roleTypes = (List)UserUtils.userUtils.redisUtils.getOrigin(String.format("roleType:%s", userInfo.getId()));
        return CollectionUtils.isNotEmpty((Collection)roleTypes) && roleTypes.contains("SuperAdministrator");
    }

    public static Boolean isSystemAdministrator() {
        UserInfo userInfo = UserUtils.getLoggedInUser();
        if (userInfo == null) {
            return false;
        }
        List roleTypes = (List)UserUtils.userUtils.redisUtils.getOrigin(String.format("roleType:%s", userInfo.getId()));
        return CollectionUtils.isNotEmpty((Collection)roleTypes) && roleTypes.contains("SystemAdministrator");
    }

    public static Boolean isSuperTenantAdmin() {
        UserInfo userInfo = UserUtils.getLoggedInUser();
        return null != userInfo && "0000".equals(userInfo.getTenantCode());
    }

    public static Boolean isSingleTenant() {
        return Boolean.TRUE.equals(UserUtils.userUtils.commonsBaseProperties.getSingleTenant());
    }

    public static UserInfo getAnonymousUser(String tenantId, String orgId) {
        UserInfo userInfo = null;
        String token = tenantId + orgId;
        String key = "auth_user_token_" + token;
        String userJson = (String)UserUtils.userUtils.redisUtils.getOrigin(key);
        if (null == userJson) {
            userInfo = new UserInfo();
            userInfo.setTenantId(tenantId);
            userInfo.setOrgId(orgId);
            userInfo.setToken(token);
            userInfo.setFullName("system");
            UserUtils.userUtils.redisUtils.setOrigin(key, (Object)JSON.toJSONString((Object)userInfo));
        } else {
            userInfo = (UserInfo)JSON.parseObject((String)userJson, UserInfo.class);
            userInfo.setToken(token);
        }
        return userInfo;
    }
}

