/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.service;

import com.cyberway.msf.commons.api.result.ApiResultCode;
import com.cyberway.msf.commons.base.service.BaseEntityDelServiceImpl;
import com.cyberway.msf.commons.base.service.BaseService;
import com.cyberway.msf.commons.base.support.multitable.MultiSqls;
import com.cyberway.msf.commons.base.support.multitable.MultiTableExample;
import com.cyberway.msf.commons.base.support.multitable.MultiTableSelectExample;
import com.cyberway.msf.commons.base.support.provider.CustomSqlHelper;
import com.cyberway.msf.commons.base.support.provider.ExampleOGNL;
import com.cyberway.msf.commons.base.util.DateUtils;
import com.cyberway.msf.commons.base.util.MessageUtils;
import com.cyberway.msf.commons.base.util.PageUtils;
import com.cyberway.msf.commons.base.util.SqlUtils;
import com.cyberway.msf.commons.model.annotation.AssociatedTable;
import com.cyberway.msf.commons.model.base.BusinessFullHierarchicalEntityWithCo;
import com.cyberway.msf.commons.model.base.BusinessFullHierarchicalEntityWithOrg;
import com.cyberway.msf.commons.model.base.EntityImpl;
import com.cyberway.msf.commons.model.filter.FieldType;
import com.cyberway.msf.commons.model.filter.Filter;
import com.cyberway.msf.commons.model.filter.FilterModel;
import com.cyberway.msf.commons.model.filter.Operation;
import com.cyberway.msf.commons.model.page.Orders;
import com.cyberway.msf.commons.model.page.PageDataModel;
import com.cyberway.msf.commons.model.page.PageModel;
import java.lang.reflect.ParameterizedType;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.persistence.Column;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.MapperException;
import tk.mybatis.mapper.entity.EntityColumn;
import tk.mybatis.mapper.entity.Example;
import tk.mybatis.mapper.mapperhelper.EntityHelper;
import tk.mybatis.mapper.util.Sqls;

public class BaseServiceImpl<T>
extends BaseEntityDelServiceImpl<T>
implements BaseService<T> {
    private static final String[] TENANT_PROPERTIES = new String[]{"id", "createdBy", "createdByName", "createdDate", "lastModifiedBy", "lastModifiedByName", "lastModified", "owner", "systemLastModified", "tenantId", "orgId"};

    @Override
    public T selectById(Object primaryKey) {
        Class entityClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        Set columnSet = EntityHelper.getColumns((Class)entityClass);
        for (EntityColumn entityColumn : columnSet) {
            if (!entityColumn.getEntityField().isAnnotationPresent(AssociatedTable.class)) continue;
            return this.multiTableSelectByPrimaryKey(primaryKey, columnSet, entityClass);
        }
        return (T)this.baseMapper.selectByPrimaryKey(primaryKey);
    }

    private T multiTableSelectByPrimaryKey(Object primaryKey, Set<EntityColumn> columnSet, Class<T> entityClass) {
        MultiTableSelectExample example = new MultiTableSelectExample(entityClass);
        this.generateAssociation(columnSet, example);
        example.addPrimaryKey(primaryKey);
        return (T)this.baseMapper.multiTableSelectByPrimaryKey(example);
    }

    private void generateAssociation(Set<EntityColumn> columnSet, MultiTableSelectExample example) {
        for (EntityColumn entityColumn : columnSet) {
            if (!entityColumn.getEntityField().isAnnotationPresent(AssociatedTable.class)) continue;
            AssociatedTable associatedTable = (AssociatedTable)entityColumn.getEntityField().getAnnotation(AssociatedTable.class);
            Set associatedColumnSet = EntityHelper.getPKColumns((Class)associatedTable.associatedClass());
            example.addLeftJoin(MultiSqls.custom().leftJoin(EntityHelper.getEntityTable((Class)associatedTable.associatedClass()).getName(), associatedTable.mappingField()).on(entityColumn.getEntityField().isAnnotationPresent(Column.class) ? ((Column)entityColumn.getEntityField().getAnnotation(Column.class)).name() : entityColumn.getEntityField().getName(), ((EntityColumn)associatedColumnSet.iterator().next()).getEntityField().getName()));
            example.selectAssociatedProperty(associatedTable.mappingField(), associatedTable.associatedField(), associatedTable.mappingField());
        }
    }

    @Override
    public List<T> selectAll() {
        return this.baseMapper.selectAll();
    }

    @Override
    public List<T> selectByExample(Object example) {
        return this.baseMapper.selectByExample(example);
    }

    @Override
    public List<T> selectByFilters(FilterModel filterModel) {
        Class entityClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        boolean multiFlag = false;
        Set columnSet = EntityHelper.getColumns((Class)entityClass);
        for (EntityColumn entityColumn : columnSet) {
            if (!entityColumn.getEntityField().isAnnotationPresent(AssociatedTable.class)) continue;
            multiFlag = true;
            break;
        }
        try {
            MultiTableSelectExample example;
            if (multiFlag) {
                example = new MultiTableSelectExample(entityClass);
                this.generaExample(example, filterModel, columnSet, entityClass);
                return this.baseMapper.multiTableSelectByExample(example);
            }
            example = new Example(entityClass);
            this.generaExample(example, filterModel);
            return this.selectByExample(example);
        }
        catch (MapperException e) {
            throw MessageUtils.buildException(ApiResultCode.QUERY_DATA_FAIL, e.getMessage());
        }
    }

    @Override
    public PageDataModel<T> selectByFiltersPaging(FilterModel filterModel) {
        Class entityClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        boolean multiFlag = false;
        Set columnSet = EntityHelper.getColumns((Class)entityClass);
        for (EntityColumn entityColumn : columnSet) {
            if (!entityColumn.getEntityField().isAnnotationPresent(AssociatedTable.class)) continue;
            multiFlag = true;
            break;
        }
        try {
            MultiTableSelectExample example;
            if (multiFlag) {
                example = new MultiTableSelectExample(entityClass);
                this.generaExample(example, filterModel, columnSet, entityClass);
                String orderBy = this.generaOrderBy(filterModel, example, entityClass);
                PageUtils.sortAndPagination((PageModel)filterModel, orderBy);
                return PageUtils.getPageDataModel((PageModel)filterModel, this.baseMapper.multiTableSelectByExample(example));
            }
            PageUtils.sortAndPagination((PageModel)filterModel);
            example = new Example(entityClass);
            this.generaExample(example, filterModel);
            return PageUtils.getPageDataModel((PageModel)filterModel, this.selectByExample(example));
        }
        catch (MapperException e) {
            throw MessageUtils.buildException(ApiResultCode.QUERY_DATA_FAIL, e.getMessage());
        }
    }

    private String generaOrderBy(FilterModel filterModel, MultiTableSelectExample example, Class<T> entityClass) {
        if (filterModel == null) {
            return "";
        }
        List orders = filterModel.getOrders();
        if (CollectionUtils.isEmpty((Collection)orders)) {
            return "";
        }
        StringBuilder orderBy = new StringBuilder();
        for (Orders order : orders) {
            String sort;
            String prefix;
            if (StringUtils.isEmpty((CharSequence)order.getSort()) || StringUtils.isEmpty((CharSequence)order.getOrder())) continue;
            PageUtils.sqlValidate(order.getSort(), order.getOrder());
            String string = prefix = StringUtils.indexOf((CharSequence)order.getSort(), (CharSequence)".") < 0 ? "" : StringUtils.substringBefore((String)order.getSort(), (String)".");
            if (StringUtils.isNotEmpty((CharSequence)prefix) && !CustomSqlHelper.getDefaultAlias(entityClass).trim().equals(prefix)) {
                sort = order.getSort();
                orderBy.append(sort).append(' ').append(order.getOrder()).append(",");
                continue;
            }
            sort = StringUtils.substring((String)order.getSort(), (int)(StringUtils.indexOf((CharSequence)order.getSort(), (CharSequence)".") + 1));
            orderBy.append(ExampleOGNL.getTableAlias(example)).append(".").append(sort).append(' ').append(order.getOrder()).append(",");
        }
        return StringUtils.removeEnd((String)orderBy.toString(), (String)",");
    }

    protected void generaExample(Example example, FilterModel filterModel) {
        if (filterModel == null || CollectionUtils.isEmpty((Collection)filterModel.getFilters())) {
            return;
        }
        Example.Criteria criteria = example.createCriteria();
        for (Filter filter : filterModel.getFilters()) {
            Operation operation = filter.getOperation();
            String field = StringUtils.substring((String)filter.getField(), (int)(StringUtils.indexOf((CharSequence)filter.getField(), (CharSequence)".") + 1));
            this.getFilterExample(filter, operation, field, criteria);
        }
        if (CollectionUtils.isEmpty((Collection)criteria.getCriteria())) {
            example.getOredCriteria().remove(criteria);
        }
    }

    protected void generaExample(MultiTableSelectExample example, FilterModel filterModel, Set<EntityColumn> columnSet, Class<T> entityClass) {
        this.generateAssociation(columnSet, example);
        if (filterModel == null || CollectionUtils.isEmpty((Collection)filterModel.getFilters())) {
            return;
        }
        Example.Criteria exampleCriteria = example.createCriteria();
        MultiTableExample.MultiTableCriteria multiTableCriteria = example.createMultiTableCriteria();
        example.and(multiTableCriteria);
        for (Filter filter : filterModel.getFilters()) {
            String field;
            String prefix;
            Operation operation = filter.getOperation();
            String string = prefix = StringUtils.indexOf((CharSequence)filter.getField(), (CharSequence)".") < 0 ? "" : StringUtils.substringBefore((String)filter.getField(), (String)".");
            if (StringUtils.isNotEmpty((CharSequence)prefix) && !CustomSqlHelper.getDefaultAlias(entityClass).trim().equals(prefix)) {
                field = filter.getField();
                this.getFilterExample(filter, operation, field, multiTableCriteria);
                continue;
            }
            field = StringUtils.substring((String)filter.getField(), (int)(StringUtils.indexOf((CharSequence)filter.getField(), (CharSequence)".") + 1));
            this.getFilterExample(filter, operation, field, exampleCriteria);
        }
        if (CollectionUtils.isEmpty((Collection)exampleCriteria.getCriteria())) {
            example.getOredCriteria().remove(exampleCriteria);
        }
        if (CollectionUtils.isEmpty((Collection)multiTableCriteria.getCriteria())) {
            example.getOredCriteria().remove((Object)multiTableCriteria);
        }
    }

    private void getFilterExample(Filter filter, Operation operation, String field, Example.Criteria criteria) {
        Object value = filter.getValue();
        if (value == null) {
            return;
        }
        if (FieldType.String.equals((Object)filter.getFieldType())) {
            if (value instanceof String && StringUtils.isEmpty((CharSequence)((String)value))) {
                return;
            }
            if (value instanceof List && CollectionUtils.isEmpty((Collection)((List)value))) {
                return;
            }
        }
        if (FieldType.Date.equals((Object)filter.getFieldType()) || FieldType.DateTime.equals((Object)filter.getFieldType())) {
            Calendar calendar = Calendar.getInstance();
            Date time = null;
            time = value instanceof Date ? (Date)value : DateUtils.parseDate(value);
            if (time == null) {
                throw MessageUtils.buildException(ApiResultCode.REQUIRE_PARAM_IS_ERROR, new Object[0]);
            }
            calendar.setTime(time);
            if (FieldType.Date.equals((Object)filter.getFieldType())) {
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
            }
            if (Operation.GreaterThan.equals((Object)operation) || Operation.GreaterThanEq.equals((Object)operation)) {
                value = calendar.getTime();
            }
            if (Operation.LessThan.equals((Object)operation) || Operation.LessThanEq.equals((Object)operation)) {
                if (FieldType.Date.equals((Object)filter.getFieldType()) && Operation.LessThanEq.equals((Object)operation)) {
                    calendar.add(5, 1);
                    calendar.add(14, -1);
                }
                value = calendar.getTime();
            }
        }
        switch (operation) {
            case Eq: {
                criteria.andEqualTo(field, value);
                break;
            }
            case NotEq: {
                criteria.andNotEqualTo(field, value);
                break;
            }
            case StartsWith: {
                if (!FieldType.String.equals((Object)filter.getFieldType())) break;
                criteria.andLike(field, SqlUtils.matchStart((String)value));
                break;
            }
            case EndsWith: {
                if (!FieldType.String.equals((Object)filter.getFieldType())) break;
                criteria.andLike(field, SqlUtils.matchEnd((String)value));
                break;
            }
            case Contains: {
                if (!FieldType.String.equals((Object)filter.getFieldType())) break;
                criteria.andLike(field, SqlUtils.matchAnywhere((String)value));
                break;
            }
            case NotContains: {
                if (!FieldType.String.equals((Object)filter.getFieldType())) break;
                criteria.andNotLike(field, SqlUtils.matchAnywhere((String)value));
                break;
            }
            case LessThan: {
                criteria.andLessThan(field, value);
                break;
            }
            case GreaterThan: {
                criteria.andGreaterThan(field, value);
                break;
            }
            case LessThanEq: {
                criteria.andLessThanOrEqualTo(field, value);
                break;
            }
            case GreaterThanEq: {
                criteria.andGreaterThanOrEqualTo(field, value);
                break;
            }
            case InList: {
                if (!(value instanceof Iterable)) break;
                criteria.andIn(field, (Iterable)value);
                break;
            }
            case NotInList: {
                if (!(value instanceof Iterable)) break;
                criteria.andNotIn(field, (Iterable)value);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int updateSelective(T entity) {
        this.validateData(entity, "updateSelective");
        this.beforeSave(entity, "updateSelective");
        this.getFullHierarchicalEntity(entity);
        int result = this.baseMapper.updateByPrimaryKeySelective(entity);
        if (result > 0) {
            this.afterSave(entity, "updateSelective");
        }
        return result;
    }

    @Override
    @Deprecated
    @Transactional(rollbackFor={Exception.class})
    public int update(T entity) {
        this.validateData(entity, "update");
        this.beforeSave(entity, "update");
        this.getFullHierarchicalEntity(entity);
        int result = this.baseMapper.updateByPrimaryKeySelective(entity);
        if (result > 0) {
            this.afterSave(entity, "update");
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int updateAll(T entity) {
        int result;
        this.validateData(entity, "updateAll");
        this.beforeSave(entity, "updateAll");
        this.getFullHierarchicalEntity(entity);
        if (EntityImpl.class.isAssignableFrom(entity.getClass())) {
            T old = this.selectById(((EntityImpl)entity).getId());
            BeanUtils.copyProperties(entity, old, (String[])TENANT_PROPERTIES);
            entity = old;
        }
        if ((result = this.baseMapper.updateByPrimaryKey(entity)) > 0) {
            this.afterSave(entity, "updateAll");
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int insert(T entity) {
        this.validateData(entity, "insert");
        this.beforeSave(entity, "insert");
        this.getFullHierarchicalEntity(entity);
        int result = this.baseMapper.insertSelective(entity);
        if (result > 0) {
            this.afterSave(entity, "insert");
        }
        return result;
    }

    @Override
    public Boolean containsByEntity(T entity) {
        return this.baseMapper.selectCount(entity) > 0;
    }

    @Override
    public Boolean contains(Object example) {
        return this.baseMapper.selectCountByExample(example) > 0;
    }

    protected void validateData(T entity) {
    }

    protected void validateData(T entity, String methodName) {
        this.validateData(entity);
    }

    protected void beforeSave(T entity) {
    }

    protected void beforeSave(T entity, String methodName) {
        this.beforeSave(entity);
    }

    protected void afterSave(T entity) {
    }

    protected void afterSave(T entity, String methodName) {
        this.afterSave(entity);
    }

    protected void validateUnique(Class<?> clazz, EntityImpl<String> entity, String property, Object value, ApiResultCode exceptionResultCode) {
        this.validateUnique(clazz, entity, property, value, exceptionResultCode, false);
    }

    protected void validateUnique(EntityImpl<String> entity, String property, Object value, ApiResultCode exceptionResultCode) {
        this.validateUnique(entity, property, value, exceptionResultCode, false);
    }

    protected void validateUnique(Class<?> clazz, EntityImpl<String> entity, String property, Object value, ApiResultCode exceptionResultCode, Boolean ignoreDeleted) {
        if (value == null) {
            return;
        }
        Sqls sqls = Sqls.custom().andNotEqualTo("id", (Object)StringUtils.defaultString((String)((String)((Object)entity.getId())))).andEqualTo(property, value);
        if (ignoreDeleted.booleanValue()) {
            sqls.andEqualTo("deleted", (Object)Boolean.FALSE);
        }
        if (CollectionUtils.isNotEmpty(this.selectByExample(Example.builder(clazz).where(sqls).build()))) {
            throw MessageUtils.buildException(exceptionResultCode, value);
        }
    }

    protected void validateUnique(EntityImpl<String> entity, String property, Object value, ApiResultCode exceptionResultCode, Boolean ignoreDeleted) {
        if (value == null) {
            return;
        }
        Sqls sqls = Sqls.custom().andNotEqualTo("id", (Object)StringUtils.defaultString((String)((String)((Object)entity.getId())))).andEqualTo(property, value);
        if (ignoreDeleted.booleanValue()) {
            sqls.andEqualTo("deleted", (Object)Boolean.FALSE);
        }
        if (CollectionUtils.isNotEmpty(this.selectByExample(Example.builder(entity.getClass()).where(sqls).build()))) {
            throw MessageUtils.buildException(exceptionResultCode, value);
        }
    }

    protected void validateBySqls(Class<?> clazz, Sqls sqls, ApiResultCode exceptionResultCode, Object ... errorArgs) {
        if (CollectionUtils.isNotEmpty(this.selectByExample(Example.builder(clazz).where(sqls).build()))) {
            throw MessageUtils.buildException(exceptionResultCode, errorArgs);
        }
    }

    private void getFullHierarchicalEntity(T entity) {
        if (BusinessFullHierarchicalEntityWithOrg.class.isAssignableFrom(entity.getClass())) {
            String parent = ((BusinessFullHierarchicalEntityWithOrg)entity).getParent();
            if (StringUtils.isEmpty((CharSequence)parent)) {
                ((BusinessFullHierarchicalEntityWithOrg)entity).setFullPathName(((BusinessFullHierarchicalEntityWithOrg)entity).getName());
                return;
            }
            BusinessFullHierarchicalEntityWithOrg parentEntity = (BusinessFullHierarchicalEntityWithOrg)this.selectById(parent);
            if (null == parentEntity) {
                ((BusinessFullHierarchicalEntityWithOrg)entity).setFullPathName(((BusinessFullHierarchicalEntityWithOrg)entity).getName());
                return;
            }
            String parentAllParent = StringUtils.isBlank((CharSequence)parentEntity.getAllParent()) ? "" : " " + parentEntity.getAllParent();
            ((BusinessFullHierarchicalEntityWithOrg)entity).setAllParent(parent + parentAllParent);
            String parentFullPathName = StringUtils.isBlank((CharSequence)parentEntity.getFullPathName()) ? "" : parentEntity.getFullPathName() + '/';
            ((BusinessFullHierarchicalEntityWithOrg)entity).setFullPathName(parentFullPathName + ((BusinessFullHierarchicalEntityWithOrg)entity).getName());
        } else if (BusinessFullHierarchicalEntityWithCo.class.isAssignableFrom(entity.getClass())) {
            String parent = ((BusinessFullHierarchicalEntityWithCo)entity).getParent();
            if (StringUtils.isEmpty((CharSequence)parent)) {
                ((BusinessFullHierarchicalEntityWithCo)entity).setFullPathName(((BusinessFullHierarchicalEntityWithCo)entity).getName());
                return;
            }
            BusinessFullHierarchicalEntityWithCo parentEntity = (BusinessFullHierarchicalEntityWithCo)this.selectById(parent);
            if (null == parentEntity) {
                ((BusinessFullHierarchicalEntityWithCo)entity).setFullPathName(((BusinessFullHierarchicalEntityWithCo)entity).getName());
                return;
            }
            String parentAllParent = StringUtils.isBlank((CharSequence)parentEntity.getAllParent()) ? "" : " " + parentEntity.getAllParent();
            ((BusinessFullHierarchicalEntityWithCo)entity).setAllParent(parent + parentAllParent);
            String parentFullPathName = StringUtils.isBlank((CharSequence)parentEntity.getFullPathName()) ? "" : parentEntity.getFullPathName() + '/';
            ((BusinessFullHierarchicalEntityWithCo)entity).setFullPathName(parentFullPathName + ((BusinessFullHierarchicalEntityWithCo)entity).getName());
        }
    }
}

