/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.support.interceptor;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLValuableExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.cyberway.msf.commons.base.support.configuration.CommonsBaseProperties;
import com.cyberway.msf.commons.base.util.IpUtils;
import com.cyberway.msf.commons.base.util.LogUtils;
import com.cyberway.msf.commons.base.util.UserUtils;
import com.cyberway.msf.commons.model.user.UserInfo;
import com.cyberway.msf.log.model.ChangeFieldInfo;
import com.cyberway.msf.log.model.DataChangeLog;
import com.google.gson.Gson;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class DataChangeLogInterceptor
implements Interceptor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final CommonsBaseProperties commonsBaseProperties;
    private final Gson gson = new Gson();

    protected DataChangeLogInterceptor(CommonsBaseProperties commonsBaseProperties) {
        this.commonsBaseProperties = commonsBaseProperties;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        Object result = invocation.proceed();
        if (invocation.getArgs()[0] instanceof MappedStatement) {
            try {
                MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
                SqlCommandType sqlCommandType = mappedStatement.getSqlCommandType();
                Object parameter = null;
                if (invocation.getArgs().length > 1) {
                    parameter = invocation.getArgs()[1];
                }
                BoundSql boundSql = mappedStatement.getBoundSql(parameter);
                switch (sqlCommandType) {
                    case INSERT: {
                        this.logInsert(boundSql, mappedStatement.getConfiguration(), parameter);
                        break;
                    }
                    case UPDATE: {
                        this.logUpdate(boundSql, mappedStatement.getConfiguration(), parameter);
                        break;
                    }
                    case DELETE: {
                        this.logDelete(boundSql, mappedStatement.getConfiguration(), parameter);
                    }
                }
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    private void logInsert(BoundSql boundSql, Configuration configuration, Object parameter) {
        SQLStatement sqlStatement = this.buildSQLStatementParser(boundSql.getSql()).parseInsert();
        if (parameter == null) {
            return;
        }
        if (sqlStatement instanceof SQLInsertStatement) {
            SQLInsertStatement sqlInsertStatement = (SQLInsertStatement)sqlStatement;
            if (this.commonsBaseProperties.getDataLog().getIgnoreTables().contains(sqlInsertStatement.getTableName().getSimpleName().toLowerCase())) {
                return;
            }
            MetaObject metaObject = configuration.newMetaObject(parameter);
            List columns = sqlInsertStatement.getColumns();
            List valuesList = sqlInsertStatement.getValuesList();
            if (valuesList.size() != 1) {
                return;
            }
            List values = ((SQLInsertStatement.ValuesClause)valuesList.get(0)).getValues();
            if (columns.size() == values.size()) {
                DataChangeLog dataChangeLog = this.initDataChangeLog("insert", sqlInsertStatement.getTableName().getSimpleName());
                for (int i = 0; i < columns.size(); ++i) {
                    SQLExpr column = (SQLExpr)columns.get(i);
                    if (!(column instanceof SQLIdentifierExpr)) continue;
                    SQLIdentifierExpr columnExpr = (SQLIdentifierExpr)column;
                    ChangeFieldInfo changeFieldInfo = new ChangeFieldInfo();
                    changeFieldInfo.setHasChanged(true);
                    SQLExpr value = (SQLExpr)values.get(i);
                    if (value instanceof SQLVariantRefExpr) {
                        String name = ((SQLVariantRefExpr)value).getName();
                        changeFieldInfo.setNewValue(this.formatValue(boundSql, metaObject, "?".equals(name) ? columnExpr.getName() : name));
                    } else if (value instanceof SQLValuableExpr) {
                        Object fieldValue = ((SQLValuableExpr)value).getValue();
                        changeFieldInfo.setNewValue(this.formatObject(fieldValue));
                    } else if (value != null) {
                        changeFieldInfo.setNewValue(this.formatObject(value));
                    }
                    if ("id".equalsIgnoreCase(columnExpr.getName())) {
                        dataChangeLog.setDataId(changeFieldInfo.getNewValue());
                    }
                    dataChangeLog.getFields().put(columnExpr.getName(), changeFieldInfo);
                }
                LogUtils.logDataChange(dataChangeLog);
            }
        }
    }

    private void logUpdate(BoundSql boundSql, Configuration configuration, Object parameter) {
        SQLUpdateStatement sqlUpdateStatement = this.buildSQLStatementParser(boundSql.getSql()).parseUpdateStatement();
        if (this.commonsBaseProperties.getDataLog().getIgnoreTables().contains(sqlUpdateStatement.getTableName().getSimpleName().toLowerCase())) {
            return;
        }
        if (sqlUpdateStatement.getWhere() instanceof SQLBinaryOpExpr && ((SQLBinaryOpExpr)sqlUpdateStatement.getWhere()).getOperator().equals((Object)SQLBinaryOperator.Equality)) {
            this.handleEqUpdate(sqlUpdateStatement, (SQLBinaryOpExpr)sqlUpdateStatement.getWhere(), boundSql, configuration, parameter);
        } else if (this.commonsBaseProperties.getDataLog().isIgnoreDeletedWhere() && sqlUpdateStatement.getWhere() instanceof SQLBinaryOpExpr && ((SQLBinaryOpExpr)sqlUpdateStatement.getWhere()).getOperator().equals((Object)SQLBinaryOperator.BooleanAnd)) {
            SQLExpr idExpr = null;
            SQLBinaryOpExpr where = (SQLBinaryOpExpr)sqlUpdateStatement.getWhere();
            if (this.checkDeletedExpr(where.getLeft())) {
                idExpr = where.getRight();
            } else if (this.checkDeletedExpr(where.getRight())) {
                idExpr = where.getLeft();
            }
            if (idExpr instanceof SQLBinaryOpExpr) {
                this.handleEqUpdate(sqlUpdateStatement, (SQLBinaryOpExpr)idExpr, boundSql, configuration, parameter);
            }
        } else if (sqlUpdateStatement.getWhere() instanceof SQLInListExpr) {
            SQLInListExpr where = (SQLInListExpr)sqlUpdateStatement.getWhere();
            this.handleInUpdate(sqlUpdateStatement, where, boundSql, configuration, parameter);
        }
    }

    private boolean checkDeletedExpr(SQLExpr sqlExpr) {
        if (sqlExpr instanceof SQLBinaryOpExpr) {
            SQLBinaryOpExpr sqlBinaryOpExpr = (SQLBinaryOpExpr)sqlExpr;
            return sqlBinaryOpExpr.getOperator().equals((Object)SQLBinaryOperator.Equality) && sqlBinaryOpExpr.getLeft() instanceof SQLIdentifierExpr && ((SQLIdentifierExpr)sqlBinaryOpExpr.getLeft()).getName().equalsIgnoreCase(this.commonsBaseProperties.getDataLog().getDeletedFieldName());
        }
        return false;
    }

    private void handleEqUpdate(SQLUpdateStatement sqlUpdateStatement, SQLBinaryOpExpr where, BoundSql boundSql, Configuration configuration, Object parameter) {
        String leftName;
        SQLExpr left = where.getLeft();
        if (left instanceof SQLIdentifierExpr && (leftName = ((SQLIdentifierExpr)left).getName()).equalsIgnoreCase("id")) {
            MetaObject metaObject = configuration.newMetaObject(parameter);
            DataChangeLog dataChangeLog = this.buildUpdateDataChangeLog(sqlUpdateStatement, boundSql, metaObject);
            this.logIdParamWhere(boundSql, where, leftName, dataChangeLog, metaObject);
        }
    }

    private void handleInUpdate(SQLUpdateStatement sqlUpdateStatement, SQLInListExpr where, BoundSql boundSql, Configuration configuration, Object parameter) {
        if (where.getExpr() instanceof SQLIdentifierExpr && ((SQLIdentifierExpr)where.getExpr()).getName().equalsIgnoreCase("id")) {
            MetaObject metaObject = configuration.newMetaObject(parameter);
            DataChangeLog dataChangeLog = this.buildUpdateDataChangeLog(sqlUpdateStatement, boundSql, metaObject);
            for (SQLExpr sqlExpr : where.getTargetList()) {
                if (!(sqlExpr instanceof SQLValuableExpr)) continue;
                DataChangeLog cloneDataChangeLog = new DataChangeLog();
                BeanUtils.copyProperties((Object)dataChangeLog, (Object)cloneDataChangeLog, (String[])new String[]{"fields"});
                cloneDataChangeLog.setFields(new HashMap());
                for (String field : dataChangeLog.getFields().keySet()) {
                    ChangeFieldInfo changeFieldInfo = new ChangeFieldInfo();
                    BeanUtils.copyProperties(dataChangeLog.getFields().get(field), (Object)changeFieldInfo);
                    cloneDataChangeLog.getFields().put(field, changeFieldInfo);
                }
                cloneDataChangeLog.setDataId(this.formatObject(((SQLValuableExpr)sqlExpr).getValue()));
                LogUtils.logDataChange(cloneDataChangeLog);
            }
        }
    }

    private DataChangeLog buildUpdateDataChangeLog(SQLUpdateStatement sqlUpdateStatement, BoundSql boundSql, MetaObject metaObject) {
        DataChangeLog dataChangeLog = this.initDataChangeLog("update", sqlUpdateStatement.getTableName().getSimpleName());
        for (SQLUpdateSetItem item : sqlUpdateStatement.getItems()) {
            if (!(item.getColumn() instanceof SQLIdentifierExpr)) continue;
            ChangeFieldInfo changeFieldInfo = new ChangeFieldInfo();
            if (item.getValue() instanceof SQLVariantRefExpr) {
                String name = ((SQLVariantRefExpr)item.getValue()).getName();
                changeFieldInfo.setNewValue(this.formatValue(boundSql, metaObject, "?".equals(name) ? ((SQLIdentifierExpr)item.getColumn()).getName() : name));
            } else if (item.getValue() instanceof SQLValuableExpr) {
                Object fieldValue = ((SQLValuableExpr)item.getValue()).getValue();
                changeFieldInfo.setNewValue(this.formatObject(fieldValue));
            } else if (item.getValue() != null) {
                changeFieldInfo.setNewValue(this.formatObject(item.getValue()));
            }
            dataChangeLog.getFields().put(((SQLIdentifierExpr)item.getColumn()).getName(), changeFieldInfo);
        }
        return dataChangeLog;
    }

    private void logDelete(BoundSql boundSql, Configuration configuration, Object parameter) {
        SQLInListExpr where;
        SQLDeleteStatement sqlDeleteStatement = this.buildSQLStatementParser(boundSql.getSql()).parseDeleteStatement();
        if (this.commonsBaseProperties.getDataLog().getIgnoreTables().contains(sqlDeleteStatement.getTableName().getSimpleName().toLowerCase())) {
            return;
        }
        if (sqlDeleteStatement.getWhere() instanceof SQLBinaryOpExpr && ((SQLBinaryOpExpr)sqlDeleteStatement.getWhere()).getOperator().equals((Object)SQLBinaryOperator.Equality)) {
            String leftName;
            SQLBinaryOpExpr where2 = (SQLBinaryOpExpr)sqlDeleteStatement.getWhere();
            SQLExpr left = where2.getLeft();
            if (left instanceof SQLIdentifierExpr && (leftName = ((SQLIdentifierExpr)left).getName()).equalsIgnoreCase("id")) {
                DataChangeLog dataChangeLog = this.initDataChangeLog("delete", sqlDeleteStatement.getTableName().getSimpleName());
                MetaObject metaObject = configuration.newMetaObject(parameter);
                this.logIdParamWhere(boundSql, where2, leftName, dataChangeLog, metaObject);
            }
        } else if (sqlDeleteStatement.getWhere() instanceof SQLInListExpr && (where = (SQLInListExpr)sqlDeleteStatement.getWhere()).getExpr() instanceof SQLIdentifierExpr && ((SQLIdentifierExpr)where.getExpr()).getName().equalsIgnoreCase("id")) {
            Date now = new Date();
            for (SQLExpr sqlExpr : where.getTargetList()) {
                if (!(sqlExpr instanceof SQLValuableExpr)) continue;
                DataChangeLog dataChangeLog = this.initDataChangeLog("delete", sqlDeleteStatement.getTableName().getSimpleName(), now);
                dataChangeLog.setDataId(this.formatObject(((SQLValuableExpr)sqlExpr).getValue()));
                LogUtils.logDataChange(dataChangeLog);
            }
        }
    }

    private void logIdParamWhere(BoundSql boundSql, SQLBinaryOpExpr where, String leftName, DataChangeLog dataChangeLog, MetaObject metaObject) {
        if (where.getRight() instanceof SQLVariantRefExpr) {
            String name = ((SQLVariantRefExpr)where.getRight()).getName();
            dataChangeLog.setDataId(this.formatValue(boundSql, metaObject, "?".equals(name) ? leftName : name));
        } else if (where.getRight() instanceof SQLValuableExpr) {
            Object fieldValue = ((SQLValuableExpr)where.getRight()).getValue();
            dataChangeLog.setDataId(this.formatObject(fieldValue));
        }
        if (StringUtils.isNotBlank((CharSequence)dataChangeLog.getDataId())) {
            LogUtils.logDataChange(dataChangeLog);
        }
    }

    private String formatValue(BoundSql boundSql, MetaObject metaObject, String parameterName) {
        if (metaObject.hasGetter(parameterName)) {
            Object value = metaObject.getValue(parameterName);
            return this.formatObject(value);
        }
        if (boundSql.hasAdditionalParameter(parameterName)) {
            Object additionalParameter = boundSql.getAdditionalParameter(parameterName);
            return this.formatObject(additionalParameter);
        }
        return null;
    }

    private String formatObject(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Number || obj instanceof String || obj instanceof Character || obj instanceof Boolean || obj instanceof Date) {
            return obj.toString();
        }
        return this.gson.toJson(obj);
    }

    private DataChangeLog initDataChangeLog(String sqlType, String tableName) {
        return this.initDataChangeLog(sqlType, tableName, new Date());
    }

    private DataChangeLog initDataChangeLog(String sqlType, String tableName, Date changeTime) {
        DataChangeLog dataChangeLog = new DataChangeLog();
        dataChangeLog.setChangeTime(changeTime);
        dataChangeLog.setSqlType(sqlType);
        dataChangeLog.setTableName(tableName);
        dataChangeLog.setFields(new HashMap());
        try {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
            dataChangeLog.setRequestUrl(request.getRequestURI());
            dataChangeLog.setClientIp(IpUtils.getRemoteAddr(request));
            dataChangeLog.setRequestMethod(request.getMethod());
            UserInfo loggedInUser = UserUtils.getLoggedInUser();
            if (loggedInUser != null) {
                dataChangeLog.setOperatorId((String)((Object)loggedInUser.getId()));
                dataChangeLog.setOperatorName(loggedInUser.getUsername());
                dataChangeLog.setOperatorFullName(loggedInUser.getFullName());
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return dataChangeLog;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    protected abstract SQLStatementParser buildSQLStatementParser(String var1);
}

