/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.util;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class IpUtils {
    private static final int INNER_ADDR_IP4_SIZE = 4;
    private static final byte BYTE_IP_0_PART1 = 0;
    private static final byte BYTE_IP_10_PART1 = 10;
    private static final byte BYTE_IP_127_PART1 = 127;
    private static final byte BYTE_IP_172_PART1 = -84;
    private static final byte BYTE_IP_172_PART2_MIN = 16;
    private static final byte BYTE_IP_172_PART2_MAX = 31;
    private static final byte BYTE_IP_192_PART1 = -64;
    private static final byte BYTE_IP_192_PART2 = -88;
    private static final String UNKNOWN = "unknown";

    private IpUtils() {
    }

    public static String getRemoteAddr(HttpServletRequest request) {
        if (request == null) {
            return "";
        }
        String remoteAddress = request.getHeader("X-FORWARDED-FOR");
        if (StringUtils.isNotBlank((CharSequence)remoteAddress) && !remoteAddress.trim().equalsIgnoreCase(UNKNOWN)) {
            String[] remoteAddressArray = remoteAddress.split(",");
            for (int i = remoteAddressArray.length - 1; i >= 0; --i) {
                String ip = ((String)StringUtils.defaultIfBlank((CharSequence)remoteAddressArray[i], (CharSequence)"")).trim();
                if (!StringUtils.isNotBlank((CharSequence)ip) || ip.equalsIgnoreCase(UNKNOWN) || IpUtils.isPrivateIp(ip)) continue;
                return ip;
            }
        }
        return request.getRemoteAddr();
    }

    private static boolean isPrivateIp(String ip) {
        block8: {
            block7: {
                byte[] ipParts = IpUtils.textToNumericFormatV4(ip);
                if (ipParts.length == 0) break block7;
                switch (ipParts[0]) {
                    case 0: 
                    case 10: 
                    case 127: {
                        return true;
                    }
                    case -84: {
                        if (ipParts[1] >= 16 && ipParts[1] <= 31) {
                            return true;
                        }
                        break block8;
                    }
                    case -64: {
                        if (ipParts[1] == -88) {
                            return true;
                        } else {
                            break;
                        }
                    }
                }
                break block8;
            }
            return true;
        }
        return false;
    }

    public static byte[] textToNumericFormatV4(String src) {
        byte[] res = new byte[4];
        long tmpValue = 0L;
        int currByte = 0;
        boolean newOctet = true;
        int len = src.length();
        if (len == 0 || len > 15) {
            return new byte[0];
        }
        for (int i = 0; i < len; ++i) {
            char c = src.charAt(i);
            if (c == '.') {
                if (newOctet || tmpValue < 0L || tmpValue > 255L || currByte == 3) {
                    return new byte[0];
                }
                res[currByte++] = (byte)(tmpValue & 0xFFL);
                tmpValue = 0L;
                newOctet = true;
                continue;
            }
            int digit = Character.digit(c, 10);
            if (digit < 0) {
                return new byte[0];
            }
            tmpValue *= 10L;
            tmpValue += (long)digit;
            newOctet = false;
        }
        if (newOctet || tmpValue < 0L || tmpValue >= 1L << (4 - currByte) * 8) {
            return new byte[0];
        }
        switch (currByte) {
            case 0: {
                res[0] = (byte)(tmpValue >> 24 & 0xFFL);
            }
            case 1: {
                res[1] = (byte)(tmpValue >> 16 & 0xFFL);
            }
            case 2: {
                res[2] = (byte)(tmpValue >> 8 & 0xFFL);
            }
            case 3: {
                res[3] = (byte)(tmpValue & 0xFFL);
            }
        }
        return res;
    }
}

