/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.cache;

import com.cyberway.msf.commons.cache.RedisProperties;
import com.cyberway.msf.commons.cache.RedisUtils;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import redis.clients.jedis.JedisPoolConfig;

@Configuration
@EnableConfigurationProperties(value={RedisProperties.class})
public class RedisConfig {
    @Autowired
    private RedisProperties redisProperties;

    @Bean
    RedisMessageListenerContainer container(RedisConnectionFactory connectionFactory) {
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory(connectionFactory);
        return container;
    }

    @Bean
    public RedisClusterConfiguration redisClusterConfiguration() {
        RedisClusterConfiguration redisClusterConfiguration = new RedisClusterConfiguration();
        if (CollectionUtils.isEmpty(this.redisProperties.getNodes())) {
            return redisClusterConfiguration;
        }
        List<String> nodes = this.redisProperties.getNodes();
        List<RedisNode> nodeList = this.getNodeList(nodes);
        redisClusterConfiguration.setClusterNodes(nodeList);
        if (this.redisProperties.getMaxRedirects() != null) {
            redisClusterConfiguration.setMaxRedirects(this.redisProperties.getMaxRedirects().intValue());
        }
        return redisClusterConfiguration;
    }

    @Bean
    public RedisStandaloneConfiguration redisStandaloneConfiguration() {
        RedisStandaloneConfiguration redisStandaloneConfiguration = new RedisStandaloneConfiguration();
        if (CollectionUtils.isEmpty(this.redisProperties.getNodes())) {
            return redisStandaloneConfiguration;
        }
        List<String> nodes = this.redisProperties.getNodes();
        String[] nodeObj = nodes.get(0).trim().split(":");
        if (nodeObj.length > 1) {
            String host = nodeObj[0];
            String port = nodeObj[1];
            if (this.isNotEmpty(host) && this.isNotEmpty(port)) {
                redisStandaloneConfiguration.setHostName(host);
                redisStandaloneConfiguration.setPort(Integer.valueOf(port).intValue());
            }
        }
        return redisStandaloneConfiguration;
    }

    @Bean
    public JedisPoolConfig jedisPoolConfig() {
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        if (null != this.redisProperties.getMaxTotal()) {
            jedisPoolConfig.setMaxTotal(this.redisProperties.getMaxTotal().intValue());
        }
        if (null != this.redisProperties.getMaxIdle()) {
            jedisPoolConfig.setMaxIdle(this.redisProperties.getMaxIdle().intValue());
        }
        if (null != this.redisProperties.getMinIdle()) {
            jedisPoolConfig.setMinIdle(this.redisProperties.getMinIdle().intValue());
        }
        if (null != this.redisProperties.getMaxWaitMillis()) {
            jedisPoolConfig.setMaxWaitMillis(this.redisProperties.getMaxWaitMillis().longValue());
        }
        if (null != this.redisProperties.getMinEvictableIdleTimeMillis()) {
            jedisPoolConfig.setMinEvictableIdleTimeMillis(this.redisProperties.getMinEvictableIdleTimeMillis().longValue());
        }
        if (null != this.redisProperties.getNumTestsPerEvictionRun()) {
            jedisPoolConfig.setNumTestsPerEvictionRun(this.redisProperties.getNumTestsPerEvictionRun().intValue());
        }
        if (null != this.redisProperties.getTimeBetweenEvictionRunsMillis()) {
            jedisPoolConfig.setTimeBetweenEvictionRunsMillis(this.redisProperties.getTimeBetweenEvictionRunsMillis().longValue());
        }
        if (null != this.redisProperties.getTestOnBorrow()) {
            jedisPoolConfig.setTestOnBorrow(this.redisProperties.getTestOnBorrow().booleanValue());
        }
        return jedisPoolConfig;
    }

    @Bean
    public JedisConnectionFactory jedisConnectionFactory(RedisClusterConfiguration redisClusterConfiguration, RedisStandaloneConfiguration redisStandaloneConfiguration, JedisPoolConfig jedisPoolConfig) {
        JedisConnectionFactory jedisConnectionFactory = null;
        jedisConnectionFactory = this.redisProperties.getCluster() != false && this.redisProperties.getUsePool() != false ? new JedisConnectionFactory(redisClusterConfiguration, jedisPoolConfig) : (this.redisProperties.getCluster() != false ? new JedisConnectionFactory(redisClusterConfiguration) : new JedisConnectionFactory(redisStandaloneConfiguration));
        if (null != this.redisProperties.getTimeout()) {
            jedisConnectionFactory.setTimeout(this.redisProperties.getTimeout().intValue());
        }
        return jedisConnectionFactory;
    }

    @Bean
    public RedisTemplate redisTemplate(JedisConnectionFactory jedisConnectionFactory) {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory((RedisConnectionFactory)jedisConnectionFactory);
        redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        return redisTemplate;
    }

    @Bean
    public RedisUtils redisUtils() {
        return new RedisUtils();
    }

    private boolean isNotEmpty(String str) {
        return !StringUtils.isEmpty((Object)str) && !StringUtils.isEmpty((Object)str.trim());
    }

    private List<RedisNode> getNodeList(List<String> nodes) {
        ArrayList<RedisNode> nodeList = new ArrayList<RedisNode>();
        if (!CollectionUtils.isEmpty(nodes)) {
            for (String node : nodes) {
                RedisNode redisNode;
                if (!this.isNotEmpty(node) || null == (redisNode = this.getRedisNode(node))) continue;
                nodeList.add(redisNode);
            }
            return nodeList;
        }
        return nodeList;
    }

    private RedisNode getRedisNode(String node) {
        String[] nodeObj = node.trim().split(":");
        if (nodeObj.length > 1) {
            String host = nodeObj[0];
            String port = nodeObj[1];
            return this.isNotEmpty(host) && this.isNotEmpty(port) ? new RedisNode(host, Integer.valueOf(port).intValue()) : null;
        }
        return null;
    }
}

