/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.cache;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.support.atomic.RedisAtomicLong;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class RedisUtils {
    private final RedisTemplate<String, Object> redisTemplate;
    private final Environment env;
    private static final Logger logger = LoggerFactory.getLogger(RedisUtils.class);

    public RedisUtils(RedisTemplate<String, Object> redisTemplate, Environment env) {
        this.redisTemplate = redisTemplate;
        this.env = env;
    }

    public void set(String key, Object value) {
        if (null != key) {
            this.redisTemplate.opsForValue().set((Object)this.getKey(key), value);
        }
    }

    public void set(String key, Object value, long time) {
        if (null != key) {
            this.set(key, value);
            this.expire(key, time);
        }
    }

    public Object get(String key) {
        return null != key ? this.redisTemplate.opsForValue().get((Object)this.getKey(key)) : null;
    }

    public void del(String ... key) {
        if (key != null && key.length > 0) {
            ArrayList<String> delKeys = new ArrayList<String>();
            for (String k : key) {
                if (StringUtils.isEmpty((Object)k)) continue;
                delKeys.add(this.getKey(k));
            }
            this.redisTemplate.delete(delKeys);
        }
    }

    public void expire(String key, long time) {
        if (time > 0L) {
            this.redisTemplate.expire((Object)this.getKey(key), time, TimeUnit.SECONDS);
        }
    }

    public long generate(String key) {
        RedisAtomicLong counter = new RedisAtomicLong(this.getKey(key), this.redisTemplate.getConnectionFactory());
        return counter.incrementAndGet();
    }

    public long generate(String key, Date expireTime) {
        RedisAtomicLong counter = new RedisAtomicLong(this.getKey(key), this.redisTemplate.getConnectionFactory());
        counter.expireAt(expireTime);
        return counter.incrementAndGet();
    }

    public long generate(String key, int increment) {
        RedisAtomicLong counter = new RedisAtomicLong(this.getKey(key), this.redisTemplate.getConnectionFactory());
        return counter.addAndGet((long)increment);
    }

    public long generate(String key, int increment, Date expireTime) {
        RedisAtomicLong counter = new RedisAtomicLong(this.getKey(key), this.redisTemplate.getConnectionFactory());
        counter.expireAt(expireTime);
        return counter.addAndGet((long)increment);
    }

    private StringBuilder getPreKey() {
        StringBuilder buffer = new StringBuilder();
        String appName = this.env.getProperty("spring.application.name");
        if (!StringUtils.isEmpty((Object)appName)) {
            buffer.append(appName).append(":");
        }
        return buffer;
    }

    private String getKey(String key) {
        return !StringUtils.isEmpty((Object)key) ? this.getPreKey().append(key).toString() : key;
    }

    public String generateLockKey(String key) {
        return String.format("LOCK:%s", this.getKey(key));
    }

    public void setOrigin(String key, Object value) {
        if (null != key) {
            this.redisTemplate.opsForValue().set((Object)key, value);
        }
    }

    public void setOrigin(String key, Object value, long time) {
        if (null != key) {
            this.setOrigin(key, value);
            if (time > 0L) {
                this.redisTemplate.expire((Object)key, time, TimeUnit.SECONDS);
            }
        }
    }

    public Object getOrigin(String key) {
        return null != key ? this.redisTemplate.opsForValue().get((Object)key) : null;
    }

    public void delOrigin(String ... key) {
        if (key != null && key.length > 0) {
            ArrayList<String> delKeys = new ArrayList<String>();
            for (String k : key) {
                if (StringUtils.isEmpty((Object)k)) continue;
                delKeys.add(k);
                this.redisTemplate.delete((Object)k);
            }
            this.redisTemplate.delete(delKeys);
        }
    }

    public boolean lock(String key) {
        return this.lock(key, 30L);
    }

    public boolean lock(String key, long time) {
        return this.lockOrigin(this.generateLockKey(key), time);
    }

    public void unlock(String key) {
        this.unlockOrigin(this.generateLockKey(key));
    }

    public boolean lockOrigin(String key, long time) {
        if (!StringUtils.isEmpty((Object)key)) {
            return false;
        }
        try {
            RedisSerializer serializer = this.redisTemplate.getStringSerializer();
            if (this.redisTemplate.getConnectionFactory().getConnection().setNX(serializer.serialize((Object)key), new byte[0]).booleanValue()) {
                this.redisTemplate.expire((Object)key, time, TimeUnit.SECONDS);
                logger.debug("add RedisLock[" + key + "].");
                return true;
            }
        }
        catch (Exception e) {
            this.unlockOrigin(key);
        }
        return false;
    }

    public void unlockOrigin(String key) {
        if (!StringUtils.isEmpty((Object)key)) {
            logger.debug("release RedisLock[" + key + "].");
            RedisSerializer serializer = this.redisTemplate.getStringSerializer();
            this.redisTemplate.getConnectionFactory().getConnection().del((byte[][])new byte[][]{serializer.serialize((Object)key)});
        }
    }

    public boolean lockBusiness(String key, long time) {
        String lockKey = this.generateLockKey(key);
        if (this.lockOrigin(lockKey, time)) {
            this.set(lockKey, DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            return true;
        }
        return false;
    }

    public boolean isvalidLockBusiness(String key, long time) {
        String lockKey = this.generateLockKey(key);
        Object value = this.get(lockKey);
        if (null != value && !"".equals(value)) {
            try {
                long times = (new Date().getTime() - DateUtils.parseDate((String)value.toString(), (String[])new String[]{"yyyy-MM-dd HH:mm:ss"}).getTime()) / 1000L;
                if (times < time) {
                    return true;
                }
            }
            catch (ParseException e) {
                return false;
            }
        }
        return false;
    }

    public void unlockBusiness(String key) {
        String lockKey = this.generateLockKey(key);
        this.unlockOrigin(lockKey);
        this.del(lockKey);
    }
}

