/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.lock.redisson;

import com.cyberway.msf.commons.lock.redisson.BaseProperties;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="commons.lock.redisson")
public class RedissonProperties {
    private Integer threads = 0;
    private Integer nettyThreads = 0;
    private String codec = "org.redisson.codec.JsonJacksonCodec";
    private ConfigFile configFile = new ConfigFile();
    private SingleServerConfig singleServerConfig = new SingleServerConfig();
    private ClusterServersConfig clusterServersConfig = new ClusterServersConfig();

    public Integer getThreads() {
        return this.threads;
    }

    public void setThreads(Integer threads) {
        this.threads = threads;
    }

    public Integer getNettyThreads() {
        return this.nettyThreads;
    }

    public void setNettyThreads(Integer nettyThreads) {
        this.nettyThreads = nettyThreads;
    }

    public String getCodec() {
        return this.codec;
    }

    public void setCodec(String codec) {
        this.codec = codec;
    }

    public ConfigFile getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(ConfigFile configFile) {
        this.configFile = configFile;
    }

    public SingleServerConfig getSingleServerConfig() {
        return this.singleServerConfig;
    }

    public void setSingleServerConfig(SingleServerConfig singleServerConfig) {
        this.singleServerConfig = singleServerConfig;
    }

    public ClusterServersConfig getClusterServersConfig() {
        return this.clusterServersConfig;
    }

    public void setClusterServersConfig(ClusterServersConfig clusterServersConfig) {
        this.clusterServersConfig = clusterServersConfig;
    }

    public static class ClusterServersConfig
    extends BaseProperties {
        private String loadBalancer = "org.redisson.connection.balancer.RoundRobinLoadBalancer";
        private Integer slaveConnectionMinimumIdleSize = 32;
        private Integer slaveConnectionPoolSize = 64;
        private Integer masterConnectionMinimumIdleSize = 32;
        private Integer masterConnectionPoolSize = 64;
        private String readMode = "SLAVE";
        private List<String> nodeAddresses = new ArrayList<String>();
        private Integer scanInterval = 1000;

        public String getLoadBalancer() {
            return this.loadBalancer;
        }

        public void setLoadBalancer(String loadBalancer) {
            this.loadBalancer = loadBalancer;
        }

        public Integer getSlaveConnectionPoolSize() {
            return this.slaveConnectionPoolSize;
        }

        public void setSlaveConnectionPoolSize(Integer slaveConnectionPoolSize) {
            this.slaveConnectionPoolSize = slaveConnectionPoolSize;
        }

        public Integer getMasterConnectionMinimumIdleSize() {
            return this.masterConnectionMinimumIdleSize;
        }

        public void setMasterConnectionMinimumIdleSize(Integer masterConnectionMinimumIdleSize) {
            this.masterConnectionMinimumIdleSize = masterConnectionMinimumIdleSize;
        }

        public Integer getMasterConnectionPoolSize() {
            return this.masterConnectionPoolSize;
        }

        public void setMasterConnectionPoolSize(Integer masterConnectionPoolSize) {
            this.masterConnectionPoolSize = masterConnectionPoolSize;
        }

        public String getReadMode() {
            return this.readMode;
        }

        public void setReadMode(String readMode) {
            this.readMode = readMode;
        }

        public List<String> getNodeAddresses() {
            return this.nodeAddresses;
        }

        public void setNodeAddresses(List<String> nodeAddresses) {
            this.nodeAddresses = nodeAddresses;
        }

        public Integer getScanInterval() {
            return this.scanInterval;
        }

        public void setScanInterval(Integer scanInterval) {
            this.scanInterval = scanInterval;
        }

        public Integer getSlaveConnectionMinimumIdleSize() {
            return this.slaveConnectionMinimumIdleSize;
        }

        public void setSlaveConnectionMinimumIdleSize(Integer slaveConnectionMinimumIdleSize) {
            this.slaveConnectionMinimumIdleSize = slaveConnectionMinimumIdleSize;
        }
    }

    public static class SingleServerConfig
    extends BaseProperties {
        private String address;
        private Integer connectionMinimumIdleSize = 32;
        private Integer connectionPoolSize = 64;
        private Integer database = 0;
        private Boolean dnsMonitoring = false;
        private Long dnsMonitoringInterval = 5000L;

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public Integer getConnectionMinimumIdleSize() {
            return this.connectionMinimumIdleSize;
        }

        public void setConnectionMinimumIdleSize(Integer connectionMinimumIdleSize) {
            this.connectionMinimumIdleSize = connectionMinimumIdleSize;
        }

        public Integer getConnectionPoolSize() {
            return this.connectionPoolSize;
        }

        public void setConnectionPoolSize(Integer connectionPoolSize) {
            this.connectionPoolSize = connectionPoolSize;
        }

        public Integer getDatabase() {
            return this.database;
        }

        public void setDatabase(Integer database) {
            this.database = database;
        }

        public Boolean getDnsMonitoring() {
            return this.dnsMonitoring;
        }

        public void setDnsMonitoring(Boolean dnsMonitoring) {
            this.dnsMonitoring = dnsMonitoring;
        }

        public Long getDnsMonitoringInterval() {
            return this.dnsMonitoringInterval;
        }

        public void setDnsMonitoringInterval(Long dnsMonitoringInterval) {
            this.dnsMonitoringInterval = dnsMonitoringInterval;
        }
    }

    public static class ConfigFile {
        private String json;
        private String yaml;

        public String getJson() {
            return this.json;
        }

        public void setJson(String json) {
            this.json = json;
        }

        public String getYaml() {
            return this.yaml;
        }

        public void setYaml(String yaml) {
            this.yaml = yaml;
        }
    }
}

