/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.model.base;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface BaseEnum<T> {
    public String getName();

    public T getValue();

    public static <E extends Enum<E>, T> E byValue(T value, Class<E> clazz) {
        if (!Objects.isNull(value)) {
            EnumSet<E> all = EnumSet.allOf(clazz);
            return (E)((Enum)all.stream().filter(e -> Objects.equals(((BaseEnum)((Object)e)).getValue(), value)).findFirst().orElse(null));
        }
        return null;
    }

    public static <E extends Enum<E>, T> E byName(String name, Class<E> clazz) {
        if (!Objects.isNull(name)) {
            EnumSet<E> all = EnumSet.allOf(clazz);
            return (E)((Enum)all.stream().filter(e -> ((BaseEnum)((Object)e)).getName().equals(name)).findFirst().orElse(null));
        }
        return null;
    }

    public static <E extends Enum<E>, T> String toName(T value, Class<E> clazz) {
        E e = BaseEnum.byValue(value, clazz);
        if (!Objects.isNull(e)) {
            return ((BaseEnum)e).getName();
        }
        return null;
    }

    public static <E extends Enum<E>, T> T toValue(String name, Class<E> clazz) {
        E e = BaseEnum.byName(name, clazz);
        if (!Objects.isNull(e)) {
            return ((BaseEnum)e).getValue();
        }
        return null;
    }

    public static <E extends Enum<E>, T> List<Map<String, Object>> toList(Class<E> clazz, E ... excludes) {
        EnumSet<E> all = EnumSet.allOf(clazz);
        return all.stream().filter(v -> excludes == null || !Arrays.asList(excludes).contains(v)).map(x$0 -> BaseEnum.toMap((Enum)x$0)).collect(Collectors.toList());
    }

    public static <E extends Enum<E>, T> List<Map<String, Object>> toList(E ... enums) {
        return Stream.of(enums).map(x$0 -> BaseEnum.toMap((Enum)x$0)).collect(Collectors.toList());
    }

    public static <E extends Enum<E>, T> Map<String, Object> toMap(E enumValue) {
        LinkedHashMap map = Maps.newLinkedHashMapWithExpectedSize((int)3);
        map.put("name", ((BaseEnum)((Object)enumValue)).getName());
        map.put("label", ((BaseEnum)((Object)enumValue)).getName());
        map.put("value", ((BaseEnum)((Object)enumValue)).getValue());
        return map;
    }

    public static <E extends Enum<E>, T> Map<String, Object> toValueMap(Class<E> clazz) {
        EnumSet<Enum> all = EnumSet.allOf(clazz);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Enum e : all) {
            result.put(((BaseEnum)((Object)e)).getName(), ((BaseEnum)((Object)e)).getValue());
        }
        return result;
    }

    public static <E extends Enum<E>, T> Map<T, String> toNameMap(Class<E> clazz) {
        EnumSet<Enum> all = EnumSet.allOf(clazz);
        LinkedHashMap<T, String> result = new LinkedHashMap<T, String>();
        for (Enum e : all) {
            result.put(((BaseEnum)((Object)e)).getValue(), ((BaseEnum)((Object)e)).getName());
        }
        return result;
    }
}

