/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.core.model.department;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public enum DepartmentType {
    HEAD_OFFICE("\u603b\u516c\u53f8", 0),
    AREA_OFFICE("\u533a\u57df\u516c\u53f8", 1),
    BRANCH_OFFICE("\u5206\u516c\u53f8", 2),
    PROJECT_OFFICE("\u9879\u76ee\u516c\u53f8", 3),
    DEPARTMENT("\u90e8\u95e8", 4),
    MANAGEMENT_OFFICE("\u9879\u76ee\u7ba1\u7406\u5904", 5);

    private String name;
    private Integer value;

    private DepartmentType(String name, Integer value) {
        this.name = name;
        this.value = value;
    }

    public static String getName(Integer value) {
        if (value == null) {
            return null;
        }
        for (DepartmentType d : DepartmentType.values()) {
            if (!value.equals(d.value)) continue;
            return d.name;
        }
        return null;
    }

    public static Integer getValue(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        for (DepartmentType d : DepartmentType.values()) {
            if (!name.equals(d.name)) continue;
            return d.value;
        }
        return null;
    }

    public static List<Integer> companyValues() {
        return Arrays.asList(DepartmentType.HEAD_OFFICE.value, DepartmentType.AREA_OFFICE.value, DepartmentType.BRANCH_OFFICE.value, DepartmentType.PROJECT_OFFICE.value, DepartmentType.MANAGEMENT_OFFICE.value);
    }

    public static List<Integer> departmentValues() {
        return Arrays.asList(DepartmentType.HEAD_OFFICE.value, DepartmentType.AREA_OFFICE.value, DepartmentType.BRANCH_OFFICE.value, DepartmentType.PROJECT_OFFICE.value, DepartmentType.DEPARTMENT.value, DepartmentType.MANAGEMENT_OFFICE.value);
    }

    public static List<Integer> communityValues() {
        return Arrays.asList(DepartmentType.HEAD_OFFICE.value, DepartmentType.AREA_OFFICE.value, DepartmentType.BRANCH_OFFICE.value, DepartmentType.PROJECT_OFFICE.value, DepartmentType.MANAGEMENT_OFFICE.value);
    }

    public String getName() {
        return this.name;
    }

    public Integer getValue() {
        return this.value;
    }
}

