/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.ms.utils;

import com.cyberway.msf.ms.model.message.MessageTypeEnum;
import com.cyberway.msf.ms.model.message.dto.MessageDto;
import com.cyberway.msf.ms.model.mq.dto.MqDto;
import com.cyberway.msf.ms.support.MessageDtoBuilder;
import com.cyberway.msf.ms.utils.MqUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component
public class MessageUtil
extends MqUtil {
    private static MessageUtil messageUtil;

    @PostConstruct
    public void init() {
        messageUtil = this;
    }

    public static void removeMessage(String messageId) {
        MessageDto message = new MessageDto();
        message.setMessageId(messageId);
        messageUtil.remove(message);
    }

    public static void sendTemplateMessage(String templateCode, Map<String, Object> params, String toUser, String toUserName) {
        MessageDto message = new MessageDto();
        message.setTemplateCode(templateCode);
        message.setParamsMap(params);
        message.setReceiverId(toUser);
        message.setReceiver(toUserName);
        messageUtil.send(message);
    }

    public static void sendMessage(MessageDto messageDto) {
        messageUtil.send(messageDto);
    }

    public static void sendSms(List<String> receiverPhones, String templateCode, Map<String, Object> params) {
        MessageDto message = new MessageDtoBuilder().withPersistent(false).withReceiverPhones(receiverPhones).withTemplateCode(templateCode).withTemplateParams(params).withScopes(new Byte[]{MessageTypeEnum.SMS.getId()}).build();
        messageUtil.send(message);
    }

    public static void sendApn(List<String> userIds, String templateCode, Map<String, Object> params, String appType) {
        if (null == params) {
            params = new HashMap<String, Object>();
        }
        params.put("application", appType);
        MessageDto message = new MessageDtoBuilder().withPersistent(false).withToUserIds(userIds).withTemplateCode(templateCode).withTemplateParams(params).withScopes(new Byte[]{MessageTypeEnum.APNS.getId()}).build();
        messageUtil.send(message);
    }

    public static void sendMessage(String senderId, List<String> receiverIds, String templateCode, Map<String, Object> params) {
        MessageDto message = new MessageDtoBuilder().withPersistent(true).withToUserIds(receiverIds).withTemplateCode(templateCode).withTemplateParams(params).withSenderId(senderId).withScopes(new Byte[]{MessageTypeEnum.MESSAGE.getId()}).build();
        messageUtil.send(message);
    }

    private void send(MessageDto messageDto) {
        this.sendMessage(this.getMqDto(messageDto));
    }

    private void remove(MessageDto messageDto) {
        this.sendMessage(this.getMqDto(messageDto, "topic.common.messages.delete"));
    }

    protected MqDto getMqDto(MessageDto dto) {
        MqDto mq = new MqDto();
        mq.setExchange("exchange.common.messages");
        mq.setRoutingKey("topic.common.messages");
        mq.setBody(dto);
        return mq;
    }

    protected MqDto getMqDto(MessageDto dto, String routingKey) {
        MqDto mq = new MqDto();
        mq.setExchange("exchange.common.messages");
        mq.setRoutingKey(routingKey);
        mq.setBody(dto);
        return mq;
    }
}

