/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.user.client;

import com.cyberway.msf.commons.api.result.ApiResponseResult;
import com.cyberway.msf.commons.model.user.UserInfo;
import com.cyberway.msf.user.model.user.UserType;
import com.cyberway.msf.user.model.user.dto.UserDto;
import com.cyberway.msf.user.model.user.dto.UserLoginDto;
import com.cyberway.msf.user.model.user.vo.UserVo;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(contextId="UserClient", value="${feign.user:cyberway-msf-user}")
public interface UserClient {
    @PostMapping(value={"/api/admin/login"})
    public ApiResponseResult<UserInfo> login(@RequestBody UserLoginDto var1);

    @RequestMapping(value={"/api/user/insertUserType"}, method={RequestMethod.POST})
    public ApiResponseResult insertUserType(@RequestParam(value="typeId") String var1, @RequestParam(value="businessType") String var2, @RequestBody @Valid UserDto var3);

    @RequestMapping(value={"/api/user/relateWithUser"}, method={RequestMethod.GET})
    public ApiResponseResult relateWithUser(@RequestParam(value="userId") String var1, @RequestParam(value="businessType") String var2, @RequestParam(value="typeId") String var3);

    @RequestMapping(value={"/api/user/getUserTypeId"}, method={RequestMethod.GET})
    public ApiResponseResult<String> getUserTypeId(@RequestParam(value="userId") String var1, @RequestParam(value="businessType") String var2);

    @RequestMapping(value={"/api/user/{id}"}, method={RequestMethod.GET})
    public ApiResponseResult<UserVo> getUser(@PathVariable(value="id") String var1);

    @RequestMapping(value={"/api/user/getRelatedUserId"}, method={RequestMethod.GET})
    public ApiResponseResult<String> getRelatedUserId(@RequestParam(value="businessType") String var1, @RequestParam(value="typeId") String var2);

    @RequestMapping(value={"/api/user/getRelatedUserIds"}, method={RequestMethod.POST})
    public ApiResponseResult<List<String>> getRelatedUserIds(@RequestParam(value="businessType") String var1, @RequestBody List<String> var2);

    @RequestMapping(value={"/api/user/disassociateWithUser"}, method={RequestMethod.POST})
    public ApiResponseResult disassociateWithUser(@RequestParam(value="businessType") String var1, @RequestBody List<String> var2);

    @RequestMapping(value={"/api/user/getRelatedUser"}, method={RequestMethod.GET})
    public ApiResponseResult<UserVo> getRelatedUser(@RequestParam(value="businessType") String var1, @RequestParam(value="typeId") String var2);

    @RequestMapping(value={"/api/user"}, method={RequestMethod.POST})
    public ApiResponseResult insertUser(@RequestBody UserDto var1);

    @RequestMapping(value={"/api/user/initTenantUser"}, method={RequestMethod.GET})
    public ApiResponseResult initTenantUser(@RequestParam(value="tenantCode") String var1, @RequestParam(value="tenantId") String var2, @RequestParam(value="orgId") String var3, @RequestParam(value="companyId") String var4);

    @ApiOperation(value="\u4e34\u65f6\u79df\u6237\u7ba1\u7406\u5458\u89e3\u9664\u51bb\u7ed3")
    @PostMapping(value={"/api/user/unfreezeTenantTempUser"})
    public ApiResponseResult unfreezeTenantTempUser(@RequestParam(value="tenantCode") String var1, @RequestParam(value="tenantId") String var2, @RequestParam(value="tenantTempId") String var3, @RequestParam(value="orgId") String var4, @RequestParam(value="companyId") String var5, @RequestBody List<String> var6);

    @RequestMapping(value={"/api/user/initTenantTempUser"}, method={RequestMethod.POST})
    public ApiResponseResult initTenantTempUser(@RequestParam(value="tenantTempId") String var1, @RequestBody UserDto var2);

    @RequestMapping(value={"/api/user/initOrgUser"}, method={RequestMethod.GET})
    public ApiResponseResult initOrgUser(@RequestParam(value="codeName") String var1, @RequestParam(value="tenantId") String var2, @RequestParam(value="orgId") String var3, @RequestParam(value="companyId") String var4, @RequestParam(value="orgCode") String var5);

    @RequestMapping(value={"/api/user/replaceRelateUserType"}, method={RequestMethod.POST})
    public ApiResponseResult replaceRelateUserType(@RequestBody List<String> var1, @RequestParam(value="businessType") String var2, @RequestParam(value="typeId") String var3);

    @RequestMapping(value={"/api/user/listRelatedUser"}, method={RequestMethod.GET})
    public ApiResponseResult<List<UserVo>> listRelatedUser(@RequestParam(value="businessType") String var1, @RequestParam(value="typeId") String var2);

    @GetMapping(value={"/api/user/tenantAdmin/{tenantId}"})
    public ApiResponseResult<UserVo> getTenantAdminUser(@PathVariable(value="tenantId") String var1);

    @PostMapping(value={"/api/user/updateTenantCode"})
    public ApiResponseResult updateTenantCode(@RequestParam(value="tenantCode") String var1, @RequestParam(value="tenantId") String var2);

    @RequestMapping(value={"/api/user/insertOrEditUserType"}, method={RequestMethod.POST})
    public ApiResponseResult insertOrEditUserType(@RequestParam(value="typeId") String var1, @RequestParam(value="businessType") String var2, @RequestBody @Valid UserDto var3);

    @RequestMapping(value={"/api/user/checkBusinessType"}, method={RequestMethod.POST})
    public ApiResponseResult<UserType> checkBusinessType(@RequestParam(value="loginName") String var1, @RequestParam(value="businessType") String var2);
}

