/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.starter.user.endpoint;

import com.alibaba.fastjson.JSON;
import com.cyberway.msf.commons.api.result.ApiResponseResult;
import com.cyberway.msf.commons.api.result.ApiResultCode;
import com.cyberway.msf.commons.auth.support.CommonsAuthProperties;
import com.cyberway.msf.commons.auth.util.JwtUtils;
import com.cyberway.msf.commons.base.controller.BaseHandleExceptionController;
import com.cyberway.msf.commons.base.util.JsonUtils;
import com.cyberway.msf.commons.base.util.MessageUtils;
import com.cyberway.msf.commons.base.util.UserUtils;
import com.cyberway.msf.commons.cache.RedisUtils;
import com.cyberway.msf.commons.model.user.Resource;
import com.cyberway.msf.commons.model.user.UserInfo;
import com.cyberway.msf.starter.user.ldap.ILdapUser;
import com.cyberway.msf.starter.user.ldap.ILdapUserService;
import com.cyberway.msf.starter.user.model.role.RoleType;
import com.cyberway.msf.starter.user.model.role.RoleVo;
import com.cyberway.msf.starter.user.model.user.User;
import com.cyberway.msf.starter.user.model.user.dto.UserLoginDto;
import com.cyberway.msf.starter.user.service.permission.ResourceService;
import com.cyberway.msf.starter.user.service.role.RoleService;
import com.cyberway.msf.starter.user.service.user.LoginService;
import com.cyberway.msf.starter.user.service.user.UserService;
import com.cyberway.msf.starter.user.support.constant.UserApiResultCode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin"})
@Api(tags={"LoginController"}, description="\u7528\u6237\u8ba4\u8bc1")
public class LoginController
extends BaseHandleExceptionController {
    private static final Logger logger = LoggerFactory.getLogger(LoginController.class);
    @Autowired
    private LoginService loginServiceImpl;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private JwtUtils jwtUtils;
    @Autowired
    private CommonsAuthProperties commonsAuthProperties;
    @Autowired(required=false)
    @Qualifier(value="ldapUserService")
    ILdapUserService ldapUserService;
    @Autowired
    UserService userService;
    @Autowired
    private RoleService roleServiceImpl;
    @Value(value="${core.single.tenantId}")
    String tenantId;
    @Autowired
    ResourceService resourceServiceImpl;

    @ApiOperation(value="\u7528\u6237\u767b\u5f55")
    @RequestMapping(value={"/login"}, method={RequestMethod.POST})
    @ApiImplicitParams(value={@ApiImplicitParam(name="userLoginDto", value="\u7528\u6237\u767b\u5f55", paramType="body", required=true, dataType="UserLoginDto")})
    public ApiResponseResult login(@RequestBody @Valid UserLoginDto userLoginDto) {
        UserInfo user = null;
        if (this.ldapUserService != null && this.ldapUserService.enable().booleanValue() && StringUtils.isNotBlank((CharSequence)userLoginDto.getAuthSource())) {
            Boolean checkUser = this.ldapUserService.checkUser(userLoginDto.getUsername(), userLoginDto.getPassword(), userLoginDto.getAuthSource());
            if (checkUser.booleanValue()) {
                ILdapUser ldapUser = this.ldapUserService.getUser(userLoginDto.getUsername(), userLoginDto.getAuthSource());
                user = new UserInfo();
                user.setFullName(ldapUser.getDisplayName());
                user.setUsername(ldapUser.getUsername());
                HashMap<String, String> extraAttr = new HashMap<String, String>();
                extraAttr.put("ldapToken", new String(Base64.encodeBase64((byte[])(user.getUsername() + ':' + userLoginDto.getPassword()).getBytes())));
                user.setJson(JsonUtils.toJson(extraAttr));
                User localUser = this.userService.updateLdapUser(ldapUser);
                user.setId(localUser.getId());
                user.setTenantId(this.tenantId);
                List roleTypes = this.roleServiceImpl.getRoleMembers((String)((Object)user.getId())).stream().map(RoleVo::getType).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(roleTypes) && (roleTypes.contains(RoleType.ADMINISTRATOR.getValue()) || roleTypes.contains(RoleType.SUPERADMINISTRATOR.getValue()) || roleTypes.contains(RoleType.SYSTEMADMINISTRATOR.getValue()))) {
                    this.redisUtils.setOrigin(String.format("roleType:%s", user.getId()), roleTypes);
                }
                List<Resource> orgResources = this.resourceServiceImpl.getResourcesBySourceId(user.getTenantId());
                this.redisUtils.setOrigin(String.format("resources:%s", user.getTenantId()), (Object)JSON.toJSONString(orgResources));
                List<Resource> resources = this.resourceServiceImpl.getResourcesByUserId((String)((Object)user.getId()));
                this.redisUtils.setOrigin(String.format("resources:%s", user.getId()), (Object)JSON.toJSONString(resources));
            }
        } else {
            user = this.loginServiceImpl.login(userLoginDto);
            if (null == user) {
                throw MessageUtils.buildException((ApiResultCode)UserApiResultCode.USER_VERIFY_FAIL, (Object[])new Object[0]);
            }
            user.setTenantId(this.tenantId);
            List roleTypes = this.roleServiceImpl.getRoleMembers((String)((Object)user.getId())).stream().map(RoleVo::getType).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(roleTypes) && (roleTypes.contains(RoleType.ADMINISTRATOR.getValue()) || roleTypes.contains(RoleType.SUPERADMINISTRATOR.getValue()) || roleTypes.contains(RoleType.SYSTEMADMINISTRATOR.getValue()))) {
                this.redisUtils.setOrigin(String.format("roleType:%s", user.getId()), roleTypes);
            }
            List<Resource> orgResources = this.resourceServiceImpl.getResourcesBySourceId(user.getTenantId());
            this.redisUtils.setOrigin(String.format("resources:%s", user.getTenantId()), (Object)JSON.toJSONString(orgResources));
            List<Resource> resources = this.resourceServiceImpl.getResourcesByUserId((String)((Object)user.getId()));
            this.redisUtils.setOrigin(String.format("resources:%s", user.getId()), (Object)JSON.toJSONString(resources));
        }
        if (null == user) {
            throw MessageUtils.buildException((ApiResultCode)UserApiResultCode.USER_VERIFY_FAIL, (Object[])new Object[0]);
        }
        String token = this.jwtUtils.getToken((String)((Object)user.getId()));
        this.redisUtils.setOrigin("auth_user_token_" + token, (Object)JSON.toJSONString((Object)user), this.commonsAuthProperties.getTokenTime().longValue());
        this.redisUtils.setOrigin(String.format("auth_user_token_%s", user.getId()), (Object)token);
        user.setToken(token);
        return new ApiResponseResult((Object)user);
    }

    @ApiOperation(value="\u7528\u6237\u767b\u51fa")
    @RequestMapping(value={"/logout"}, method={RequestMethod.GET})
    public ApiResponseResult logout() {
        logger.debug("LoginController -> logout() starts..");
        HttpServletRequest httpRequest = this.request;
        String token = httpRequest.getHeader("Authorization");
        UserInfo user = UserUtils.getLoggedInUser();
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            this.redisUtils.delOrigin(new String[]{"auth_user_token_" + token});
            this.redisUtils.delOrigin(new String[]{String.format("auth_user_token_%s", user.getId())});
            this.redisUtils.delOrigin(new String[]{String.format("roleType:%s", user.getId())});
            this.redisUtils.delOrigin(new String[]{String.format("resources:%s", user.getId())});
            this.redisUtils.delOrigin(new String[]{String.format("resources:%s", user.getTenantId())});
            this.redisUtils.delOrigin(new String[]{String.format("resourcesURL:%s", user.getId())});
        }
        return new ApiResponseResult(ApiResultCode.SUCCESS);
    }
}

