/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.starter.user.endpoint;

import com.cyberway.msf.commons.api.result.ApiResponseResult;
import com.cyberway.msf.commons.api.result.ApiResultCode;
import com.cyberway.msf.commons.base.controller.BaseController;
import com.cyberway.msf.commons.base.support.annotation.api.ApiOverride;
import com.cyberway.msf.commons.model.page.PageDataModel;
import com.cyberway.msf.commons.model.page.PageModel;
import com.cyberway.msf.starter.user.model.role.RoleCategory;
import com.cyberway.msf.starter.user.model.user.vo.UserVo;
import com.cyberway.msf.starter.user.service.role.RoleCategoryService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/roleCategory"})
@Api(tags={"RoleCategoryController"}, description="\u89d2\u8272\u7c7b\u578b\u7ba1\u7406")
public class RoleCategoryController
extends BaseController<RoleCategory> {
    private final Logger logger = LoggerFactory.getLogger(RoleCategoryController.class);
    @Autowired
    private RoleCategoryService roleCategoryServiceImpl;

    @ApiOperation(value="\u6839\u636e\u67e5\u8be2\u6761\u4ef6\u67e5\u8be2\u89d2\u8272\u7c7b\u578b")
    @RequestMapping(value={"/list"}, method={RequestMethod.POST})
    @ApiImplicitParams(value={@ApiImplicitParam(name="code", value="\u89d2\u8272\u7c7b\u578b\u7f16\u7801", paramType="query", required=false, dataType="string"), @ApiImplicitParam(name="name", value="\u89d2\u8272\u7c7b\u578b\u540d\u79f0", paramType="query", required=false, dataType="string"), @ApiImplicitParam(name="pageModel", value="\u5206\u9875", paramType="body", required=false, dataType="PageModel")})
    @ApiOverride
    public ApiResponseResult<PageDataModel<RoleCategory>> listRoleCategories(@RequestParam(required=false) String code, @RequestParam(required=false) String name, @RequestBody(required=false) PageModel pageModel) {
        this.logger.info("listRoleCategories starts:");
        ApiResponseResult res = null;
        PageDataModel<RoleCategory> pageDataModel = this.roleCategoryServiceImpl.selectByExample(code, name, pageModel);
        res = new ApiResponseResult(ApiResultCode.SUCCESS, pageDataModel);
        this.logger.info("listRoleCategories ends:{}", (Object)res);
        return res;
    }

    @ApiOperation(value="\u6839\u636e\u89d2\u8272\u7c7b\u578b\u7f16\u7801\u67e5\u8be2\u7528\u6237id\u5217\u8868")
    @RequestMapping(value={"/selectUserIdsByCode"}, method={RequestMethod.GET})
    @ApiImplicitParams(value={@ApiImplicitParam(name="code", value="\u89d2\u8272\u7c7b\u578b\u7f16\u7801", paramType="query", required=true, dataType="string")})
    public ApiResponseResult<List<String>> selectUserIdsByCode(@RequestParam String code) {
        ApiResponseResult res = null;
        List<String> userIds = this.roleCategoryServiceImpl.selectUserIdsByCode(code);
        res = new ApiResponseResult(ApiResultCode.SUCCESS, userIds);
        return res;
    }

    @ApiOperation(value="\u6839\u636e\u89d2\u8272\u7c7b\u578b\u7f16\u7801\u67e5\u8be2\u7528\u6237\u5217\u8868")
    @RequestMapping(value={"/selectUsersByCode"}, method={RequestMethod.GET})
    @ApiImplicitParams(value={@ApiImplicitParam(name="code", value="\u89d2\u8272\u7c7b\u578b\u7f16\u7801", paramType="query", required=true, dataType="string")})
    public ApiResponseResult<List<UserVo>> selectUsersByCode(@RequestParam String code) {
        ApiResponseResult res = null;
        List<UserVo> users = this.roleCategoryServiceImpl.selectUsersByCode(code);
        res = new ApiResponseResult(ApiResultCode.SUCCESS, users);
        return res;
    }
}

