/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.starter.user.endpoint;

import com.cyberway.msf.commons.api.result.ApiResponseResult;
import com.cyberway.msf.commons.api.result.ApiResultCode;
import com.cyberway.msf.commons.base.controller.BaseController;
import com.cyberway.msf.commons.base.support.annotation.api.ApiOverride;
import com.cyberway.msf.commons.base.util.BusinessPreconditions;
import com.cyberway.msf.commons.base.util.MessageUtils;
import com.cyberway.msf.commons.base.util.UserUtils;
import com.cyberway.msf.commons.core.exception.BaseException;
import com.cyberway.msf.commons.model.page.PageDataModel;
import com.cyberway.msf.commons.model.page.PageModel;
import com.cyberway.msf.commons.poi.importer.ImportExcelHandler;
import com.cyberway.msf.commons.poi.importer.ImportResult;
import com.cyberway.msf.commons.poi.util.ExcelUtils;
import com.cyberway.msf.commons.poi.util.ResultUtils;
import com.cyberway.msf.core.model.menu.MenuItem;
import com.cyberway.msf.core.model.tree.ZtreeNode;
import com.cyberway.msf.starter.user.model.role.Role;
import com.cyberway.msf.starter.user.model.role.RoleType;
import com.cyberway.msf.starter.user.model.role.RoleVo;
import com.cyberway.msf.starter.user.model.user.vo.UserVo;
import com.cyberway.msf.starter.user.service.role.RoleCategoryService;
import com.cyberway.msf.starter.user.service.role.RoleService;
import com.cyberway.msf.starter.user.service.user.UserService;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/role"})
@Api(tags={"RoleController"}, description="\u89d2\u8272\u7ba1\u7406")
public class RoleController
extends BaseController<Role> {
    private final Logger logger = LoggerFactory.getLogger(RoleController.class);
    @Autowired
    private RoleService roleServiceImpl;
    @Autowired
    private UserService userServiceImpl;
    @Value(value="${export.name.role}")
    private String exportRoleName;
    @Value(value="${export.name.rolePrivilege}")
    private String exportRolePrivilegeName;
    @Autowired
    private RoleCategoryService roleCategoryServiceImpl;
    @Autowired
    private ImportExcelHandler roleImportExcelHandler;
    @Autowired
    private ImportExcelHandler rolePrivilegesImportExcelHandler;

    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u89d2\u8272")
    @GetMapping(value={"/{id}"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u89d2\u8272id", paramType="path", required=true, dataType="string")})
    @ApiOverride
    public ApiResponseResult<RoleVo> getRole(@PathVariable String id) {
        BusinessPreconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)id), (BaseException)MessageUtils.buildException((ApiResultCode)ApiResultCode.PARAM_IS_NULL, (Object[])new Object[]{"id"}));
        ApiResponseResult res = null;
        RoleVo roleVo = this.roleServiceImpl.selectVoById(id);
        if (roleVo == null) {
            throw MessageUtils.buildException((ApiResultCode)ApiResultCode.GET_DATA_NOT_EXIST, (Object[])new Object[]{id});
        }
        res = new ApiResponseResult(ApiResultCode.SUCCESS, (Object)roleVo);
        this.logger.info("getRole ends:{}", (Object)res);
        return res;
    }

    @ApiOperation(value="\u6839\u636e\u67e5\u8be2\u6761\u4ef6\u67e5\u8be2\u89d2\u8272")
    @RequestMapping(value={"/list"}, method={RequestMethod.POST})
    @ApiImplicitParams(value={@ApiImplicitParam(name="companyId", value="\u7ec4\u7ec7id", paramType="query", required=false, dataType="string"), @ApiImplicitParam(name="name", value="\u540d\u79f0", paramType="query", required=false, dataType="string"), @ApiImplicitParam(name="roleCategoryId", value="\u89d2\u8272\u7c7b\u578b", paramType="query", required=false, dataType="string"), @ApiImplicitParam(name="systemDefault", value="\u662f\u5426\u6807\u51c6\u89d2\u8272", paramType="query", required=false, dataType="boolean"), @ApiImplicitParam(name="pageModel", value="\u5206\u9875", paramType="body", required=false, dataType="PageModel")})
    @ApiOverride
    public ApiResponseResult<PageDataModel<RoleVo>> listRoles(@RequestParam(required=false) String companyId, @RequestParam(required=false) String name, @RequestParam(required=false) String roleCategoryId, @RequestParam(required=false) Boolean systemDefault, @RequestBody(required=false) PageModel pageModel) {
        this.logger.info("listRoles starts:");
        ApiResponseResult res = null;
        PageDataModel<RoleVo> pageDataModel = this.roleServiceImpl.selectVoByExample(companyId, name, roleCategoryId, systemDefault, pageModel);
        res = new ApiResponseResult(ApiResultCode.SUCCESS, pageDataModel);
        this.logger.info("listRoles ends:{}", (Object)res);
        return res;
    }

    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u5206\u7c7b\u83dc\u5355")
    @RequestMapping(value={"/roleCategory/selection"}, method={RequestMethod.GET})
    public ApiResponseResult getRoleCategorySelection() {
        List<Map<String, Object>> selection = this.roleCategoryServiceImpl.selectAllRoleCategories();
        return new ApiResponseResult(ApiResultCode.SUCCESS, selection);
    }

    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u7ec4\u83dc\u5355")
    @RequestMapping(value={"/type/selection"}, method={RequestMethod.GET})
    public ApiResponseResult getTypeSelection() {
        ArrayList selection = new ArrayList();
        List<Object> roleTypes = Lists.newArrayList();
        roleTypes = UserUtils.isAdministrator() != false ? RoleType.administrators() : (UserUtils.isSuperAdministrator() != false ? RoleType.superAdministrators() : RoleType.systemAdministrators());
        for (RoleType type : roleTypes) {
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.put("value", type.getValue());
            map.put("label", type.getName());
            selection.add(map);
        }
        return new ApiResponseResult(ApiResultCode.SUCCESS, selection);
    }

    @ApiOperation(value="\u8bbe\u7f6e\u89d2\u8272\u6743\u9650")
    @RequestMapping(value={"/setRolePrivileges"}, method={RequestMethod.POST})
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleId", value="\u89d2\u8272id", paramType="query", required=true, dataType="string"), @ApiImplicitParam(name="entityIds", value="\u8d44\u6e90id", paramType="body", required=true, allowMultiple=true, dataType="string")})
    public ApiResponseResult setRolePrivileges(@RequestParam String roleId, @RequestBody List<String> entityIds) {
        int sum = this.roleServiceImpl.setRolePrivileges(roleId, entityIds);
        if (sum > 0) {
            return new ApiResponseResult(ApiResultCode.SUCCESS);
        }
        throw MessageUtils.buildException((ApiResultCode)ApiResultCode.INSERT_DATA_FAIL, (Object[])new Object[0]);
    }

    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u6743\u9650")
    @RequestMapping(value={"/getRolePrivileges"}, method={RequestMethod.GET})
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleId", value="\u89d2\u8272id", paramType="query", required=true, dataType="string")})
    public ApiResponseResult<List<ZtreeNode>> getRolePrivileges(@RequestParam String roleId) {
        return new ApiResponseResult(ApiResultCode.SUCCESS, this.roleServiceImpl.getRolePrivileges(roleId));
    }

    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u7528\u6237")
    @RequestMapping(value={"/roleMembers/{roleId}"}, method={RequestMethod.GET})
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleId", value="\u89d2\u8272ID", paramType="path", required=true, dataType="string")})
    public ApiResponseResult<List<UserVo>> getRoleMembers(@PathVariable String roleId) {
        this.logger.info("getRoleMembers starts:{}");
        ApiResponseResult res = null;
        List<UserVo> userVos = this.userServiceImpl.getRoleMembers(roleId);
        res = new ApiResponseResult(ApiResultCode.SUCCESS, userVos);
        return res;
    }

    @ApiOperation(value="\u6839\u636e\u89d2\u8272id\u83b7\u53d6\u7528\u6237id\u5217\u8868")
    @RequestMapping(value={"/{roleId}/getUserIds"}, method={RequestMethod.GET})
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleId", value="\u89d2\u8272ID", paramType="path", required=true, dataType="string")})
    public ApiResponseResult<List<String>> getUserIds(@PathVariable String roleId) {
        this.logger.info("getUserIds starts:{}");
        ApiResponseResult res = null;
        List<String> userIds = this.roleServiceImpl.getUserIds(roleId);
        res = new ApiResponseResult(ApiResultCode.SUCCESS, userIds);
        return res;
    }

    @ApiOperation(value="\u6309\u89d2\u8272\u7f16\u53f7\u548c\u79df\u6237ID\u83b7\u53d6\u7528\u6237ID\u5217\u8868")
    @RequestMapping(value={"/getUserIds"}, method={RequestMethod.GET})
    @ApiImplicitParams(value={@ApiImplicitParam(name="codeName", value="\u89d2\u8272\u7f16\u53f7", paramType="query", required=true, dataType="string"), @ApiImplicitParam(name="org", value="\u79df\u6237ID", paramType="query", required=true, dataType="string")})
    public ApiResponseResult<List<String>> getUserIdsByRoleCode(@RequestParam String codeName, @RequestParam String org) {
        this.logger.info("getUserIdsByRoleCode starts:{}");
        ApiResponseResult res = null;
        List<String> userIds = this.roleServiceImpl.getUserIdsByRoleCode(codeName, org);
        res = new ApiResponseResult(ApiResultCode.SUCCESS, userIds);
        return res;
    }

    @ApiOperation(value="\u6dfb\u52a0\u89d2\u8272\u7528\u6237")
    @RequestMapping(value={"/roleMembers"}, method={RequestMethod.POST})
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleId", value="\u89d2\u8272ID", paramType="query", required=true, dataType="string"), @ApiImplicitParam(name="userIds", value="\u7528\u6237id", paramType="body", required=true, allowMultiple=true, dataType="string")})
    public ApiResponseResult addRoleMembers(@RequestParam String roleId, @RequestBody List<String> userIds) {
        this.logger.info("addRoleMembers starts:{}");
        int sum = this.userServiceImpl.addRoleMembers(roleId, userIds);
        if (sum > 0) {
            return new ApiResponseResult(ApiResultCode.SUCCESS);
        }
        throw MessageUtils.buildException((ApiResultCode)ApiResultCode.INSERT_DATA_FAIL, (Object[])new Object[0]);
    }

    @ApiOperation(value="\u5220\u9664\u89d2\u8272\u7528\u6237")
    @RequestMapping(value={"/roleMembers"}, method={RequestMethod.DELETE})
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleId", value="\u89d2\u8272ID", paramType="query", required=true, dataType="string"), @ApiImplicitParam(name="userIds", value="\u7528\u6237id", paramType="body", required=true, allowMultiple=true, dataType="string")})
    public ApiResponseResult deleteRoleMembers(@RequestParam String roleId, @RequestBody List<String> userIds) {
        this.logger.info("deleteRoleMembers starts:{}");
        int sum = this.userServiceImpl.deleteRoleMembers(roleId, userIds);
        if (sum > 0) {
            return new ApiResponseResult(ApiResultCode.SUCCESS);
        }
        throw MessageUtils.buildException((ApiResultCode)ApiResultCode.DELETE_DATA_FAIL, (Object[])new Object[0]);
    }

    @ApiOperation(value="\u83b7\u53d6\u83dc\u5355\u89d2\u8272")
    @RequestMapping(value={"/roleResources/{entityId}"}, method={RequestMethod.GET})
    @ApiImplicitParams(value={@ApiImplicitParam(name="entityId", value="\u8d44\u6e90id", paramType="path", required=true, dataType="string")})
    public ApiResponseResult<List<RoleVo>> getRoleResource(@PathVariable String entityId) {
        this.logger.info("getRoleResource starts:{}");
        ApiResponseResult res = null;
        List<RoleVo> roleVos = this.roleServiceImpl.getRoleResource(entityId, MenuItem.class.getName());
        res = new ApiResponseResult(ApiResultCode.SUCCESS, roleVos);
        return res;
    }

    @ApiOperation(value="\u6dfb\u52a0\u83dc\u5355\u89d2\u8272")
    @RequestMapping(value={"/roleResources"}, method={RequestMethod.POST})
    @ApiImplicitParams(value={@ApiImplicitParam(name="entityId", value="\u8d44\u6e90id", paramType="query", required=true, dataType="string"), @ApiImplicitParam(name="roleIds", value="\u89d2\u8272", paramType="body", required=true, allowMultiple=true, dataType="string")})
    public ApiResponseResult addRoleResource(@RequestParam String entityId, @RequestBody List<String> roleIds) {
        this.logger.info("addRoleResource starts:{}");
        int sum = this.roleServiceImpl.addRoleResource(entityId, roleIds);
        if (sum > 0) {
            return new ApiResponseResult(ApiResultCode.SUCCESS);
        }
        throw MessageUtils.buildException((ApiResultCode)ApiResultCode.INSERT_DATA_FAIL, (Object[])new Object[0]);
    }

    @ApiOperation(value="\u5220\u9664\u83dc\u5355\u89d2\u8272")
    @RequestMapping(value={"/roleResources"}, method={RequestMethod.DELETE})
    @ApiImplicitParams(value={@ApiImplicitParam(name="entityId", value="\u8d44\u6e90id", paramType="query", required=true, dataType="string"), @ApiImplicitParam(name="roleIds", value="\u89d2\u8272", paramType="body", required=true, allowMultiple=true, dataType="string")})
    public ApiResponseResult deleteRoleResource(@RequestParam String entityId, @RequestBody List<String> roleIds) {
        this.logger.info("deleteRoleResource starts:{}");
        int sum = this.roleServiceImpl.deleteRoleResource(entityId, roleIds);
        if (sum > 0) {
            return new ApiResponseResult(ApiResultCode.SUCCESS);
        }
        throw MessageUtils.buildException((ApiResultCode)ApiResultCode.DELETE_DATA_FAIL, (Object[])new Object[0]);
    }

    @ApiOperation(value="\u5bfc\u51fa\u89d2\u8272\u4fe1\u606f")
    @RequestMapping(value={"/exportRoles"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="companyId", value="\u7ec4\u7ec7id", paramType="query", required=false, dataType="string"), @ApiImplicitParam(name="name", value="\u540d\u79f0", paramType="query", required=false, dataType="string"), @ApiImplicitParam(name="roleCategoryId", value="\u89d2\u8272\u7c7b\u578b", paramType="query", required=false, dataType="string"), @ApiImplicitParam(name="systemDefault", value="\u662f\u5426\u6807\u51c6\u89d2\u8272", paramType="query", required=false, dataType="boolean")})
    public void exportRoles(@RequestParam String companyId, @RequestParam(required=false) String name, @RequestParam(required=false) String roleCategoryId, @RequestParam(required=false) Boolean systemDefault, HttpServletResponse response) {
        this.logger.info("exportRoles starts");
        String fileName = this.exportRoleName;
        Workbook workbook = this.roleServiceImpl.exportRoles(companyId, name, roleCategoryId, systemDefault);
        ResultUtils.generateExcel((HttpServletResponse)response, (String)fileName, (Workbook)workbook);
    }

    @ApiOperation(value="\u5bfc\u51fa\u89d2\u8272\u6743\u9650\u4fe1\u606f")
    @RequestMapping(value={"/exportRolePrivileges"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="companyId", value="\u7ec4\u7ec7id", paramType="query", required=false, dataType="string"), @ApiImplicitParam(name="name", value="\u540d\u79f0", paramType="query", required=false, dataType="string"), @ApiImplicitParam(name="roleCategoryId", value="\u89d2\u8272\u7c7b\u578b", paramType="query", required=false, dataType="string"), @ApiImplicitParam(name="systemDefault", value="\u662f\u5426\u6807\u51c6\u89d2\u8272", paramType="query", required=false, dataType="boolean")})
    public void exportRolePrivileges(@RequestParam String companyId, @RequestParam(required=false) String name, @RequestParam(required=false) String roleCategoryId, @RequestParam(required=false) Boolean systemDefault, HttpServletResponse response) {
        this.logger.info("exportRolePrivileges starts");
        String fileName = this.exportRolePrivilegeName;
        Workbook workbook = this.roleServiceImpl.exportRolePrivileges(companyId, name, roleCategoryId, systemDefault);
        ResultUtils.generateExcel((HttpServletResponse)response, (String)fileName, (Workbook)workbook);
    }

    @ApiOperation(value="\u6279\u91cf\u5bfc\u5165\u89d2\u8272")
    @RequestMapping(value={"/import"}, method={RequestMethod.POST})
    public ApiResponseResult importRoles(@RequestParam @ApiParam(name="file", value="\u5bfc\u5165\u7684\u6587\u4ef6") MultipartFile file) {
        this.logger.info("importRoles starts:");
        BusinessPreconditions.checkArgument((file != null ? 1 : 0) != 0, (BaseException)MessageUtils.buildException((ApiResultCode)ApiResultCode.FILE_NOT_EXIST, (Object[])new Object[0]));
        ImportResult importResult = this.roleImportExcelHandler.handleSheet(ExcelUtils.handleExcle((MultipartFile)file));
        ApiResponseResult res = null;
        String result = ResultUtils.getImportResult((ImportResult)importResult);
        if (!importResult.isSuccess()) {
            throw MessageUtils.buildException((ApiResultCode)ApiResultCode.IMPORT_EXCEL_FAIL, (Object[])new Object[]{result});
        }
        res = new ApiResponseResult(ApiResultCode.SUCCESS, (Object)result);
        this.logger.info("importRoles ends:{}", (Object)res);
        return res;
    }

    @ApiOperation(value="\u6279\u91cf\u5bfc\u5165\u89d2\u8272\u6743\u9650")
    @RequestMapping(value={"/importPrivileges"}, method={RequestMethod.POST})
    public ApiResponseResult importRolePrivileges(@RequestParam @ApiParam(name="file", value="\u5bfc\u5165\u7684\u6587\u4ef6") MultipartFile file) {
        this.logger.info("importRolePrivileges starts:");
        BusinessPreconditions.checkArgument((file != null ? 1 : 0) != 0, (BaseException)MessageUtils.buildException((ApiResultCode)ApiResultCode.FILE_NOT_EXIST, (Object[])new Object[0]));
        ImportResult importResult = this.rolePrivilegesImportExcelHandler.handleSheet(ExcelUtils.handleExcle((MultipartFile)file));
        ApiResponseResult res = null;
        String result = ResultUtils.getImportResult((ImportResult)importResult);
        if (!importResult.isSuccess()) {
            throw MessageUtils.buildException((ApiResultCode)ApiResultCode.IMPORT_EXCEL_FAIL, (Object[])new Object[]{result});
        }
        res = new ApiResponseResult(ApiResultCode.SUCCESS, (Object)result);
        this.logger.info("importRolePrivileges ends:{}", (Object)res);
        return res;
    }
}

