/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.starter.user.endpoint;

import com.cyberway.msf.commons.api.result.ApiResponseResult;
import com.cyberway.msf.commons.api.result.ApiResultCode;
import com.cyberway.msf.commons.base.controller.BaseController;
import com.cyberway.msf.commons.base.support.annotation.api.ApiOverride;
import com.cyberway.msf.commons.base.util.BusinessPreconditions;
import com.cyberway.msf.commons.base.util.MessageUtils;
import com.cyberway.msf.commons.core.exception.BaseException;
import com.cyberway.msf.commons.model.page.PageDataModel;
import com.cyberway.msf.commons.model.page.PageModel;
import com.cyberway.msf.commons.poi.util.ResultUtils;
import com.cyberway.msf.starter.user.model.role.RoleVo;
import com.cyberway.msf.starter.user.model.user.ExportType;
import com.cyberway.msf.starter.user.model.user.User;
import com.cyberway.msf.starter.user.model.user.UserBusinessType;
import com.cyberway.msf.starter.user.model.user.dto.UserDto;
import com.cyberway.msf.starter.user.model.user.dto.UserPasswordUpdateDto;
import com.cyberway.msf.starter.user.model.user.vo.UserVo;
import com.cyberway.msf.starter.user.service.role.RoleService;
import com.cyberway.msf.starter.user.service.user.UserService;
import com.cyberway.msf.starter.user.service.user.UserTypeService;
import com.cyberway.msf.starter.user.support.constant.UserApiResultCode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@RestController
@RequestMapping(value={"/api/user"})
@Api(tags={"UserController"}, description="\u7528\u6237\u7ba1\u7406")
public class UserController
extends BaseController<User> {
    private final Logger logger = LoggerFactory.getLogger(UserController.class);
    @Autowired
    private UserService userServiceImpl;
    @Autowired
    private UserTypeService userTypeServiceImpl;
    @Autowired
    private RoleService roleServiceImpl;

    @ApiOperation(value="\u4fee\u6539\u5bc6\u7801")
    @RequestMapping(value={"/password/update"}, method={RequestMethod.POST})
    public ApiResponseResult updatePassword(@RequestBody @Valid UserPasswordUpdateDto dto) {
        this.userServiceImpl.updatePassword(dto);
        return new ApiResponseResult(ApiResultCode.SUCCESS);
    }

    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u7528\u6237")
    @GetMapping(value={"/{id}"})
    @ApiOverride
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u7528\u6237id", paramType="path", required=true, dataType="string")})
    public ApiResponseResult<UserVo> getrUser(@PathVariable String id) {
        BusinessPreconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)id), (BaseException)MessageUtils.buildException((ApiResultCode)ApiResultCode.PARAM_IS_NULL, (Object[])new Object[]{"id"}));
        ApiResponseResult res = null;
        UserVo userVo = this.userServiceImpl.selectVoById(id);
        if (userVo == null) {
            throw MessageUtils.buildException((ApiResultCode)ApiResultCode.GET_DATA_NOT_EXIST, (Object[])new Object[]{id});
        }
        res = new ApiResponseResult(ApiResultCode.SUCCESS, (Object)userVo);
        this.logger.info("getrUser ends:{}", (Object)res);
        return res;
    }

    @ApiOperation(value="\u6839\u636e\u67e5\u8be2\u6761\u4ef6\u67e5\u8be2\u7528\u6237")
    @RequestMapping(value={"/list"}, method={RequestMethod.POST})
    @ApiOverride
    @ApiImplicitParams(value={@ApiImplicitParam(name="fullName", value="\u59d3\u540d", paramType="query", required=false, dataType="string"), @ApiImplicitParam(name="loginName", value="\u767b\u5f55\u540d", paramType="query", required=false, dataType="string"), @ApiImplicitParam(name="businessType", value="\u7c7b\u578b", paramType="query", required=false, dataType="string"), @ApiImplicitParam(name="pageModel", value="\u5206\u9875", paramType="body", required=false, dataType="PageModel")})
    public ApiResponseResult<PageDataModel> listUsers(@RequestParam(required=false) String fullName, @RequestParam(required=false) String loginName, @RequestParam(required=false) String businessType, @RequestBody(required=false) PageModel pageModel) {
        this.logger.info("listUsers starts:");
        ApiResponseResult res = null;
        PageDataModel pageDataModel = this.userServiceImpl.selectVoByExample(fullName, loginName, businessType, pageModel);
        res = new ApiResponseResult(ApiResultCode.SUCCESS, (Object)pageDataModel);
        this.logger.info("listUsers ends:{}", (Object)res);
        return res;
    }

    @ApiOperation(value="\u65b0\u5efa\u7528\u6237")
    @PostMapping
    @ApiOverride
    @ApiImplicitParams(value={@ApiImplicitParam(name="userDto", value="\u65b0\u5efa\u7684\u7528\u6237", paramType="body", required=true, dataType="UserDto")})
    public ApiResponseResult insertUser(@RequestBody @Valid UserDto userDto) {
        if (userDto.getId() != null) {
            throw MessageUtils.buildException((ApiResultCode)ApiResultCode.PARAM_NOT_ALLOW, (Object[])new Object[]{"id"});
        }
        ApiResponseResult res = null;
        User user = new User();
        int sum = this.userServiceImpl.insertUser(userDto, user);
        if (sum <= 0) {
            throw MessageUtils.buildException((ApiResultCode)ApiResultCode.INSERT_DATA_FAIL, (Object[])new Object[0]);
        }
        res = new ApiResponseResult(ApiResultCode.SUCCESS, (Object)user.getId());
        this.logger.info("insertUser ends:{}", (Object)res);
        return res;
    }

    @ApiIgnore
    @ApiOperation(value="\u65b0\u5efa\u7528\u6237\u53ca\u5173\u8054\u7c7b\u578b")
    @RequestMapping(value={"/insertUserType"}, method={RequestMethod.POST})
    @ApiImplicitParams(value={@ApiImplicitParam(name="typeId", value="\u7c7b\u578bid", paramType="query", required=true, dataType="string"), @ApiImplicitParam(name="businessType", value="\u7528\u6237\u7c7b\u578b", paramType="query", required=true, dataType="string"), @ApiImplicitParam(name="userDto", value="\u65b0\u5efa\u7684\u7528\u6237", paramType="body", required=true, dataType="UserDto")})
    public ApiResponseResult insertUserType(@RequestParam String typeId, @RequestParam String businessType, @RequestBody @Valid UserDto userDto) {
        if (userDto.getId() != null) {
            throw MessageUtils.buildException((ApiResultCode)ApiResultCode.PARAM_NOT_ALLOW, (Object[])new Object[]{"id"});
        }
        ApiResponseResult res = null;
        User user = new User();
        int sum = this.userServiceImpl.insertUser(userDto, user, typeId, businessType);
        if (sum <= 0) {
            throw MessageUtils.buildException((ApiResultCode)ApiResultCode.INSERT_DATA_FAIL, (Object[])new Object[0]);
        }
        res = new ApiResponseResult(ApiResultCode.SUCCESS, (Object)user.getId());
        this.logger.info("insertUserType ends:{}", (Object)res);
        return res;
    }

    @ApiOperation(value="\u5173\u8054\u7528\u6237")
    @RequestMapping(value={"/relateWithUser"}, method={RequestMethod.GET})
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id", paramType="query", required=true, dataType="string"), @ApiImplicitParam(name="businessType", value="\u7528\u6237\u7c7b\u578b", paramType="query", required=true, dataType="string"), @ApiImplicitParam(name="typeId", value="\u7c7b\u578bid", paramType="query", required=true, dataType="string")})
    public ApiResponseResult relateWithUser(@RequestParam String userId, @RequestParam String businessType, @RequestParam String typeId) {
        this.logger.info("relateToUser starts:{}");
        BusinessPreconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)typeId), (BaseException)MessageUtils.buildException((ApiResultCode)ApiResultCode.PARAM_IS_NULL, (Object[])new Object[]{"typeId"}));
        BusinessPreconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)businessType), (BaseException)MessageUtils.buildException((ApiResultCode)ApiResultCode.PARAM_IS_NULL, (Object[])new Object[]{"businessType"}));
        BusinessPreconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)userId), (BaseException)MessageUtils.buildException((ApiResultCode)ApiResultCode.PARAM_IS_NULL, (Object[])new Object[]{"userId"}));
        ApiResponseResult res = null;
        this.userTypeServiceImpl.relateWithUser(userId, businessType, typeId);
        res = new ApiResponseResult(ApiResultCode.SUCCESS);
        return res;
    }

    @ApiIgnore
    @ApiOperation(value="\u89e3\u9664\u5173\u8054\u7528\u6237")
    @RequestMapping(value={"/disassociateWithUser"}, method={RequestMethod.POST})
    @ApiImplicitParams(value={@ApiImplicitParam(name="businessType", value="\u7528\u6237\u7c7b\u578b", paramType="query", required=true, dataType="string"), @ApiImplicitParam(name="typeIds", value="\u7c7b\u578bid", paramType="body", required=true, allowMultiple=true, dataType="string")})
    public ApiResponseResult disassociateWithUser(@RequestParam String businessType, @RequestBody List<String> typeIds) {
        this.logger.info("disassociateWithUser starts:{}");
        BusinessPreconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)businessType), (BaseException)MessageUtils.buildException((ApiResultCode)ApiResultCode.PARAM_IS_NULL, (Object[])new Object[]{"businessType"}));
        ApiResponseResult res = null;
        this.userTypeServiceImpl.disassociateWithUser(businessType, typeIds);
        res = new ApiResponseResult(ApiResultCode.SUCCESS);
        return res;
    }

    @ApiOperation(value="\u83b7\u53d6\u5173\u8054\u7528\u6237")
    @RequestMapping(value={"/getRelatedUser"}, method={RequestMethod.GET})
    @ApiImplicitParams(value={@ApiImplicitParam(name="businessType", value="\u7528\u6237\u7c7b\u578b", paramType="query", required=true, dataType="string"), @ApiImplicitParam(name="typeId", value="\u7c7b\u578bid", paramType="query", required=true, dataType="string")})
    public ApiResponseResult<UserVo> getRelatedUser(@RequestParam String businessType, @RequestParam String typeId) {
        this.logger.info("getRelatedUser starts:{}");
        ApiResponseResult res = null;
        UserVo userVo = this.userTypeServiceImpl.getRelatedUser(businessType, typeId);
        res = new ApiResponseResult(ApiResultCode.SUCCESS, (Object)userVo);
        return res;
    }

    @ApiOperation(value="\u83b7\u53d6\u5173\u8054\u7528\u6237ID")
    @RequestMapping(value={"/getRelatedUserId"}, method={RequestMethod.GET})
    @ApiImplicitParams(value={@ApiImplicitParam(name="businessType", value="\u7528\u6237\u7c7b\u578b", paramType="query", required=true, dataType="string"), @ApiImplicitParam(name="typeId", value="\u7c7b\u578bid", paramType="query", required=true, dataType="string")})
    public ApiResponseResult<String> getRelatedUserId(@RequestParam String businessType, @RequestParam String typeId) {
        this.logger.info("getRelatedUserId starts:{}");
        ApiResponseResult res = null;
        String userId = this.userTypeServiceImpl.getRelatedUserId(businessType, typeId);
        res = new ApiResponseResult(ApiResultCode.SUCCESS, (Object)userId);
        return res;
    }

    @ApiOperation(value="\u83b7\u53d6\u5173\u8054\u7528\u6237\u5217\u8868")
    @RequestMapping(value={"/getRelatedUserIds"}, method={RequestMethod.POST})
    @ApiImplicitParams(value={@ApiImplicitParam(name="businessType", value="\u7528\u6237\u7c7b\u578b", paramType="query", required=true, dataType="string"), @ApiImplicitParam(name="typeIds", value="\u7c7b\u578bid", paramType="body", required=true, allowMultiple=true, dataType="string")})
    public ApiResponseResult<List<String>> getRelatedUserIds(@RequestParam String businessType, @RequestBody List<String> typeIds) {
        this.logger.info("getRelatedUserIds starts:{}");
        ApiResponseResult res = null;
        List<String> userIds = this.userTypeServiceImpl.getRelatedUserIds(businessType, typeIds);
        res = new ApiResponseResult(ApiResultCode.SUCCESS, userIds);
        return res;
    }

    @ApiIgnore
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u7c7b\u578bid")
    @RequestMapping(value={"/getUserTypeId"}, method={RequestMethod.GET})
    @ApiImplicitParams(value={@ApiImplicitParam(name="businessType", value="\u7528\u6237\u7c7b\u578b", paramType="query", required=true, dataType="string"), @ApiImplicitParam(name="userId", value="\u7528\u6237ID", paramType="query", required=true, dataType="string")})
    public ApiResponseResult<String> getUserTypeId(@RequestParam String businessType, @RequestParam String userId) {
        this.logger.info("getRelatedUser starts:{}");
        ApiResponseResult res = null;
        String id = this.userTypeServiceImpl.getUserTypeId(businessType, userId);
        res = new ApiResponseResult(ApiResultCode.SUCCESS, (Object)id);
        return res;
    }

    @ApiOperation(value="\u4fee\u6539\u7528\u6237")
    @PutMapping(value={"/{id}"})
    @ApiOverride
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u7528\u6237id", paramType="path", required=true, dataType="string"), @ApiImplicitParam(name="userDto", value="\u4fee\u6539\u7684\u7528\u6237", paramType="body", required=true, dataType="UserDto")})
    public ApiResponseResult updateUser(@PathVariable String id, @RequestBody @Valid UserDto userDto) {
        BusinessPreconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)id), (BaseException)MessageUtils.buildException((ApiResultCode)ApiResultCode.PARAM_IS_NULL, (Object[])new Object[]{"id"}));
        ApiResponseResult res = null;
        userDto.setId((Serializable)((Object)id));
        int sum = this.userServiceImpl.updateUser(userDto);
        if (sum <= 0) {
            throw MessageUtils.buildException((ApiResultCode)ApiResultCode.UPDATE_DATA_FAIL, (Object[])new Object[0]);
        }
        res = new ApiResponseResult(ApiResultCode.SUCCESS);
        this.logger.info("updateUser ends:{}", (Object)res);
        return res;
    }

    @ApiOperation(value="\u91cd\u7f6e\u7528\u6237\u5bc6\u7801")
    @RequestMapping(value={"/resetPassword"}, method={RequestMethod.GET})
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", paramType="query", required=true, dataType="string")})
    public ApiResponseResult resetPassword(@RequestParam String userId) {
        this.logger.info("resetPassword starts:{}");
        ApiResponseResult res = null;
        this.userServiceImpl.resetPassword(userId);
        res = new ApiResponseResult(ApiResultCode.SUCCESS);
        return res;
    }

    @ApiOperation(value="\u83b7\u53d6\u5bfc\u51fa\u7c7b\u578b\u83dc\u5355")
    @RequestMapping(value={"/exportType/selection"}, method={RequestMethod.GET})
    public ApiResponseResult getExportTypeSelection() {
        ArrayList selection = new ArrayList();
        for (ExportType exportType : ExportType.values()) {
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.put("value", exportType.getValue());
            map.put("label", exportType.getName());
            selection.add(map);
        }
        return new ApiResponseResult(ApiResultCode.SUCCESS, selection);
    }

    @ApiOperation(value="\u83b7\u53d6\u7c7b\u578b\u83dc\u5355")
    @RequestMapping(value={"/businessType/selection"}, method={RequestMethod.GET})
    public ApiResponseResult getUserBusinessTypeSelection() {
        ArrayList selection = new ArrayList();
        for (UserBusinessType businessType : UserBusinessType.values()) {
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.put("label", businessType.getName());
            map.put("value", businessType.getValue());
            selection.add(map);
        }
        return new ApiResponseResult(ApiResultCode.SUCCESS, selection);
    }

    @ApiOperation(value="\u5bfc\u51fa\u7528\u6237\u4fe1\u606f")
    @RequestMapping(value={"/export"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="exportType", value="\u5bfc\u51fa\u7c7b\u578b", paramType="query", required=true, dataType="string")})
    public void exportUsers(@RequestParam String exportType, HttpServletResponse response) {
        BusinessPreconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)exportType), (BaseException)MessageUtils.buildException((ApiResultCode)ApiResultCode.PARAM_IS_NULL, (Object[])new Object[]{"exportType"}));
        String fileName = ExportType.getName(exportType) + ".xls";
        ExportType e = ExportType.getExportType(exportType);
        BusinessPreconditions.checkArgument((null != e ? 1 : 0) != 0, (BaseException)MessageUtils.buildException((ApiResultCode)UserApiResultCode.USER_EXPORT_USERS_INFO_FAIL, (Object[])new Object[0]));
        Workbook workbook = this.userServiceImpl.exportUsers(e);
        ResultUtils.generateExcel((HttpServletResponse)response, (String)fileName, (Workbook)workbook);
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u89d2\u8272")
    @RequestMapping(value={"/userRoles/{userId}"}, method={RequestMethod.GET})
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", paramType="path", required=true, dataType="string")})
    public ApiResponseResult<List<RoleVo>> getUserRoles(@PathVariable String userId) {
        this.logger.info("getUserRoles starts:{}");
        ApiResponseResult res = null;
        List<RoleVo> roleVos = this.roleServiceImpl.getRoleMembers(userId);
        res = new ApiResponseResult(ApiResultCode.SUCCESS, roleVos);
        return res;
    }

    @ApiOperation(value="\u6dfb\u52a0\u7528\u6237\u89d2\u8272")
    @RequestMapping(value={"/userRoles"}, method={RequestMethod.POST})
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", paramType="query", required=true, dataType="string"), @ApiImplicitParam(name="roleIds", value="\u89d2\u8272id", paramType="body", required=true, allowMultiple=true, dataType="string")})
    public ApiResponseResult setUserRoles(@RequestParam String userId, @RequestBody List<String> roleIds) {
        this.logger.info("setUserRoles starts:{}");
        int sum = this.roleServiceImpl.addRoleMembers(userId, roleIds);
        if (sum > 0) {
            return new ApiResponseResult(ApiResultCode.SUCCESS);
        }
        throw MessageUtils.buildException((ApiResultCode)ApiResultCode.INSERT_DATA_FAIL, (Object[])new Object[0]);
    }

    @ApiOperation(value="\u5220\u9664\u7528\u6237\u89d2\u8272")
    @RequestMapping(value={"/userRoles"}, method={RequestMethod.DELETE})
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", paramType="query", required=true, dataType="string"), @ApiImplicitParam(name="roleIds", value="\u89d2\u8272id", paramType="body", required=true, allowMultiple=true, dataType="string")})
    public ApiResponseResult deleteUserRoles(@RequestParam String userId, @RequestBody List<String> roleIds) {
        this.logger.info("deleteUserRoles starts:{}");
        int sum = this.roleServiceImpl.deleteRoleMembers(userId, roleIds);
        if (sum > 0) {
            return new ApiResponseResult(ApiResultCode.SUCCESS);
        }
        throw MessageUtils.buildException((ApiResultCode)ApiResultCode.DELETE_DATA_FAIL, (Object[])new Object[0]);
    }
}

