/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.starter.user.model.role;

import java.util.Arrays;
import java.util.List;

public enum RoleType {
    ADMINISTRATOR("\u79df\u6237\u7ba1\u7406\u5458", "Administrator"),
    SUPERADMINISTRATOR("\u8d85\u7ea7\u7ba1\u7406\u5458", "SuperAdministrator"),
    SYSTEMADMINISTRATOR("\u7cfb\u7edf\u7ba1\u7406\u5458", "SystemAdministrator"),
    External("\u5916\u90e8\u7528\u6237", "External"),
    INTERNAL("\u5185\u90e8\u7528\u6237", "Internal");

    private String name;
    private String value;

    private RoleType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public static String getName(String value) {
        if (value == null) {
            return null;
        }
        for (RoleType d : RoleType.values()) {
            if (!value.equals(d.value)) continue;
            return d.name;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public static List<RoleType> administrators() {
        return Arrays.asList(ADMINISTRATOR, SUPERADMINISTRATOR, SYSTEMADMINISTRATOR, External, INTERNAL);
    }

    public static List<RoleType> superAdministrators() {
        return Arrays.asList(SUPERADMINISTRATOR, SYSTEMADMINISTRATOR, External, INTERNAL);
    }

    public static List<RoleType> systemAdministrators() {
        return Arrays.asList(SUPERADMINISTRATOR, SYSTEMADMINISTRATOR, External, INTERNAL);
    }
}

