/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.starter.user.service.permission.impl;

import com.cyberway.msf.commons.base.service.BaseServiceImpl;
import com.cyberway.msf.commons.model.base.EntityImpl;
import com.cyberway.msf.starter.user.mapper.permission.EntityResourceMapper;
import com.cyberway.msf.starter.user.model.permission.EntityResource;
import com.cyberway.msf.starter.user.model.permission.Permission;
import com.cyberway.msf.starter.user.model.permission.Privilege;
import com.cyberway.msf.starter.user.service.permission.EntityResourceService;
import com.cyberway.msf.starter.user.service.permission.PermissionService;
import com.cyberway.msf.starter.user.service.permission.PrivilegeService;
import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;
import tk.mybatis.mapper.util.Sqls;

@Service
public class EntityResourceServiceImpl
extends BaseServiceImpl<EntityResource>
implements EntityResourceService {
    @Autowired
    private EntityResourceMapper entityResourceMapper;
    @Autowired
    private PermissionService permissionServiceImpl;
    @Autowired
    private PrivilegeService privilegeServiceImpl;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int batchInsert(List<EntityResource> entityResources) {
        return CollectionUtils.isEmpty(entityResources) ? 0 : this.entityResourceMapper.batchInsert(entityResources);
    }

    @Override
    public List<String> getResourceIdsByEntityId(String entityId) {
        return this.entityResourceMapper.selectByExample(Example.builder(EntityResource.class).select(new String[]{"id"}).where(Sqls.custom().andEqualTo("entityId", (Object)entityId)).build()).stream().map(EntityImpl::getId).collect(Collectors.toList());
    }

    @Override
    public List<String> getResourceIdsByEntityIds(List<String> entityIds) {
        return this.entityResourceMapper.selectByExample(Example.builder(EntityResource.class).select(new String[]{"id"}).where(Sqls.custom().andIn("entityId", entityIds)).build()).stream().map(EntityImpl::getId).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void insertMapping(String entityId, String entityName, String sourceId, String sourceType) {
        EntityResource entityResource = new EntityResource();
        entityResource.setClazz(EntityResource.class.getName());
        entityResource.setEntityName(entityName);
        entityResource.setEntityId(entityId);
        this.insert((Object)entityResource);
        Permission permission = new Permission();
        permission.setSourceId(sourceId);
        permission.setSourceType(sourceType);
        permission.setPrivilegeId(StringUtils.remove((String)UUID.randomUUID().toString(), (String)"-"));
        this.permissionServiceImpl.insert((Object)permission);
        Privilege privilege = new Privilege();
        privilege.setId((Serializable)((Object)permission.getPrivilegeId()));
        privilege.setResourceType(EntityResource.class.getName());
        privilege.setResourceId((String)((Object)entityResource.getId()));
        this.privilegeServiceImpl.insert((Object)privilege);
    }
}

