/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.starter.user.service.permission.impl;

import com.cyberway.msf.commons.base.service.BaseServiceImpl;
import com.cyberway.msf.commons.model.base.EntityImpl;
import com.cyberway.msf.starter.user.mapper.permission.PermissionMapper;
import com.cyberway.msf.starter.user.model.permission.EntityResource;
import com.cyberway.msf.starter.user.model.permission.Permission;
import com.cyberway.msf.starter.user.model.permission.Privilege;
import com.cyberway.msf.starter.user.service.permission.EntityResourceService;
import com.cyberway.msf.starter.user.service.permission.PermissionService;
import com.cyberway.msf.starter.user.service.permission.PrivilegeService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;
import tk.mybatis.mapper.util.Sqls;

@Service
public class PermissionServiceImpl
extends BaseServiceImpl<Permission>
implements PermissionService {
    @Autowired
    private PermissionMapper permissionMapper;
    @Autowired
    private PrivilegeService privilegeServiceImpl;
    @Autowired
    private EntityResourceService entityResourceServiceImpl;

    @Override
    public List<String> getPrivilegeIdsByRoleId(String roleId) {
        Example example = new Example(Permission.class);
        example.selectProperties(new String[]{"privilegeId"}).and().andEqualTo("roleId", (Object)roleId);
        List permissions = this.selectByExample(example);
        return permissions == null ? null : permissions.stream().map(Permission::getPrivilegeId).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int batchInsert(List<Permission> permissions) {
        return CollectionUtils.isEmpty(permissions) ? 0 : this.permissionMapper.batchInsert(permissions);
    }

    @Override
    public int batchInsert(List<String> resourceIds, String sourceType, List<String> sourceIds) {
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        ArrayList<Privilege> newPrivileges = new ArrayList<Privilege>();
        List<Privilege> privileges = this.privilegeServiceImpl.getDefaultPrivileges(resourceIds);
        Map<String, String> privilegeMap = privileges.stream().collect(Collectors.toMap(Privilege::getResourceId, EntityImpl::getId));
        for (String sourceId : sourceIds) {
            for (String resourceId : resourceIds) {
                Permission permission = new Permission();
                permission.setId((Serializable)((Object)StringUtils.remove((String)UUID.randomUUID().toString(), (String)"-")));
                if (privilegeMap.get(resourceId) != null) {
                    permission.setPrivilegeId(privilegeMap.get(resourceId));
                } else {
                    permission.setPrivilegeId(StringUtils.remove((String)UUID.randomUUID().toString(), (String)"-"));
                    Privilege privilege = new Privilege();
                    privilege.setId((Serializable)((Object)permission.getPrivilegeId()));
                    privilege.setResourceType(EntityResource.class.getName());
                    privilege.setResourceId(resourceId);
                    newPrivileges.add(privilege);
                }
                permission.setSourceId(sourceId);
                permission.setSourceType(sourceType);
                permissions.add(permission);
            }
        }
        if (CollectionUtils.isNotEmpty(newPrivileges)) {
            this.privilegeServiceImpl.batchInsert(newPrivileges);
        }
        return CollectionUtils.isEmpty(permissions) ? 0 : this.batchInsert(permissions);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int setPrivileges(List<String> entityIds, String sourceType, String sourceId) {
        if (CollectionUtils.isEmpty(entityIds)) {
            return 0;
        }
        List<String> entityResourceIds = this.entityResourceServiceImpl.getResourceIdsByEntityIds(entityIds);
        if (CollectionUtils.isEmpty(entityResourceIds)) {
            return 0;
        }
        List permissionIds = this.selectByExample(Example.builder(Permission.class).select(new String[]{"id"}).where(Sqls.custom().andEqualTo("sourceType", (Object)sourceType).andEqualTo("sourceId", (Object)sourceId)).build()).stream().map(EntityImpl::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(permissionIds)) {
            this.batchDelete(permissionIds);
        }
        return this.batchInsert(entityResourceIds, sourceType, Lists.newArrayList((Object[])new String[]{sourceId}));
    }
}

