/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.starter.user.service.permission.impl;

import com.cyberway.msf.commons.base.service.BaseServiceImpl;
import com.cyberway.msf.commons.model.base.EntityImpl;
import com.cyberway.msf.starter.user.mapper.permission.PrivilegeMapper;
import com.cyberway.msf.starter.user.model.permission.EntityResource;
import com.cyberway.msf.starter.user.model.permission.Privilege;
import com.cyberway.msf.starter.user.service.permission.PrivilegeService;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;
import tk.mybatis.mapper.util.Sqls;

@Service
public class PrivilegeServiceImpl
extends BaseServiceImpl<Privilege>
implements PrivilegeService {
    @Autowired
    private PrivilegeMapper privilegeMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int batchInsert(List<Privilege> privileges) {
        return CollectionUtils.isEmpty(privileges) ? 0 : this.privilegeMapper.batchInsert(privileges);
    }

    @Override
    public List<Privilege> getDefaultPrivileges(List<String> resourceIds) {
        return this.privilegeMapper.selectByExample(Example.builder(Privilege.class).where(Sqls.custom().andIn("resourceId", resourceIds).andEqualTo("resourceType", (Object)EntityResource.class.getName()).andEqualTo("operator", (Object)"access")).build());
    }

    @Override
    public List<String> selectPrivilegeIdByResourceIds(List<String> resourceIds) {
        if (CollectionUtils.isEmpty(resourceIds)) {
            return Lists.newArrayList();
        }
        List privileges = this.privilegeMapper.selectByExample(Example.builder(Privilege.class).where(Sqls.custom().andIn("resourceId", resourceIds).andEqualTo("resourceType", (Object)EntityResource.class.getName()).andEqualTo("operator", (Object)"access")).build());
        return privileges.stream().map(EntityImpl::getId).collect(Collectors.toList());
    }
}

