/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.starter.user.service.role.impl;

import com.cyberway.msf.commons.api.result.ApiResultCode;
import com.cyberway.msf.commons.base.service.BaseServiceImpl;
import com.cyberway.msf.commons.base.util.MessageUtils;
import com.cyberway.msf.commons.base.util.PageUtils;
import com.cyberway.msf.commons.base.util.SqlUtils;
import com.cyberway.msf.commons.model.base.EntityImpl;
import com.cyberway.msf.commons.model.page.PageDataModel;
import com.cyberway.msf.commons.model.page.PageModel;
import com.cyberway.msf.starter.user.mapper.role.RoleCategoryMapper;
import com.cyberway.msf.starter.user.model.role.Role;
import com.cyberway.msf.starter.user.model.role.RoleCategory;
import com.cyberway.msf.starter.user.model.user.User;
import com.cyberway.msf.starter.user.model.user.vo.UserVo;
import com.cyberway.msf.starter.user.service.role.RoleCategoryService;
import com.cyberway.msf.starter.user.service.role.RoleMemberService;
import com.cyberway.msf.starter.user.service.role.RoleService;
import com.cyberway.msf.starter.user.service.user.UserService;
import com.cyberway.msf.starter.user.support.constant.UserApiResultCode;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;
import tk.mybatis.mapper.util.Sqls;

@Service
public class RoleCategoryServiceImpl
extends BaseServiceImpl<RoleCategory>
implements RoleCategoryService {
    private final Logger logger = LoggerFactory.getLogger(RoleCategoryServiceImpl.class);
    @Autowired
    private RoleCategoryMapper roleCategoryMapper;
    @Autowired
    private RoleService roleServiceImpl;
    @Autowired
    private RoleMemberService roleMemberServiceImpl;
    @Autowired
    private UserService userServiceImpl;

    @Override
    public PageDataModel<RoleCategory> selectByExample(String code, String name, PageModel pageModel) {
        this.logger.info("RoleCategoryServiceImpl -> selectByExample() starts...");
        Example example = new Example(RoleCategory.class);
        Example.Criteria criteria = example.createCriteria();
        if (!StringUtils.isEmpty((CharSequence)code)) {
            criteria.andLike("code", SqlUtils.matchAnywhere((String)code));
        }
        if (!StringUtils.isEmpty((CharSequence)name)) {
            criteria.andLike("name", SqlUtils.matchAnywhere((String)name));
        }
        criteria.andEqualTo("deleted", (Object)false);
        PageUtils.sortAndPagination((PageModel)pageModel, (String)"sortNo", (String)"ASC", RoleCategory.class);
        List roleCategories = super.selectByExample((Object)example);
        PageDataModel pageDataModel = PageUtils.getPageDataModel((PageModel)pageModel, (Collection)roleCategories);
        this.logger.info("selectByExample ends - the param roleCategories is {}", (Object)roleCategories);
        return pageDataModel;
    }

    @Override
    public List<Map<String, Object>> selectAllRoleCategories() {
        ArrayList<Map<String, Object>> selection = new ArrayList<Map<String, Object>>();
        List roleCategories = super.selectByExample((Object)Example.builder(RoleCategory.class).where(Sqls.custom().andEqualTo("deleted", (Object)false)).build());
        for (RoleCategory roleCategory : roleCategories) {
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            map.put("value", roleCategory.getId());
            map.put("label", roleCategory.getName());
            selection.add(map);
        }
        return selection;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int batchInsert(List<RoleCategory> roleCategories) {
        return CollectionUtils.isEmpty(roleCategories) ? 0 : this.roleCategoryMapper.batchInsert(roleCategories);
    }

    @Override
    public List<String> selectUserIdsByCode(String code) {
        List roleCategories = super.selectByExample((Object)Example.builder(RoleCategory.class).where(Sqls.custom().andEqualTo("code", (Object)code).andEqualTo("deleted", (Object)false)).build());
        if (CollectionUtils.isEmpty((Collection)roleCategories)) {
            return Lists.newArrayList();
        }
        List roles = this.roleServiceImpl.selectByExample(Example.builder(Role.class).where(Sqls.custom().andEqualTo("roleCategoryId", (Object)((RoleCategory)((Object)roleCategories.get(0))).getId())).build());
        if (CollectionUtils.isEmpty((Collection)roles)) {
            return Lists.newArrayList();
        }
        List<String> roleIds = roles.stream().map(EntityImpl::getId).collect(Collectors.toList());
        return this.roleMemberServiceImpl.getMemberIds(roleIds, User.class.getName());
    }

    @Override
    public List<UserVo> selectUsersByCode(String code) {
        return this.userServiceImpl.selectUserVoByIds(this.selectUserIdsByCode(code));
    }

    protected void validateData(RoleCategory roleCategory) {
        this.validateUnique(RoleCategory.class, (EntityImpl)roleCategory, "name", roleCategory.getName(), UserApiResultCode.ROLECATEGORY_NAME_EXISTS, true);
        this.validateUnique(RoleCategory.class, (EntityImpl)roleCategory, "code", roleCategory.getCode(), UserApiResultCode.ROLECATEGORY_CODE_EXISTS, true);
    }

    @Transactional(rollbackFor={Exception.class})
    public int batchDelete(List<String> ids) {
        if (this.roleServiceImpl.contains(Example.builder(Role.class).where(Sqls.custom().andIn("roleCategoryId", ids)).build()).booleanValue()) {
            throw MessageUtils.buildException((ApiResultCode)ApiResultCode.DELETE_FAIL_REFERENCE, (Object[])new Object[0]);
        }
        RoleCategory roleCategory = new RoleCategory();
        roleCategory.setSortNo(null);
        roleCategory.setDeleted(true);
        return this.roleCategoryMapper.updateByExampleSelective((Object)roleCategory, Example.builder(RoleCategory.class).where(Sqls.custom().andIn("id", ids)).build());
    }
}

