/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.starter.user.service.role.impl;

import com.cyberway.msf.commons.base.support.configuration.CommonsBaseProperties;
import com.cyberway.msf.commons.base.util.MapBuilder;
import com.cyberway.msf.commons.poi.importer.AbstractImportExcelRowHandler;
import com.cyberway.msf.commons.poi.importer.ImportResult;
import com.cyberway.msf.commons.poi.util.ExcelUtils;
import com.cyberway.msf.core.client.DepartmentClient;
import com.cyberway.msf.core.model.department.Department;
import com.cyberway.msf.core.model.department.DepartmentType;
import com.cyberway.msf.starter.user.model.role.Role;
import com.cyberway.msf.starter.user.model.role.RoleCategory;
import com.cyberway.msf.starter.user.service.role.RoleCategoryService;
import com.cyberway.msf.starter.user.service.role.RoleService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;
import tk.mybatis.mapper.util.Sqls;

@Component
public class RoleImportExcelHandler
extends AbstractImportExcelRowHandler {
    @Autowired
    private RoleService roleServiceImpl;
    @Autowired
    private RoleCategoryService roleCategoryServiceImpl;
    private DepartmentClient departmentClient;
    @Autowired
    private CommonsBaseProperties commonsBaseProperties;
    private ThreadLocal<Map<String, Object>> dataCache = new ThreadLocal();
    private ThreadLocal<List<Role>> datas = new ThreadLocal();
    private ThreadLocal<Map<String, Object>> roleCategoryCache = new ThreadLocal();

    public String handleRow(Row row) {
        Map roles;
        Role role;
        Map roleCategorys;
        String desc;
        String systemDefault;
        String roleName;
        String roleCode;
        String roleCategoryName;
        String roleCategoryCode;
        Map<String, Object> dataCacheMap = this.dataCache.get();
        Department company = null;
        if (this.commonsBaseProperties.getStructure() == 1) {
            roleCategoryCode = ExcelUtils.readCellString((Cell)row.getCell(0));
            roleCategoryName = ExcelUtils.readCellString((Cell)row.getCell(1));
            roleCode = ExcelUtils.readCellString((Cell)row.getCell(2));
            roleName = ExcelUtils.readCellString((Cell)row.getCell(3));
            systemDefault = ExcelUtils.readCellString((Cell)row.getCell(4));
            desc = ExcelUtils.readCellString((Cell)row.getCell(5));
        } else {
            String companyCode = ExcelUtils.readCellString((Cell)row.getCell(0));
            roleCategoryCode = ExcelUtils.readCellString((Cell)row.getCell(2));
            roleCategoryName = ExcelUtils.readCellString((Cell)row.getCell(3));
            roleCode = ExcelUtils.readCellString((Cell)row.getCell(4));
            roleName = ExcelUtils.readCellString((Cell)row.getCell(5));
            systemDefault = ExcelUtils.readCellString((Cell)row.getCell(6));
            desc = ExcelUtils.readCellString((Cell)row.getCell(7));
            if (StringUtils.isBlank((CharSequence)companyCode)) {
                return "\u516c\u53f8\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a";
            }
            Map companys = (Map)dataCacheMap.get(Department.class.getName());
            company = (Department)companys.get(companyCode);
            if (company == null) {
                company = (Department)this.departmentClient.getDepartmentByCode(companyCode).getData();
                if (company == null) {
                    return "\u516c\u53f8\u7f16\u7801\u4e0d\u5b58\u5728";
                }
                if (!DepartmentType.companyValues().contains(company.getDepartmentType())) {
                    return "\u586b\u5165\u7684\u5185\u5bb9\u662f\u90e8\u95e8\u7f16\u7801\uff0c\u8bf7\u586b\u5165\u516c\u53f8\u7f16\u7801";
                }
                companys.put(companyCode, company);
            }
            if ("\u662f".equals(systemDefault) && company.getParent() != null) {
                return "\u5206\u516c\u53f8\u4e0d\u80fd\u521b\u5efa\u6807\u51c6\u89d2\u8272";
            }
        }
        if (StringUtils.isNotBlank((CharSequence)roleCategoryCode) || StringUtils.isNotBlank((CharSequence)roleCategoryName)) {
            if (StringUtils.isBlank((CharSequence)roleCategoryCode)) {
                return "\u89d2\u8272\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (StringUtils.isBlank((CharSequence)roleCategoryName)) {
                return "\u89d2\u8272\u7c7b\u578b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a";
            }
        }
        if (StringUtils.isBlank((CharSequence)roleName)) {
            return "\u89d2\u8272\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((CharSequence)roleCode)) {
            return "\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!StringUtils.equals((CharSequence)systemDefault, (CharSequence)"\u662f") && !StringUtils.equals((CharSequence)systemDefault, (CharSequence)"\u5426")) {
            return "\u662f\u5426\u6807\u51c6\u89d2\u8272\u8bf7\u586b\u5199\"\u662f\"\u6216\"\u5426\"";
        }
        RoleCategory roleCategory = null;
        if (StringUtils.isNotBlank((CharSequence)roleCategoryCode) && StringUtils.isNotBlank((CharSequence)roleCategoryName) && (roleCategory = (RoleCategory)((Object)(roleCategorys = (Map)dataCacheMap.get(RoleCategory.class.getName())).get(roleCategoryCode))) == null) {
            List roleCategoriesInSystem = this.roleCategoryServiceImpl.selectByExample(Example.builder(RoleCategory.class).where(Sqls.custom().andEqualTo("code", (Object)roleCategoryCode).andEqualTo("org", (Object)this.roleCategoryServiceImpl.getOrgId())).build());
            if (CollectionUtils.isEmpty((Collection)roleCategoriesInSystem)) {
                roleCategory = new RoleCategory();
                roleCategory.setCode(roleCategoryCode);
                roleCategory.setName(roleCategoryName);
                this.roleCategoryCache.get().put(roleCode, (Object)roleCategory);
            } else {
                roleCategory = (RoleCategory)((Object)roleCategoriesInSystem.get(0));
                roleCategory.setName(roleCategoryName);
            }
            roleCategorys.put(roleCategoryCode, roleCategory);
        }
        if ((role = (Role)((Object)(roles = (Map)dataCacheMap.get(Role.class.getName())).get(roleCode + ":" + roleName))) == null) {
            List rolesInSystem;
            Sqls sqls = Sqls.custom().andEqualTo("codeName", (Object)roleCode).andEqualTo("org", (Object)this.roleServiceImpl.getOrgId());
            if (company != null) {
                sqls = sqls.andEqualTo("companyId", (Object)company.getId());
            }
            if (CollectionUtils.isEmpty((Collection)(rolesInSystem = this.roleServiceImpl.selectByExample(Example.builder(Role.class).where(sqls).build())))) {
                role = new Role();
                role.setCompanyId(company == null ? null : (String)((Object)company.getId()));
                role.setName(roleName);
                role.setCodeName(roleCode);
                role.setDescription(desc);
                role.setRoleCategoryId((String)((Object)roleCategory.getId()));
                role.setSystemDefault("\u662f".equals(systemDefault));
            } else {
                role = (Role)((Object)rolesInSystem.get(0));
                role.setName(roleName);
                role.setDescription(desc);
                role.setRoleCategoryId((String)((Object)roleCategory.getId()));
                role.setSystemDefault("\u662f".equals(systemDefault));
            }
            roles.put(roleCode + ":" + roleName, role);
        }
        this.datas.get().add(role);
        return null;
    }

    protected void beforeHandleSheet(Sheet sheet) {
        super.beforeHandleSheet(sheet);
        this.dataCache.set(new MapBuilder().put((Object)RoleCategory.class.getName(), new HashMap()).put((Object)Role.class.getName(), new HashMap()).put((Object)Department.class.getName(), new HashMap()).build());
        this.datas.set(new ArrayList());
        this.roleCategoryCache.set(new LinkedHashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public void afterHandleSheet(Sheet sheet, ImportResult result) {
        super.afterHandleSheet(sheet, result);
        try {
            ArrayList<Role> roles = new ArrayList<Role>();
            ArrayList<RoleCategory> roleCategories = new ArrayList<RoleCategory>();
            for (Role role : this.datas.get()) {
                RoleCategory roleCategory = (RoleCategory)((Object)this.roleCategoryCache.get().get(role.getCodeName()));
                if (roleCategory != null) {
                    roleCategory.setId((Serializable)((Object)StringUtils.remove((String)UUID.randomUUID().toString(), (String)"-")));
                    role.setRoleCategoryId((String)((Object)roleCategory.getId()));
                    roleCategories.add(roleCategory);
                }
                roles.add(role);
            }
            this.roleCategoryServiceImpl.batchInsert(roleCategories);
            this.roleServiceImpl.batchInsert(roles);
        }
        finally {
            this.dataCache.remove();
            this.datas.remove();
            this.roleCategoryCache.remove();
        }
    }

    public boolean handleHeaderRows() {
        return false;
    }

    public boolean skipOnRowFail() {
        return true;
    }

    public Integer getFailCellNum() {
        return 8;
    }

    public boolean handleRowException() {
        return true;
    }
}

