/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.starter.user.service.role.impl;

import com.cyberway.msf.commons.base.service.BaseServiceImpl;
import com.cyberway.msf.starter.user.mapper.role.RoleMemberMapper;
import com.cyberway.msf.starter.user.model.role.RoleMember;
import com.cyberway.msf.starter.user.service.role.RoleMemberService;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;
import tk.mybatis.mapper.util.Sqls;

@Service
public class RoleMemberServiceImpl
extends BaseServiceImpl<RoleMember>
implements RoleMemberService {
    @Autowired
    private RoleMemberMapper roleMemberMapper;

    @Override
    public List<String> getRoleIds(String memberId, String memberType) {
        return this.roleMemberMapper.selectByExample(Example.builder(RoleMember.class).select(new String[]{"roleId"}).where(Sqls.custom().andEqualTo("memberId", (Object)memberId).andEqualTo("memberType", (Object)memberType)).build()).stream().map(RoleMember::getRoleId).collect(Collectors.toList());
    }

    @Override
    public List<String> getMemberIds(String roleId, String memberType) {
        return this.roleMemberMapper.selectByExample(Example.builder(RoleMember.class).select(new String[]{"memberId"}).where(Sqls.custom().andEqualTo("roleId", (Object)roleId).andEqualTo("memberType", (Object)memberType)).build()).stream().map(RoleMember::getMemberId).collect(Collectors.toList());
    }

    @Override
    public List<String> getMemberIds(List<String> roleIds, String memberType) {
        if (CollectionUtils.isEmpty(roleIds)) {
            return Lists.newArrayList();
        }
        return this.roleMemberMapper.selectByExample(Example.builder(RoleMember.class).select(new String[]{"memberId"}).where(Sqls.custom().andIn("roleId", roleIds).andEqualTo("memberType", (Object)memberType)).build()).stream().map(RoleMember::getMemberId).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int batchInsert(List<RoleMember> roleMembers) {
        return CollectionUtils.isEmpty(roleMembers) ? 0 : this.roleMemberMapper.batchInsert(roleMembers);
    }
}

