/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.starter.user.service.role.impl;

import com.cyberway.msf.commons.model.base.EntityImpl;
import com.cyberway.msf.commons.poi.importer.AbstractImportExcelRowHandler;
import com.cyberway.msf.commons.poi.importer.ImportResult;
import com.cyberway.msf.commons.poi.util.ExcelUtils;
import com.cyberway.msf.core.client.MenuClient;
import com.cyberway.msf.starter.user.model.permission.EntityResource;
import com.cyberway.msf.starter.user.model.permission.Permission;
import com.cyberway.msf.starter.user.model.permission.Privilege;
import com.cyberway.msf.starter.user.model.role.Role;
import com.cyberway.msf.starter.user.service.permission.EntityResourceService;
import com.cyberway.msf.starter.user.service.permission.PermissionService;
import com.cyberway.msf.starter.user.service.permission.PrivilegeService;
import com.cyberway.msf.starter.user.service.role.RoleService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;
import tk.mybatis.mapper.util.Sqls;

@Component
public class RolePrivilegesImportExcelHandler
extends AbstractImportExcelRowHandler {
    @Autowired
    private RoleService roleServiceImpl;
    @Autowired
    private PermissionService permissionServiceImpl;
    @Autowired
    private PrivilegeService privilegeServiceImpl;
    @Autowired
    private EntityResourceService entityResourceServiceImpl;
    private MenuClient menuClient;
    private ThreadLocal<Map<String, String>> roleCodeCache = new ThreadLocal();
    private ThreadLocal<Map<String, String>> menuCodeCache = new ThreadLocal();
    private ThreadLocal<Map<String, List<String>>> datas = new ThreadLocal();

    public String handleRow(Row row) {
        String roleCode = ExcelUtils.readCellString((Cell)row.getCell(1));
        String resourceCode = ExcelUtils.readCellString((Cell)row.getCell(3));
        if (StringUtils.isBlank((CharSequence)roleCode)) {
            return "\u89d2\u8272\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((CharSequence)resourceCode)) {
            return "\u6743\u9650\u8d44\u6e90\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (this.roleCodeCache.get().get(roleCode) == null) {
            return "\u89d2\u8272\u4ee3\u7801\u4e0d\u5b58\u5728";
        }
        if (this.menuCodeCache.get().get(resourceCode) == null) {
            return "\u6743\u9650\u8d44\u6e90\u4ee3\u7801\u4e0d\u5b58\u5728";
        }
        ArrayList menuIds = this.datas.get().get(this.roleCodeCache.get().get(roleCode));
        if (null == menuIds) {
            menuIds = Lists.newArrayList();
            menuIds.add(this.menuCodeCache.get().get(resourceCode));
        } else {
            menuIds.add(this.menuCodeCache.get().get(resourceCode));
        }
        this.datas.get().put(this.roleCodeCache.get().get(roleCode), menuIds);
        return null;
    }

    protected void beforeHandleSheet(Sheet sheet) {
        super.beforeHandleSheet(sheet);
        List roleCodes = this.roleServiceImpl.selectByExample(Example.builder(Role.class).select(new String[]{"codeName"}).select(new String[]{"id"}).where(Sqls.custom().andIsNotNull("codeName").andEqualTo("org", (Object)this.roleServiceImpl.getOrgId())).build());
        Map<String, String> roleMap = roleCodes.stream().filter(Objects::nonNull).collect(Collectors.toMap(Role::getCodeName, EntityImpl::getId, (key1, key2) -> key2));
        this.roleCodeCache.set(roleMap);
        this.menuCodeCache.set((Map<String, String>)this.menuClient.getMenuCodes().getData());
        this.datas.set(new LinkedHashMap());
    }

    @Transactional(rollbackFor={Exception.class})
    public void afterHandleSheet(Sheet sheet, ImportResult result) {
        super.afterHandleSheet(sheet, result);
        Map<String, List<String>> dataMap = this.datas.get();
        Set<String> keySet = dataMap.keySet();
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        ArrayList<Privilege> newPrivileges = new ArrayList<Privilege>();
        for (String roleId : keySet) {
            List<String> menuIds = dataMap.get(roleId);
            List<String> entityResourceIds = this.entityResourceServiceImpl.getResourceIdsByEntityIds(menuIds);
            List<Privilege> privileges = this.privilegeServiceImpl.getDefaultPrivileges(entityResourceIds);
            Map<String, String> privilegeMap = privileges.stream().collect(Collectors.toMap(Privilege::getResourceId, EntityImpl::getId));
            for (String resourceId : entityResourceIds) {
                Permission permission = new Permission();
                permission.setId((Serializable)((Object)StringUtils.remove((String)UUID.randomUUID().toString(), (String)"-")));
                if (privilegeMap.get(resourceId) != null) {
                    permission.setPrivilegeId(privilegeMap.get(resourceId));
                } else {
                    permission.setPrivilegeId(StringUtils.remove((String)UUID.randomUUID().toString(), (String)"-"));
                    Privilege privilege = new Privilege();
                    privilege.setResourceType(EntityResource.class.getName());
                    privilege.setId((Serializable)((Object)permission.getPrivilegeId()));
                    privilege.setResourceId(resourceId);
                    newPrivileges.add(privilege);
                }
                permission.setSourceId(roleId);
                permission.setSourceType(Role.class.getName());
                permissions.add(permission);
            }
        }
        this.permissionServiceImpl.batchInsert(permissions);
        this.privilegeServiceImpl.batchInsert(newPrivileges);
        this.datas.remove();
        this.roleCodeCache.remove();
        this.menuCodeCache.remove();
    }

    public boolean handleHeaderRows() {
        return false;
    }

    public boolean skipOnRowFail() {
        return true;
    }

    public Integer getFailCellNum() {
        return 4;
    }

    public boolean handleRowException() {
        return true;
    }
}

