/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.starter.user.service.role.impl;

import com.cyberway.msf.commons.api.result.ApiResultCode;
import com.cyberway.msf.commons.base.service.BaseServiceImpl;
import com.cyberway.msf.commons.base.util.BusinessPreconditions;
import com.cyberway.msf.commons.base.util.MessageUtils;
import com.cyberway.msf.commons.base.util.PageUtils;
import com.cyberway.msf.commons.core.exception.BaseException;
import com.cyberway.msf.commons.model.base.EntityImpl;
import com.cyberway.msf.commons.model.page.PageDataModel;
import com.cyberway.msf.commons.model.page.PageModel;
import com.cyberway.msf.commons.model.user.Resource;
import com.cyberway.msf.commons.poi.exporter.ExportEntity;
import com.cyberway.msf.core.model.tree.ZtreeNode;
import com.cyberway.msf.starter.core.service.menu.MenuItemService;
import com.cyberway.msf.starter.user.mapper.role.RoleMapper;
import com.cyberway.msf.starter.user.model.permission.Permission;
import com.cyberway.msf.starter.user.model.role.Role;
import com.cyberway.msf.starter.user.model.role.RoleMember;
import com.cyberway.msf.starter.user.model.role.RoleType;
import com.cyberway.msf.starter.user.model.role.RoleVo;
import com.cyberway.msf.starter.user.model.user.User;
import com.cyberway.msf.starter.user.service.permission.EntityResourceService;
import com.cyberway.msf.starter.user.service.permission.PermissionService;
import com.cyberway.msf.starter.user.service.permission.PrivilegeService;
import com.cyberway.msf.starter.user.service.permission.ResourceService;
import com.cyberway.msf.starter.user.service.role.RoleMemberService;
import com.cyberway.msf.starter.user.service.role.RoleService;
import com.cyberway.msf.starter.user.support.constant.UserApiResultCode;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;
import tk.mybatis.mapper.util.Sqls;

@Service
public class RoleServiceImpl
extends BaseServiceImpl<Role>
implements RoleService {
    private final Logger logger = LoggerFactory.getLogger(RoleServiceImpl.class);
    @Autowired
    private RoleMapper roleMapper;
    @Autowired
    private RoleMemberService roleMemberServiceImpl;
    @Value(value="${export.template.role}")
    private String roleTemplate;
    @Value(value="${export.template.role-exclude-department}")
    private String roleWithoutDeptTemplate;
    @Value(value="${export.name.role}")
    private String exportName;
    @Value(value="${export.template.rolePrivilege}")
    private String privilegeExportTemplate;
    @Value(value="${export.name.rolePrivilege}")
    private String privilegeExportName;
    @Autowired
    private PermissionService permissionServiceImpl;
    @Autowired
    private PrivilegeService privilegeServiceImpl;
    @Autowired
    private ResourceService resourceServiceImpl;
    @Autowired
    private EntityResourceService entityResourceServiceImpl;
    @Autowired
    MenuItemService menuItemServiceImpl;

    @Override
    public RoleVo selectVoById(String id) {
        this.logger.info("RoleServiceImpl -> selectVoById() starts:{}", (Object)id);
        RoleVo roleVo = this.roleMapper.selectRoleVoById(id);
        if (roleVo != null) {
            roleVo.setTypeName(RoleType.getName(roleVo.getType()));
        }
        this.logger.info("RoleServiceImpl -> selectVoById() ends:{}", (Object)roleVo);
        return roleVo;
    }

    @Override
    public PageDataModel<RoleVo> selectVoByExample(String companyId, String name, String roleCategoryId, Boolean systemDefault, PageModel pageModel) {
        this.logger.info("RoleServiceImpl -> selectVoByExample() starts...");
        if (this.getStructure() != 1) {
            BusinessPreconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)companyId), (BaseException)MessageUtils.buildException((ApiResultCode)ApiResultCode.PARAM_IS_NULL, (Object[])new Object[]{"companyId"}));
        }
        PageUtils.sortAndPagination((PageModel)pageModel, Role.class);
        List<RoleVo> roleVos = this.roleMapper.selectRoleVoByExample(companyId, name, roleCategoryId, systemDefault);
        for (RoleVo roleVo : roleVos) {
            roleVo.setTypeName(RoleType.getName(roleVo.getType()));
        }
        PageDataModel pageDataModel = PageUtils.getPageDataModel((PageModel)pageModel, roleVos);
        this.logger.info("RoleServiceImpl -> selectVoByExample ends: {}", (Object)pageDataModel.getRows());
        return pageDataModel;
    }

    @Transactional(rollbackFor={Exception.class})
    public int insert(Role role) {
        int sum = super.insert((Object)role);
        if (sum > 0 && StringUtils.isNotEmpty((String)role.getInitRoleId())) {
            this.copyRolePrivileges((String)((Object)role.getId()), role.getInitRoleId());
        }
        return sum;
    }

    private void copyRolePrivileges(String roleId, String initRoleId) {
        List<String> privilegeIds = this.permissionServiceImpl.getPrivilegeIdsByRoleId(initRoleId);
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        for (String privilegeId : privilegeIds) {
            Permission permission = new Permission();
            permission.setPrivilegeId(privilegeId);
            permission.setSourceId(roleId);
            permission.setSourceType(Role.class.getName());
            permissions.add(permission);
        }
        this.permissionServiceImpl.batchInsert(permissions);
    }

    @Transactional(rollbackFor={Exception.class})
    public int batchDelete(List<String> ids) {
        Role role = new Role();
        role.setType(null);
        role.setSystemDefault(null);
        role.setDeleted(true);
        return this.roleMapper.updateByExampleSelective((Object)role, Example.builder(Role.class).where(Sqls.custom().andIn("id", ids)).build());
    }

    @Override
    public Workbook exportRoles(String companyId, String name, String roleCategoryId, Boolean systemDefault) {
        try {
            List<LinkedHashMap<String, Object>> list = null;
            String template = "";
            if (this.getStructure() == 1) {
                list = this.roleMapper.selectRolesWithoutDept(name, roleCategoryId, systemDefault);
                template = this.roleWithoutDeptTemplate;
            } else {
                BusinessPreconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)companyId), (BaseException)MessageUtils.buildException((ApiResultCode)ApiResultCode.PARAM_IS_NULL, (Object[])new Object[]{"companyId"}));
                list = this.roleMapper.selectRoles(companyId, name, roleCategoryId, systemDefault);
                template = this.roleTemplate;
            }
            ArrayList<Object[]> datas = new ArrayList<Object[]>();
            for (LinkedHashMap<String, Object> map : list) {
                datas.add(map.values().toArray());
            }
            ExportEntity excelExporter = new ExportEntity((org.springframework.core.io.Resource)new ClassPathResource(template), datas);
            excelExporter.setExportName(this.exportName);
            return excelExporter.export();
        }
        catch (Exception e) {
            this.logger.error("Export employees fail.");
            throw MessageUtils.buildException((ApiResultCode)UserApiResultCode.ROLE_EXPORT_ROLES_FAIL, (Object[])new Object[0]);
        }
    }

    @Override
    public Workbook exportRolePrivileges(String companyId, String name, String roleCategoryId, Boolean systemDefault) {
        try {
            if (this.getStructure() != 1) {
                BusinessPreconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)companyId), (BaseException)MessageUtils.buildException((ApiResultCode)ApiResultCode.PARAM_IS_NULL, (Object[])new Object[]{"companyId"}));
            }
            List<LinkedHashMap<String, Object>> list = this.roleMapper.selectRolePrivileges(companyId, name, roleCategoryId, systemDefault);
            ArrayList<Object[]> datas = new ArrayList<Object[]>();
            for (LinkedHashMap<String, Object> map : list) {
                datas.add(map.values().toArray());
            }
            ExportEntity excelExporter = new ExportEntity((org.springframework.core.io.Resource)new ClassPathResource(this.privilegeExportTemplate), datas);
            excelExporter.setExportName(this.privilegeExportName);
            return excelExporter.export();
        }
        catch (Exception e) {
            this.logger.error("Export employees fail.");
            throw MessageUtils.buildException((ApiResultCode)UserApiResultCode.ROLE_EXPORT_ROLEPRIVILEGES_FAIL, (Object[])new Object[0]);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int setRolePrivileges(String roleId, List<String> entityIds) {
        return this.permissionServiceImpl.setPrivileges(entityIds, Role.class.getName(), roleId);
    }

    @Override
    public List<ZtreeNode> getRolePrivileges(String roleId) {
        List<String> resources = this.resourceServiceImpl.getResourcesBySourceId(roleId).stream().map(Resource::getEntityId).collect(Collectors.toList());
        List ztreeNodes = this.menuItemServiceImpl.getMenuTree();
        this.setZtreeNodeChosen(ztreeNodes, resources);
        return ztreeNodes;
    }

    private void setZtreeNodeChosen(List<ZtreeNode> ztreeNodes, List<String> resources) {
        for (ZtreeNode ztreeNode : ztreeNodes) {
            if (resources.contains(ztreeNode.getId())) {
                ztreeNode.setChosen(Boolean.valueOf(true));
            }
            if (!CollectionUtils.isNotEmpty((Collection)ztreeNode.getChildren())) continue;
            this.setZtreeNodeChosen(ztreeNode.getChildren(), resources);
        }
    }

    @Override
    public int addRoleMembers(String userId, List<String> roleIds) {
        ArrayList<RoleMember> roleMembers = new ArrayList<RoleMember>();
        if (StringUtils.isEmpty((String)userId)) {
            return 0;
        }
        for (String roleId : roleIds) {
            RoleMember roleMember = new RoleMember();
            roleMember.setRoleId(roleId);
            roleMember.setMemberId(userId);
            roleMember.setMemberType(User.class.getName());
            roleMembers.add(roleMember);
        }
        return CollectionUtils.isEmpty(roleMembers) ? 0 : this.roleMemberServiceImpl.batchInsert(roleMembers);
    }

    @Override
    public List<RoleVo> getRoleMembers(String userId) {
        List<String> roleIds = this.roleMemberServiceImpl.getRoleIds(userId, User.class.getName());
        if (CollectionUtils.isEmpty(roleIds)) {
            return Lists.newArrayList();
        }
        return this.roleMapper.selectRoleVoByIds(roleIds);
    }

    @Override
    public int deleteRoleMembers(String userId, List<String> roleIds) {
        if (CollectionUtils.isEmpty(roleIds)) {
            return 0;
        }
        List ids = this.roleMemberServiceImpl.selectByExample(Example.builder(RoleMember.class).select(new String[]{"id"}).where(Sqls.custom().andIn("roleId", roleIds).andEqualTo("memberType", (Object)User.class.getName()).andEqualTo("memberId", (Object)userId)).build()).stream().map(EntityImpl::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)) {
            return 0;
        }
        return this.roleMemberServiceImpl.batchDelete(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int batchInsert(List<Role> roles) {
        return CollectionUtils.isEmpty(roles) ? 0 : this.roleMapper.batchInsert(roles);
    }

    @Override
    public List<RoleVo> getRoleResource(String entityId, String entityName) {
        List<String> roleIds = this.resourceServiceImpl.getRoleIdsByResourceId(entityId, entityName);
        if (CollectionUtils.isEmpty(roleIds)) {
            return Lists.newArrayList();
        }
        return this.roleMapper.selectRoleVoByIds(roleIds);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int addRoleResource(String entityId, List<String> roleIds) {
        List<String> resourceIds = this.entityResourceServiceImpl.getResourceIdsByEntityId(entityId);
        return CollectionUtils.isEmpty(resourceIds) ? 0 : this.permissionServiceImpl.batchInsert(resourceIds, Role.class.getName(), roleIds);
    }

    @Override
    public int deleteRoleResource(String entityId, List<String> roleIds) {
        if (CollectionUtils.isEmpty(roleIds)) {
            return 0;
        }
        List<String> resourceIds = this.entityResourceServiceImpl.getResourceIdsByEntityId(entityId);
        List<String> privilegeIds = this.privilegeServiceImpl.selectPrivilegeIdByResourceIds(resourceIds);
        if (CollectionUtils.isEmpty(privilegeIds)) {
            return 0;
        }
        List ids = this.permissionServiceImpl.selectByExample(Example.builder(Permission.class).select(new String[]{"id"}).where(Sqls.custom().andIn("roleId", roleIds).andIn("privilegeId", privilegeIds)).build()).stream().map(EntityImpl::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)) {
            return 0;
        }
        return this.permissionServiceImpl.batchDelete(ids);
    }

    @Override
    public List<String> getUserIds(String roleId) {
        return this.roleMemberServiceImpl.getMemberIds(roleId, User.class.getName());
    }

    @Override
    public List<String> getUserIdsByRoleCode(String codeName, String org) {
        List roles = this.roleMapper.selectByExample(Example.builder(Role.class).where(Sqls.custom().andEqualTo("codeName", (Object)codeName).andEqualTo("org", (Object)org)).build());
        if (CollectionUtils.isEmpty((Collection)roles)) {
            return Lists.newArrayList();
        }
        return this.roleMemberServiceImpl.getMemberIds((String)((Object)((Role)((Object)roles.get(0))).getId()), User.class.getName());
    }

    protected void validateData(Role role) {
        if (this.getStructure() != 1) {
            BusinessPreconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)role.getCompanyId()), (BaseException)MessageUtils.buildException((ApiResultCode)ApiResultCode.PARAM_IS_NULL, (Object[])new Object[]{"companyId"}));
            Sqls sqls = Sqls.custom().andNotEqualTo("id", (Object)StringUtils.defaultString((String)((String)((Object)role.getId())))).andEqualTo("codeName", (Object)role.getCodeName()).andEqualTo("companyId", (Object)role.getCompanyId()).andEqualTo("deleted", (Object)false);
            this.validateBySqls(Role.class, sqls, UserApiResultCode.ROLE_CODENAME_EXISTS, new Object[]{role.getCodeName()});
        } else {
            this.validateUnique(Role.class, (EntityImpl)role, "codeName", role.getCodeName(), UserApiResultCode.ROLE_CODENAME_EXISTS, true);
        }
    }
}

