/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.starter.user.service.user.impl;

import com.alibaba.fastjson.JSON;
import com.cyberway.msf.commons.api.result.ApiResultCode;
import com.cyberway.msf.commons.auth.util.JwtUtils;
import com.cyberway.msf.commons.base.support.annotation.log.LogModule;
import com.cyberway.msf.commons.base.support.annotation.log.LogRequired;
import com.cyberway.msf.commons.base.support.configuration.CommonsBaseProperties;
import com.cyberway.msf.commons.base.util.BusinessPreconditions;
import com.cyberway.msf.commons.base.util.MessageUtils;
import com.cyberway.msf.commons.cache.RedisUtils;
import com.cyberway.msf.commons.core.exception.BaseException;
import com.cyberway.msf.commons.model.user.Resource;
import com.cyberway.msf.commons.model.user.UserInfo;
import com.cyberway.msf.starter.user.model.role.RoleType;
import com.cyberway.msf.starter.user.model.role.RoleVo;
import com.cyberway.msf.starter.user.model.user.User;
import com.cyberway.msf.starter.user.model.user.dto.UserLoginDto;
import com.cyberway.msf.starter.user.service.permission.ResourceService;
import com.cyberway.msf.starter.user.service.role.RoleService;
import com.cyberway.msf.starter.user.service.user.LoginService;
import com.cyberway.msf.starter.user.service.user.UserService;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LoginServiceImpl
implements LoginService {
    private static final Logger logger = LoggerFactory.getLogger(LoginServiceImpl.class);
    @Autowired
    private UserService userServiceImpl;
    @Autowired
    private ResourceService resourceServiceImpl;
    @Autowired
    private RoleService roleServiceImpl;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private JwtUtils jwtUtils;
    @Autowired
    private CommonsBaseProperties commonsBaseProperties;

    @Override
    @LogRequired(content="'\u7528\u6237 '''+#ret.username+'''\u5df2\u6210\u529f\u767b\u5f55'", module=LogModule.LOGIN)
    public UserInfo login(UserLoginDto userLoginDto) {
        logger.debug("LoginServiceImpl -> login() starts..");
        UserInfo userInfo = null;
        if (!this.commonsBaseProperties.getSingleTenant().booleanValue()) {
            BusinessPreconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)userLoginDto.getTenantCode()), (BaseException)MessageUtils.buildException((ApiResultCode)ApiResultCode.PARAM_IS_NULL, (Object[])new Object[]{"tenantCode"}));
            userInfo = this.userServiceImpl.login(userLoginDto.getTenantCode(), userLoginDto.getUsername(), userLoginDto.getPassword());
        } else {
            userInfo = this.userServiceImpl.login(userLoginDto.getUsername(), userLoginDto.getPassword());
        }
        if (userInfo != null) {
            List roleTypes = this.roleServiceImpl.getRoleMembers((String)((Object)userInfo.getId())).stream().map(RoleVo::getType).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(roleTypes) && (roleTypes.contains(RoleType.ADMINISTRATOR.getValue()) || roleTypes.contains(RoleType.SUPERADMINISTRATOR.getValue()) || roleTypes.contains(RoleType.SYSTEMADMINISTRATOR.getValue()))) {
                this.redisUtils.setOrigin(String.format("roleType:%s", userInfo.getId()), roleTypes);
            }
            List<Resource> orgResources = this.resourceServiceImpl.getResourcesBySourceId(userInfo.getTenantId());
            this.redisUtils.setOrigin(String.format("resources:%s", userInfo.getTenantId()), (Object)JSON.toJSONString(orgResources));
            List<Resource> resources = this.resourceServiceImpl.getResourcesByUserId((String)((Object)userInfo.getId()));
            this.redisUtils.setOrigin(String.format("resources:%s", userInfo.getId()), (Object)JSON.toJSONString(resources));
        }
        return userInfo;
    }

    @Override
    @LogRequired(content="'\u7528\u6237 '''+#ret+'''\u767b\u5f55\u5931\u6548'", module=LogModule.LOGIN)
    public String loginExpiration(String expiredKey) {
        logger.debug("LoginServiceImpl -> loginExpiration() starts..");
        logger.debug("expiredKey:{}", (Object)expiredKey);
        String token = StringUtils.substringAfter((String)expiredKey, (String)"auth_user_token_");
        JwtUtils.JwtResult jwtResult = this.jwtUtils.checkToken(token);
        logger.debug("JwtResult:{}", (Object)jwtResult);
        String id = jwtResult.getUid();
        this.redisUtils.delOrigin(new String[]{String.format("auth_user_token_%s", id)});
        this.redisUtils.delOrigin(new String[]{String.format("roleType:%s", id)});
        this.redisUtils.delOrigin(new String[]{String.format("resources:%s", id)});
        this.redisUtils.delOrigin(new String[]{String.format("resourcesURL:%s", id)});
        User user = (User)((Object)this.userServiceImpl.selectById(id));
        String username = "";
        if (user != null) {
            username = user.getLoginName();
            this.redisUtils.delOrigin(new String[]{String.format("resources:%s", user.getTenantId())});
        }
        logger.debug("loginExpiration user : {}", (Object)username);
        return username;
    }
}

