/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.starter.user.service.user.impl;

import com.cyberway.msf.commons.api.result.ApiResultCode;
import com.cyberway.msf.commons.base.service.BaseServiceImpl;
import com.cyberway.msf.commons.base.util.BeanUtils;
import com.cyberway.msf.commons.base.util.BusinessPreconditions;
import com.cyberway.msf.commons.base.util.MessageUtils;
import com.cyberway.msf.commons.base.util.PageUtils;
import com.cyberway.msf.commons.core.exception.BaseException;
import com.cyberway.msf.commons.core.i18n.I18nUtils;
import com.cyberway.msf.commons.model.base.EntityImpl;
import com.cyberway.msf.commons.model.page.PageDataModel;
import com.cyberway.msf.commons.model.page.PageModel;
import com.cyberway.msf.commons.model.user.UserInfo;
import com.cyberway.msf.commons.poi.exporter.ExportEntity;
import com.cyberway.msf.core.model.organization.PasswordSettings;
import com.cyberway.msf.starter.user.ldap.ILdapUser;
import com.cyberway.msf.starter.user.ldap.ILdapUserService;
import com.cyberway.msf.starter.user.mapper.role.RoleMapper;
import com.cyberway.msf.starter.user.mapper.user.UserMapper;
import com.cyberway.msf.starter.user.model.role.Role;
import com.cyberway.msf.starter.user.model.role.RoleCategory;
import com.cyberway.msf.starter.user.model.role.RoleMember;
import com.cyberway.msf.starter.user.model.user.ExportType;
import com.cyberway.msf.starter.user.model.user.User;
import com.cyberway.msf.starter.user.model.user.UserBusinessType;
import com.cyberway.msf.starter.user.model.user.UserType;
import com.cyberway.msf.starter.user.model.user.dto.UserDto;
import com.cyberway.msf.starter.user.model.user.dto.UserPasswordUpdateDto;
import com.cyberway.msf.starter.user.model.user.vo.UserVo;
import com.cyberway.msf.starter.user.service.role.RoleMemberService;
import com.cyberway.msf.starter.user.service.user.UserService;
import com.cyberway.msf.starter.user.service.user.UserTypeService;
import com.cyberway.msf.starter.user.support.constant.UserApiResultCode;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.DigestUtils;
import tk.mybatis.mapper.entity.Example;
import tk.mybatis.mapper.util.Sqls;

@Service
public class UserServiceImpl
extends BaseServiceImpl<User>
implements UserService {
    private final Logger logger = LoggerFactory.getLogger(UserServiceImpl.class);
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private RoleMapper roleMapper;
    @Autowired
    private UserTypeService userTypeServiceImpl;
    @Autowired
    private RoleMemberService roleMemberServiceImpl;
    @Autowired
    private I18nUtils i18nUtils;
    @Autowired(required=false)
    @Qualifier(value="ldapUserService")
    ILdapUserService ldapUserService;
    private BCryptPasswordEncoder encoder = new BCryptPasswordEncoder();
    @Value(value="${core.single.tenantId}")
    String tenantId;

    @Override
    public UserInfo login(String loginName, String password) {
        return this.login(null, loginName, password);
    }

    @Override
    public UserInfo login(String tenantCode, String loginName, String password) {
        User user;
        this.logger.debug("UserServiceImpl -> login() starts..");
        Example example = new Example(User.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("loginName", (Object)loginName).andEqualTo("deleted", (Object)Boolean.FALSE).andIsNull("ldapUserId");
        if (StringUtils.isNotEmpty((CharSequence)tenantCode)) {
            criteria.andEqualTo("tenantCode", (Object)tenantCode);
        }
        example.setOrderByClause("'lastModified' DESC");
        List users = this.userMapper.selectByExample(example);
        User user2 = user = CollectionUtils.isEmpty((Collection)users) ? null : (User)((Object)users.get(0));
        if (user == null || !this.encoder.matches((CharSequence)password, user.getPassword())) {
            return null;
        }
        user.setLastLoggedIn(new Date());
        this.update((Object)user);
        UserInfo userInfo = new UserInfo();
        userInfo.setId(user.getId());
        userInfo.setUsername(user.getLoginName());
        userInfo.setOrgId(user.getOrgId());
        userInfo.setTenantId(user.getTenantId());
        userInfo.setFullName(user.getFullName());
        this.logger.info("login() - the param userInfo is {}", (Object)userInfo);
        return userInfo;
    }

    @Override
    @Transactional(rollbackFor={BaseException.class})
    public void updatePassword(UserPasswordUpdateDto dto) {
        UserInfo userInfo = this.getLoggedInUser();
        User user = (User)((Object)super.selectById((Object)dto.getUserId()));
        BusinessPreconditions.checkArgument((null != userInfo ? 1 : 0) != 0, (BaseException)MessageUtils.buildException((ApiResultCode)UserApiResultCode.USER_UPDATE_PASSWORD_UNVALID, (Object[])new Object[0]));
        BusinessPreconditions.checkArgument((null != user ? 1 : 0) != 0, (BaseException)MessageUtils.buildException((ApiResultCode)UserApiResultCode.USER_NOT_EXISTS, (Object[])new Object[0]));
        BusinessPreconditions.checkArgument((boolean)StringUtils.equals((CharSequence)((CharSequence)((Object)userInfo.getId())), (CharSequence)((CharSequence)((Object)user.getId()))), (BaseException)MessageUtils.buildException((ApiResultCode)UserApiResultCode.USER_UPDATE_PASSWORD_UNVALID, (Object[])new Object[0]));
        BusinessPreconditions.checkArgument((boolean)dto.getConfirmNewPassword().equals(dto.getNewPassword()), (BaseException)MessageUtils.buildException((ApiResultCode)UserApiResultCode.USER_CONFIRM_PASSWORD_FAIL, (Object[])new Object[0]));
        BusinessPreconditions.checkArgument((boolean)this.encoder.matches((CharSequence)dto.getOldPassword(), user.getPassword()), (BaseException)MessageUtils.buildException((ApiResultCode)UserApiResultCode.USER_OLD_PASSWORD_INCORRECT, (Object[])new Object[0]));
        this.validatePassword(user, dto.getNewPassword());
        super.update((Object)user);
    }

    @Override
    public UserVo selectVoById(String id) {
        this.logger.info("UserServiceImpl -> selectVoById() starts:{}", (Object)id);
        UserVo userVo = this.userMapper.selectUserVoById(id);
        if (userVo != null && CollectionUtils.isNotEmpty(userVo.getBusinessType())) {
            userVo.setBusinessTypeName(StringUtils.join((Iterable)userVo.getBusinessType().stream().map(UserBusinessType::getName).collect(Collectors.toList()), (String)","));
        }
        this.logger.info("UserServiceImpl -> selectVoById() ends:{}", (Object)userVo);
        return userVo;
    }

    @Override
    public PageDataModel selectVoByExample(String fullName, String loginName, String businessType, PageModel pageModel) {
        this.logger.info("UserServiceImpl -> selectVoByExample() starts...");
        PageUtils.sortAndPagination((PageModel)pageModel, (String)"lastModified", (String)"DESC", User.class);
        List<UserVo> userVos = this.userMapper.selectVoByExample(fullName, loginName, businessType);
        for (UserVo userVo : userVos) {
            if (CollectionUtils.isEmpty(userVo.getBusinessType())) continue;
            userVo.setBusinessTypeName(StringUtils.join((Iterable)userVo.getBusinessType().stream().map(UserBusinessType::getName).collect(Collectors.toList()), (String)","));
        }
        PageDataModel pageDataModel = PageUtils.getPageDataModel((PageModel)pageModel, userVos);
        this.logger.info("UserServiceImpl -> selectVoByExample ends: {}", (Object)pageDataModel.getRows());
        return pageDataModel;
    }

    @Override
    @Transactional(rollbackFor={BaseException.class})
    public int insertUser(UserDto userDto, User user) {
        this.logger.info("UserServiceImpl -> insertUser() starts...");
        this.validateUnique(User.class, userDto, "loginName", userDto.getLoginName(), UserApiResultCode.USER_LOGINNAME_EXISTS, true);
        BeanUtils.copyPropertiesIgnoreNull((Object)((Object)userDto), (Object)((Object)user));
        user.setPassword(this.encoder.encode((CharSequence)user.getPassword()));
        user.setBusinessType(Lists.newArrayList((Object[])new String[]{UserBusinessType.DEFAULT.getValue()}));
        int persistUser = this.persistUser(user);
        Role role = (Role)((Object)this.roleMapper.selectOneByExample(Example.builder(Role.class).andWhere(Sqls.custom().andEqualTo("codeName", (Object)"GlobalObserver")).build()));
        this.addRoleMembers((String)((Object)role.getId()), Lists.newArrayList((Object[])new String[]{(String)((Object)user.getId())}));
        return persistUser;
    }

    @Override
    @Transactional(rollbackFor={BaseException.class})
    public int updateUser(UserDto userDto) {
        this.logger.info("UserServiceImpl -> updateUser() starts...");
        User user = (User)((Object)super.selectById((Object)userDto.getId()));
        if (user == null) {
            return 0;
        }
        this.validateUnique(User.class, userDto, "loginName", userDto.getLoginName(), UserApiResultCode.USER_LOGINNAME_EXISTS, true);
        userDto.setPassword(null);
        BeanUtils.copyPropertiesIgnoreNull((Object)((Object)userDto), (Object)((Object)user));
        return this.persistUser(user);
    }

    @Transactional(rollbackFor={Exception.class})
    public int batchDelete(List<String> ids) {
        List userTypeIds = this.userTypeServiceImpl.selectByExample(Example.builder(UserType.class).select(new String[]{"id"}).where(Sqls.custom().andIn("userId", ids)).build()).stream().map(EntityImpl::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(userTypeIds)) {
            this.userTypeServiceImpl.batchDelete(userTypeIds);
        }
        User user = new User();
        user.setBusinessType(null);
        user.setLastLoggedIn(null);
        user.setLastActivity(null);
        user.setSubUserType(null);
        user.setPasswordHistories(null);
        user.setForcedChangePassword(null);
        user.setEnabled(null);
        user.setDeleted(true);
        return this.userMapper.updateByExampleSelective((Object)user, Example.builder(RoleCategory.class).where(Sqls.custom().andIn("id", ids)).build());
    }

    private String validatePassword(User user, PasswordSettings passwordSettings, String password) {
        Integer minLength = passwordSettings.getMinLength();
        if (password.length() < minLength) {
            return this.i18nUtils.getMessageWithArgs("lengthErrorMessage", true, new Object[]{Integer.toString(minLength)});
        }
        PasswordSettings.Complexity complexity = passwordSettings.getComplexity();
        if (complexity != null && complexity.getPattern() != null && !complexity.getPattern().matcher(password).matches()) {
            return this.i18nUtils.getMessage("complexErrorMessage-" + complexity.name());
        }
        if (user != null && user.getPasswordHistories() != null && user.getPasswordHistories().size() > 0 && passwordSettings.getHistory() > 0) {
            ArrayList passwordHistories = Lists.newArrayList(user.getPasswordHistories());
            passwordHistories.add(0, user.getPassword());
            Integer history = passwordSettings.getHistory();
            int index = 0;
            for (String passwordHistory : passwordHistories) {
                if (++index > history) break;
                if (!StringUtils.isNotBlank((CharSequence)passwordHistory) || !this.encoder.matches((CharSequence)passwordHistory, password)) continue;
                return this.i18nUtils.getMessageWithArgs("historyErrorMessage", true, new Object[]{Integer.toString(history)});
            }
        }
        return null;
    }

    @Override
    public Workbook exportUsers(ExportType exportType) {
        try {
            List<Object> list = new ArrayList();
            String org = this.getOrgId();
            switch (exportType) {
                case USER_ROLE: {
                    list = this.userMapper.selectUserRole(org);
                    break;
                }
                case ROLE_PRIVILEGE: {
                    list = this.roleMapper.selectRolePrivilege(org);
                    break;
                }
                case USER_PRIVILEGE: {
                    list = this.userMapper.selectUserPrivilege(org);
                    break;
                }
            }
            ArrayList<Object[]> datas = new ArrayList<Object[]>();
            for (Map map : list) {
                datas.add(map.values().toArray());
            }
            ExportEntity excelExporter = new ExportEntity(exportType.getName(), exportType.getHeaders(), datas);
            excelExporter.setExportName(exportType.getName() + ".xls");
            return excelExporter.export();
        }
        catch (Exception e) {
            this.logger.error("Export users info fail:{}", (Object)e.getMessage());
            throw MessageUtils.buildException((ApiResultCode)UserApiResultCode.USER_EXPORT_USERS_INFO_FAIL, (Object[])new Object[0]);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int insertUser(UserDto userDto, User user, String typeId, String businessType) {
        this.logger.info("UserServiceImpl -> insertUser() starts...");
        this.validateUnique(User.class, userDto, "loginName", userDto.getLoginName(), UserApiResultCode.USER_LOGINNAME_EXISTS, true);
        BeanUtils.copyPropertiesIgnoreNull((Object)((Object)userDto), (Object)((Object)user));
        user.setBusinessType(Lists.newArrayList((Object[])new String[]{UserBusinessType.EMPLOYEE.getValue()}));
        int sum = this.persistUser(user);
        if (sum > 0) {
            UserType userType = new UserType();
            userType.setUserId((String)((Object)user.getId()));
            userType.setTypeId(typeId);
            userType.setBusinessType(businessType);
            this.userTypeServiceImpl.insert((Object)userType);
        }
        return sum;
    }

    @Override
    public void resetPassword(String useId) {
        User user = (User)((Object)this.selectById(useId));
        user.setPassword(this.encoder.encode((CharSequence)DigestUtils.md5DigestAsHex((byte[])"admin147".getBytes())));
        this.update((Object)user);
    }

    @Override
    public List<UserVo> getRoleMembers(String roleId) {
        List<String> userIds = this.roleMemberServiceImpl.getMemberIds(roleId, User.class.getName());
        if (CollectionUtils.isEmpty(userIds)) {
            return Lists.newArrayList();
        }
        return this.userMapper.selectUserVoByIds(userIds);
    }

    @Override
    public List<UserVo> selectUserVoByIds(List<String> userIds) {
        return this.userMapper.selectUserVoByIds(userIds);
    }

    @Override
    public int addRoleMembers(String roleId, List<String> userIds) {
        ArrayList<RoleMember> roleMembers = new ArrayList<RoleMember>();
        for (String userId : userIds) {
            if (StringUtils.isEmpty((CharSequence)userId)) continue;
            RoleMember roleMember = new RoleMember();
            roleMember.setMemberId(userId);
            roleMember.setRoleId(roleId);
            roleMember.setMemberType(User.class.getName());
            roleMembers.add(roleMember);
        }
        return CollectionUtils.isEmpty(roleMembers) ? 0 : this.roleMemberServiceImpl.batchInsert(roleMembers);
    }

    @Override
    public int deleteRoleMembers(String roleId, List<String> userIds) {
        if (CollectionUtils.isEmpty(userIds)) {
            return 0;
        }
        List ids = this.roleMemberServiceImpl.selectByExample(Example.builder(RoleMember.class).select(new String[]{"id"}).where(Sqls.custom().andEqualTo("roleId", (Object)roleId).andEqualTo("memberType", (Object)User.class.getName()).andIn("memberId", userIds)).build()).stream().map(EntityImpl::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)) {
            return 0;
        }
        return this.roleMemberServiceImpl.batchDelete(ids);
    }

    private void validatePassword(UserDto userDto, User user) {
        String newPassword = userDto.getPassword();
        this.validatePassword(user, newPassword);
    }

    private void validatePassword(User user, String newPassword) {
        if (StringUtils.isNotBlank((CharSequence)newPassword)) {
            String validateError = "";
            validateError = StringUtils.isBlank((CharSequence)((CharSequence)((Object)user.getId()))) ? this.validatePassword(user, this.getOrg().getSettings().getPassword(), newPassword) : this.validatePassword(user, this.getOrg(user.getOrgId()).getSettings().getPassword(), newPassword);
            if (StringUtils.isNotBlank((CharSequence)validateError)) {
                throw MessageUtils.buildException((ApiResultCode)UserApiResultCode.USER_UNVALID_PASSWORD, (Object[])new Object[]{validateError});
            }
        } else if (StringUtils.isBlank((CharSequence)((CharSequence)((Object)user.getId())))) {
            throw MessageUtils.buildException((ApiResultCode)UserApiResultCode.USER_PASSWORD_CANNOT_EMPTY, (Object[])new Object[0]);
        }
        this.updatePassword(user, newPassword);
    }

    private void updatePassword(User user, String newPassword) {
        if (StringUtils.isNotBlank((CharSequence)newPassword)) {
            user.setPassword(this.encoder.encode((CharSequence)newPassword));
            int history = this.getOrg().getSettings().getPassword().getHistory();
            if (history > 0) {
                if (StringUtils.isNotBlank((CharSequence)user.getPassword())) {
                    user.getPasswordHistories().add(0, user.getPassword());
                }
                while (user.getPasswordHistories().size() > history) {
                    user.getPasswordHistories().remove(history);
                }
            }
            user.setPasswordLastModified(new Date());
            user.setForcedChangePassword((byte)0);
        }
    }

    private int persistUser(User user) {
        Integer sum = 0;
        user.setDisplayLoginName(user.getLoginName());
        String id = (String)((Object)user.getId());
        if (StringUtils.isBlank((CharSequence)id)) {
            id = StringUtils.remove((String)UUID.randomUUID().toString(), (String)"-");
            user.setId((Serializable)((Object)id));
            sum = this.insert((Object)user);
        } else {
            sum = this.update((Object)user);
        }
        List subUserList = this.selectByExample(Example.builder(User.class).where(Sqls.custom().andEqualTo("topMainUserId", (Object)id)).build());
        for (User subUser : subUserList) {
            BeanUtils.copyPropertiesWithoutId((Object)((Object)subUser), (Object)((Object)user));
            this.update((Object)subUser);
        }
        return sum;
    }

    @Override
    @Transactional
    public User updateLdapUser(ILdapUser ldapUser) {
        String id = ldapUser.getId();
        User user = (User)((Object)this.userMapper.selectOneByExample(Example.builder(User.class).andWhere(Sqls.custom().andEqualTo("ldapUserId", (Object)id)).build()));
        if (null != user) {
            user.setLoginName(ldapUser.getUsername());
            user.setFullName(ldapUser.getDisplayName());
        } else {
            user = new User();
            user.setLdapUserId(id);
            user.setLoginName(ldapUser.getUsername());
            user.setFullName(ldapUser.getDisplayName());
            user.setTenantId(this.tenantId);
            user.setLdapSource(ldapUser.getSource());
            this.userMapper.insertSelective((Object)user);
            Role role = (Role)((Object)this.roleMapper.selectOneByExample(Example.builder(Role.class).andWhere(Sqls.custom().andEqualTo("codeName", (Object)"GlobalObserver")).build()));
            this.addRoleMembers((String)((Object)role.getId()), Lists.newArrayList((Object[])new String[]{(String)((Object)user.getId())}));
        }
        return user;
    }
}

