/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.starter.user.service.user.impl;

import com.cyberway.msf.commons.api.result.ApiResultCode;
import com.cyberway.msf.commons.base.service.BaseServiceImpl;
import com.cyberway.msf.commons.base.util.BusinessPreconditions;
import com.cyberway.msf.commons.base.util.MessageUtils;
import com.cyberway.msf.commons.core.exception.BaseException;
import com.cyberway.msf.commons.model.base.EntityImpl;
import com.cyberway.msf.starter.user.mapper.user.UserTypeMapper;
import com.cyberway.msf.starter.user.model.user.User;
import com.cyberway.msf.starter.user.model.user.UserBusinessType;
import com.cyberway.msf.starter.user.model.user.UserType;
import com.cyberway.msf.starter.user.model.user.vo.UserVo;
import com.cyberway.msf.starter.user.service.user.UserService;
import com.cyberway.msf.starter.user.service.user.UserTypeService;
import com.cyberway.msf.starter.user.support.constant.UserApiResultCode;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;
import tk.mybatis.mapper.util.Sqls;

@Service
public class UserTypeServiceImpl
extends BaseServiceImpl<UserType>
implements UserTypeService {
    @Autowired
    private UserService userServiceImpl;
    @Autowired
    private UserTypeMapper userTypeMapper;

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.SUPPORTS)
    public void relateWithUser(String userId, String businessType, String typeId) {
        String type = UserBusinessType.getName(businessType);
        BusinessPreconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)type), (BaseException)MessageUtils.buildException((ApiResultCode)UserApiResultCode.USER_TYPE_NOT_EXISTS, (Object[])new Object[0]));
        User user = (User)((Object)this.userServiceImpl.selectById(userId));
        BusinessPreconditions.checkArgument((user != null ? 1 : 0) != 0, (BaseException)MessageUtils.buildException((ApiResultCode)UserApiResultCode.USER_NOT_EXISTS, (Object[])new Object[0]));
        UserType userIsRelated = (UserType)((Object)this.userTypeMapper.selectOneByExample(Example.builder(UserType.class).where(Sqls.custom().andEqualTo("businessType", (Object)businessType).andEqualTo("userId", (Object)userId)).build()));
        BusinessPreconditions.checkArgument((userIsRelated == null || StringUtils.equals((CharSequence)typeId, (CharSequence)userIsRelated.getTypeId()) ? 1 : 0) != 0, (BaseException)MessageUtils.buildException((ApiResultCode)UserApiResultCode.USER_HAS_RELATED, (Object[])new Object[0]));
        String oldUserId = "";
        UserType userType = (UserType)((Object)this.userTypeMapper.selectOneByExample(Example.builder(UserType.class).where(Sqls.custom().andEqualTo("businessType", (Object)businessType).andEqualTo("typeId", (Object)typeId)).build()));
        if (userType != null) {
            if (!StringUtils.equals((CharSequence)userType.getUserId(), (CharSequence)userId)) {
                oldUserId = userType.getUserId();
                userType.setUserId(userId);
                this.update((Object)userType);
            }
        } else {
            userType = new UserType();
            userType.setUserId(userId);
            userType.setBusinessType(businessType);
            userType.setTypeId(typeId);
            this.insert((Object)userType);
        }
        List<String> businessTypeList = user.getBusinessType();
        businessTypeList.remove(UserBusinessType.DEFAULT.getValue());
        if (!businessTypeList.contains(businessType)) {
            businessTypeList.add(businessType);
        }
        this.userServiceImpl.update((Object)user);
        this.updateUserBusinessType(businessType, Lists.newArrayList((Object[])new String[]{oldUserId}));
    }

    private void updateUserBusinessType(String businessType, List<String> userIds) {
        if (CollectionUtils.isEmpty(userIds)) {
            return;
        }
        for (String userId : userIds) {
            User user = null;
            if (StringUtils.isNotEmpty((CharSequence)userId)) {
                user = (User)((Object)this.userServiceImpl.selectById(userId));
            }
            if (user == null) {
                return;
            }
            List<String> oldBusinessTypeList = user.getBusinessType();
            oldBusinessTypeList.remove(businessType);
            if (CollectionUtils.isEmpty(oldBusinessTypeList)) {
                oldBusinessTypeList.add(UserBusinessType.DEFAULT.getValue());
            }
            this.userServiceImpl.update((Object)user);
        }
    }

    @Override
    public UserVo getRelatedUser(String businessType, String typeId) {
        Example example = new Example(UserType.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("businessType", (Object)businessType).andEqualTo("typeId", (Object)typeId);
        List userTypeList = this.selectByExample(example);
        UserVo userVo = null;
        if (CollectionUtils.isNotEmpty((Collection)userTypeList)) {
            UserType userType = (UserType)((Object)userTypeList.get(0));
            userVo = this.userServiceImpl.selectVoById(userType.getUserId());
        }
        return userVo;
    }

    @Override
    public String getRelatedUserId(String businessType, String typeId) {
        Example example = new Example(UserType.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("businessType", (Object)businessType).andEqualTo("typeId", (Object)typeId);
        List userTypeList = this.selectByExample(example);
        String userId = null;
        if (CollectionUtils.isNotEmpty((Collection)userTypeList)) {
            UserType userType = (UserType)((Object)userTypeList.get(0));
            userId = userType.getUserId();
        }
        return userId;
    }

    @Override
    public List<String> getRelatedUserIds(String businessType, List<String> typeIds) {
        if (CollectionUtils.isEmpty(typeIds)) {
            return Lists.newArrayList();
        }
        Example example = new Example(UserType.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("businessType", (Object)businessType).andIn("typeId", typeIds);
        example.selectProperties(new String[]{"userId"});
        List userTypeList = this.selectByExample(example);
        return userTypeList.stream().map(UserType::getUserId).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disassociateWithUser(String businessType, List<String> typeIds) {
        Example example = new Example(UserType.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("businessType", (Object)businessType).andIn("typeId", typeIds);
        List userTypes = this.userTypeMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty((Collection)userTypes)) {
            this.batchDelete(userTypes.stream().map(EntityImpl::getId).collect(Collectors.toList()));
            this.updateUserBusinessType(businessType, userTypes.stream().map(UserType::getUserId).collect(Collectors.toList()));
        }
    }

    @Override
    public String getUserTypeId(String businessType, String userId) {
        Example example = new Example(UserType.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("businessType", (Object)businessType).andEqualTo("userId", (Object)userId);
        List userTypeList = this.selectByExample(example);
        if (CollectionUtils.isNotEmpty((Collection)userTypeList)) {
            UserType userType = (UserType)((Object)userTypeList.get(0));
            return userType.getTypeId();
        }
        return null;
    }
}

