/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.starter.user.task;

import com.cyberway.msf.starter.user.ldap.ILdapUser;
import com.cyberway.msf.starter.user.ldap.ILdapUserService;
import com.cyberway.msf.starter.user.service.user.UserService;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component(value="cyberwayMsfUserStarter-ldapUserTask")
public class LdapUserTask {
    @Autowired
    UserService userService;
    @Autowired(required=false)
    @Qualifier(value="ldapUserService")
    ILdapUserService ldapUserService;

    @Scheduled(cron="0 0 0/1 * * ?")
    public void syncUsers() {
        if (this.ldapUserService == null) {
            return;
        }
        List<ILdapUser> users = this.ldapUserService.getUsers();
        if (CollectionUtils.isNotEmpty(users)) {
            for (ILdapUser iLdapUser : users) {
                this.userService.updateLdapUser(iLdapUser);
            }
        }
    }
}

