package com.tcbj.website.client;

import org.springframework.cloud.openfeign.FeignClient;
import com.cyberway.msf.commons.client.BaseVoClient;
import com.tcbj.website.model.ArticleContentEnglish;
import com.cyberway.msf.commons.api.result.ApiResponseResult;
import org.springframework.web.bind.annotation.PostMapping;
import com.tcbj.website.dto.ArticleContentEnglishSaveDto;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.PathVariable;
import com.cyberway.msf.commons.model.page.PageDataModel;
import com.tcbj.website.vo.ArticleContentEnglishSimpleVo;
import com.cyberway.msf.commons.model.filter.FilterModel;
import com.tcbj.website.vo.ArticleContentEnglishFullVo;
import org.springframework.web.bind.annotation.GetMapping;

/** 英文版文章内容Feign客户端 */
@FeignClient(
        contextId = "ArticleContentEnglishClient",
        name = "${feign.website:tcbj-website}",
        path = "api/articleContentEnglish")
public interface ArticleContentEnglishClient extends BaseVoClient<ArticleContentEnglish> {

    /**
     * 新增实体
     *
     * @return 实体ID
     */
    @PostMapping
    ApiResponseResult<String> insert(@RequestBody ArticleContentEnglishSaveDto dto);
    /**
     * 更新提交参数中非空实体字段
     *
     * @return 更新记录数
     */
    @PutMapping("/{id}")
    ApiResponseResult<Integer> update(
            @PathVariable("id") String id, @RequestBody ArticleContentEnglishSaveDto dto);
    /**
     * 更新所有实体字段
     *
     * @return 更新记录数
     */
    @PutMapping("/updateAll/{id}")
    ApiResponseResult<Integer> updateAll(
            @PathVariable("id") String id, @RequestBody ArticleContentEnglishSaveDto dto);
    /**
     * 列表查询接口
     *
     * @return 实体列表
     */
    @PostMapping("/list")
    ApiResponseResult<PageDataModel<ArticleContentEnglishSimpleVo>> list(
            @RequestBody FilterModel filterModel);
    /**
     * 详情
     *
     * @return 实体完整详情数据
     */
    @GetMapping("/{id}")
    ApiResponseResult<ArticleContentEnglishFullVo> detail(@PathVariable("id") String id);
    /**
     * 简单字段详情
     *
     * @return 实体简单字段详情数据
     */
    @GetMapping("/{id}/simple")
    ApiResponseResult<ArticleContentEnglishSimpleVo> getSimpleVo(@PathVariable("id") String id);
}
