package com.tcbj.website.client;

import com.tcbj.website.dto.LabelQueryPageDto;
import org.springframework.cloud.openfeign.FeignClient;
import com.cyberway.msf.commons.client.BaseVoClient;
import com.tcbj.website.model.Label;
import com.cyberway.msf.commons.api.result.ApiResponseResult;
import org.springframework.web.bind.annotation.PostMapping;
import com.tcbj.website.dto.LabelSaveDto;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.PathVariable;
import com.cyberway.msf.commons.model.page.PageDataModel;
import com.tcbj.website.vo.LabelSimpleVo;
import com.cyberway.msf.commons.model.filter.FilterModel;
import com.tcbj.website.vo.LabelFullVo;
import org.springframework.web.bind.annotation.GetMapping;
import com.tcbj.website.vo.LabelMinVo;
import java.util.Map;
import java.util.Set;

/** 标签Feign客户端 */
@FeignClient(contextId = "LabelClient", name = "${feign.website:tcbj-website}", path = "api/label")
public interface LabelClient extends BaseVoClient<Label> {

    /**
     * 新增实体
     *
     * @return 实体ID
     */
    @PostMapping
    ApiResponseResult<String> insert(@RequestBody LabelSaveDto dto);
    /**
     * 更新提交参数中非空实体字段
     *
     * @return 更新记录数
     */
    @PutMapping("/{id}")
    ApiResponseResult<Integer> update(@PathVariable("id") String id, @RequestBody LabelSaveDto dto);
    /**
     * 更新所有实体字段
     *
     * @return 更新记录数
     */
    @PutMapping("/updateAll/{id}")
    ApiResponseResult<Integer> updateAll(
            @PathVariable("id") String id, @RequestBody LabelSaveDto dto);
    /**
     * 列表查询接口
     *
     * @return 实体列表
     */
    @PostMapping("/list")
    ApiResponseResult<PageDataModel<LabelSimpleVo>> list(@RequestBody FilterModel filterModel);

    /**
     * 新列表查询接口
     *
     * @return 实体列表
     */
    @PostMapping("/listByMap")
    ApiResponseResult<PageDataModel<LabelSimpleVo>> listByMap(@RequestBody LabelQueryPageDto pageModelDto);
    /**
     * 详情
     *
     * @return 实体完整详情数据
     */
    @GetMapping("/{id}")
    ApiResponseResult<LabelFullVo> detail(@PathVariable("id") String id);
    /**
     * 简单字段详情
     *
     * @return 实体简单字段详情数据
     */
    @GetMapping("/{id}/simple")
    ApiResponseResult<LabelSimpleVo> getSimpleVo(@PathVariable("id") String id);
    /**
     * 最小字段详情
     *
     * @return 实体最小字段详情数据
     */
    @GetMapping("/{id}/min")
    ApiResponseResult<LabelMinVo> getMinVo(@PathVariable("id") String id);
    /**
     * 根据ID集合获取对应MinVo
     *
     * @return Map, key为ID, value为MinVo
     */
    @PostMapping("/getMinVoMapByIdSet")
    ApiResponseResult<Map<String, LabelMinVo>> getMinVoMapByIdSet(@RequestBody Set<String> idSet);
}
