package com.tcbj.website.client;

import com.cyberway.msf.commons.api.result.ApiResponseResult;
import com.cyberway.msf.commons.client.BaseVoClient;
import com.cyberway.msf.commons.model.filter.FilterModel;
import com.cyberway.msf.commons.model.page.PageDataModel;
import com.tcbj.website.dto.LabelKnowledgeQueryPageDto;
import com.tcbj.website.dto.LabelKnowledgeSaveDto;
import com.tcbj.website.model.LabelKnowledge;
import com.tcbj.website.vo.LabelKnowledgeFullVo;
import com.tcbj.website.vo.LabelKnowledgeMinVo;
import com.tcbj.website.vo.LabelKnowledgeSimpleVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.Map;
import java.util.Set;

/** 标签Feign客户端 */
@FeignClient(contextId = "LabelClient", name = "${feign.website:tcbj-website}", path = "api/label")
public interface LabelKnowledgeClient extends BaseVoClient<LabelKnowledge> {

    /**
     * 新增实体
     *
     * @return 实体ID
     */
    @PostMapping
    ApiResponseResult<String> insert(@RequestBody LabelKnowledgeSaveDto dto);
    /**
     * 更新提交参数中非空实体字段
     *
     * @return 更新记录数
     */
    @PutMapping("/{id}")
    ApiResponseResult<Integer> update(@PathVariable("id") String id, @RequestBody LabelKnowledgeSaveDto dto);
    /**
     * 更新所有实体字段
     *
     * @return 更新记录数
     */
    @PutMapping("/updateAll/{id}")
    ApiResponseResult<Integer> updateAll(
            @PathVariable("id") String id, @RequestBody LabelKnowledgeSaveDto dto);
    /**
     * 列表查询接口
     *
     * @return 实体列表
     */
    @PostMapping("/list")
    ApiResponseResult<PageDataModel<LabelKnowledgeSimpleVo>> list(@RequestBody FilterModel filterModel);

    /**
     * 新列表查询接口
     *
     * @return 实体列表
     */
    @PostMapping("/listByMap")
    ApiResponseResult<PageDataModel<LabelKnowledgeSimpleVo>> listByMap(@RequestBody LabelKnowledgeQueryPageDto pageModelDto);
    /**
     * 详情
     *
     * @return 实体完整详情数据
     */
    @GetMapping("/{id}")
    ApiResponseResult<LabelKnowledgeFullVo> detail(@PathVariable("id") String id);
    /**
     * 简单字段详情
     *
     * @return 实体简单字段详情数据
     */
    @GetMapping("/{id}/simple")
    ApiResponseResult<LabelKnowledgeSimpleVo> getSimpleVo(@PathVariable("id") String id);
    /**
     * 最小字段详情
     *
     * @return 实体最小字段详情数据
     */
    @GetMapping("/{id}/min")
    ApiResponseResult<LabelKnowledgeMinVo> getMinVo(@PathVariable("id") String id);
    /**
     * 根据ID集合获取对应MinVo
     *
     * @return Map, key为ID, value为MinVo
     */
    @PostMapping("/getMinVoMapByIdSet")
    ApiResponseResult<Map<String, LabelKnowledgeMinVo>> getMinVoMapByIdSet(@RequestBody Set<String> idSet);
}
