package com.tcbj.website.client;

import com.cyberway.msf.commons.api.result.ApiResponseResult;
import com.cyberway.msf.commons.client.BaseVoClient;
import com.cyberway.msf.commons.model.filter.FilterModel;
import com.cyberway.msf.commons.model.page.PageDataModel;
import com.tcbj.website.dto.*;
import com.tcbj.website.model.LabelKnowledge;
import com.tcbj.website.model.LabelLiterature;
import com.tcbj.website.vo.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;
import java.util.Set;

/** 标签Feign客户端 */
@FeignClient(contextId = "LabelClient", name = "${feign.website:tcbj-website}", path = "api/label")
public interface LabelLiteratureClient extends BaseVoClient<LabelLiterature> {

    /**
     * 新增实体
     *
     * @return 实体ID
     */
    @PostMapping
    ApiResponseResult<String> insert(@RequestBody LabelLiteratureSaveDto dto);
    /**
     * 更新提交参数中非空实体字段
     *
     * @return 更新记录数
     */
    @PutMapping("/{id}")
    ApiResponseResult<Integer> update(@PathVariable("id") String id, @RequestBody LabelLiteratureSaveDto dto);
    /**
     * 更新所有实体字段
     *
     * @return 更新记录数
     */
    @PutMapping("/updateAll/{id}")
    ApiResponseResult<Integer> updateAll(
            @PathVariable("id") String id, @RequestBody LabelLiteratureSaveDto dto);
    /**
     * 列表查询接口
     *
     * @return 实体列表
     */
    @PostMapping("/list")
    ApiResponseResult<PageDataModel<LabelLiteratureFullVo>> list(@RequestBody FilterModel filterModel);


    /**
     * 列表查询接口
     *
     * @return 实体列表
     */
    @PostMapping("/getFirstList")
    ApiResponseResult<  List<LabelLiteratureFullVo>> getLabelLiteratureList(@RequestBody LabelLiteratureTreeDto queryTreeDto);
    /**
     * 新列表查询接口
     *
     * @return 实体列表
     */
    @PostMapping("/listByMapTree")
    ApiResponseResult<List<LabelLiteratureTreeVo>> listByMapTree(@RequestBody LabelLiteratureQueryTreeDto pageModelDto);

    /**
     * 新列表查询接口
     *
     * @return 实体列表
     */
    @PostMapping("/listByMap")
    ApiResponseResult<PageDataModel<LabelLiteratureFullVo>> listByMap(@RequestBody LabelLiteratureQueryDto pageModelDto);
    /**
     * 详情
     *
     * @return 实体完整详情数据
     */
    @GetMapping("/{id}")
    ApiResponseResult<LabelLiteratureFullVo> detail(@PathVariable("id") String id);

}
