package com.tcbj.website.dto;

import io.swagger.annotations.ApiModel;

import javax.persistence.Column;
import javax.validation.constraints.NotNull;
import com.cyberway.msf.commons.model.valid.AllFieldSaveOrUpdate;
import io.swagger.annotations.ApiModelProperty;

/** 文章与标签关联表新增修改DTO */
@ApiModel("文章与标签关联表新增修改DTO")
public class ArticleContentLabelSaveDto {

    /** 文章ID */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("文章ID")
    private String articleContentId;
    /** 标签Id */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("标签Id")
    private String labelId;

    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("知识库标签标识:1:知识库额外标签,2:知识库文献标签")
    private Integer knowledgeTag;

    public Integer getKnowledgeTag() {
        return knowledgeTag;
    }

    public void setKnowledgeTag(Integer knowledgeTag) {
        this.knowledgeTag = knowledgeTag;
    }

    /**
     * 设置 {@link #articleContentId}
     *
     * @param articleContentId {@link #articleContentId}
     */
    public void setArticleContentId(String articleContentId) {
        this.articleContentId = articleContentId;
    }
    /**
     * 获取 {@link #articleContentId}
     *
     * @return {@link #articleContentId}
     */
    public String getArticleContentId() {
        return articleContentId;
    }
    /**
     * 设置 {@link #labelId}
     *
     * @param labelId {@link #labelId}
     */
    public void setLabelId(String labelId) {
        this.labelId = labelId;
    }
    /**
     * 获取 {@link #labelId}
     *
     * @return {@link #labelId}
     */
    public String getLabelId() {
        return labelId;
    }
}
