package com.tcbj.website.dto;

import io.swagger.annotations.ApiModel;
import java.util.List;
import javax.validation.constraints.NotNull;
import com.cyberway.msf.commons.model.valid.AllFieldSaveOrUpdate;
import io.swagger.annotations.ApiModelProperty;

/** 基金申请单新增修改DTO */
@ApiModel("基金申请单新增修改DTO")
public class FundApplicationFormSaveDto {

    /** 附件链接数组 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("附件链接数组")
    private List<AttachmentSaveDto> accessory;
    /** 申请单流水号 */
    @ApiModelProperty("申请单流水号")
    private String code;
    /** 邮箱地址 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("邮箱地址")
    private String email;
    /** 模板项目名称 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("模板项目Id")
    private String fundTemplateId;
    /** 是否删除 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("是否删除")
    private Integer isDelete;
    /** 是否英文 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("是否英文")
    private Integer isEn;
    /** 申请单内容 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("申请单内容")
    private String jsonStr;
    /** 手机 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("手机")
    private Long mobile;
    /** 姓名 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("姓名")
    private String name;
    /** 审核意见 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("审核意见")
    private String opinion;
    /** 审核状态 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("审核状态")
    private Integer status;
    /** 所属单位 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("所属单位")
    private String unit;

    /** 申请人id */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("申请人id")
    private String proposerId;


    /** 申请项目名称 */
    @ApiModelProperty("申请项目名称")
    private String projectName;

    /**
     * 设置 {@link #accessory}
     *
     * @param accessory {@link #accessory}
     */
    public void setAccessory(List<AttachmentSaveDto> accessory) {
        this.accessory = accessory;
    }
    /**
     * 获取 {@link #accessory}
     *
     * @return {@link #accessory}
     */
    public List<AttachmentSaveDto> getAccessory() {
        return accessory;
    }
    /**
     * 设置 {@link #code}
     *
     * @param code {@link #code}
     */
    public void setCode(String code) {
        this.code = code;
    }
    /**
     * 获取 {@link #code}
     *
     * @return {@link #code}
     */
    public String getCode() {
        return code;
    }
    /**
     * 设置 {@link #email}
     *
     * @param email {@link #email}
     */
    public void setEmail(String email) {
        this.email = email;
    }
    /**
     * 获取 {@link #email}
     *
     * @return {@link #email}
     */
    public String getEmail() {
        return email;
    }
    /**
     * 设置 {@link #fundTemplateId}
     *
     * @param fundTemplateId {@link #fundTemplateId}
     */
    public void setFundTemplateId(String fundTemplateId) {
        this.fundTemplateId = fundTemplateId;
    }
    /**
     * 获取 {@link #fundTemplateId}
     *
     * @return {@link #fundTemplateId}
     */
    public String getFundTemplateId() {
        return fundTemplateId;
    }
    /**
     * 设置 {@link #isDelete}
     *
     * @param isDelete {@link #isDelete}
     */
    public void setIsDelete(Integer isDelete) {
        this.isDelete = isDelete;
    }
    /**
     * 获取 {@link #isDelete}
     *
     * @return {@link #isDelete}
     */
    public Integer getIsDelete() {
        return isDelete;
    }
    /**
     * 设置 {@link #isEn}
     *
     * @param isEn {@link #isEn}
     */
    public void setIsEn(Integer isEn) {
        this.isEn = isEn;
    }
    /**
     * 获取 {@link #isEn}
     *
     * @return {@link #isEn}
     */
    public Integer getIsEn() {
        return isEn;
    }
    /**
     * 设置 {@link #jsonStr}
     *
     * @param jsonStr {@link #jsonStr}
     */
    public void setJsonStr(String jsonStr) {
        this.jsonStr = jsonStr;
    }
    /**
     * 获取 {@link #jsonStr}
     *
     * @return {@link #jsonStr}
     */
    public String getJsonStr() {
        return jsonStr;
    }
    /**
     * 设置 {@link #mobile}
     *
     * @param mobile {@link #mobile}
     */
    public void setMobile(Long mobile) {
        this.mobile = mobile;
    }
    /**
     * 获取 {@link #mobile}
     *
     * @return {@link #mobile}
     */
    public Long getMobile() {
        return mobile;
    }
    /**
     * 设置 {@link #name}
     *
     * @param name {@link #name}
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 获取 {@link #name}
     *
     * @return {@link #name}
     */
    public String getName() {
        return name;
    }
    /**
     * 设置 {@link #opinion}
     *
     * @param opinion {@link #opinion}
     */
    public void setOpinion(String opinion) {
        this.opinion = opinion;
    }
    /**
     * 获取 {@link #opinion}
     *
     * @return {@link #opinion}
     */
    public String getOpinion() {
        return opinion;
    }
    /**
     * 设置 {@link #status}
     *
     * @param status {@link #status}
     */
    public void setStatus(Integer status) {
        this.status = status;
    }
    /**
     * 获取 {@link #status}
     *
     * @return {@link #status}
     */
    public Integer getStatus() {
        return status;
    }
    /**
     * 设置 {@link #unit}
     *
     * @param unit {@link #unit}
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 获取 {@link #unit}
     *
     * @return {@link #unit}
     */
    public String getUnit() {
        return unit;
    }

    public String getProposerId() {
        return proposerId;
    }

    public void setProposerId(String proposerId) {
        this.proposerId = proposerId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
}
