package com.tcbj.website.dto;


import com.cyberway.msf.commons.model.page.PageModel;
import com.cyberway.msf.commons.model.valid.AllFieldSaveOrUpdate;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/** 知识库标签分页查询DTO */
@ApiModel("知识库标签分页查询DTO")
public class LabelKnowledgeQueryPageDto extends PageModel {


    /** 是否删除 */
    @ApiModelProperty("是否删除 0:否 1：是")
    private Integer isDelete;
    /** 是否英文标签 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("是否英文标签 0:否 1：是")
    private Integer isEn;
    /** 名称 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("名称")
    private String name;
    /** 是否热门 */
    @ApiModelProperty("是否热门 0：否 1：是")
    private Integer isHot;

    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("知识库标签标识:1:知识库额外标签,2:知识库文献标签,3:推荐书籍类别")
    private Integer knowledgeTag;

    public Integer getKnowledgeTag() {
        return knowledgeTag;
    }

    public void setKnowledgeTag(Integer knowledgeTag) {
        this.knowledgeTag = knowledgeTag;
    }

    public Integer getIsDelete() {
        return isDelete;
    }

    public void setIsDelete(Integer isDelete) {
        this.isDelete = isDelete;
    }

    public Integer getIsEn() {
        return isEn;
    }

    public void setIsEn(Integer isEn) {
        this.isEn = isEn;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getIsHot() {
        return isHot;
    }

    public void setIsHot(Integer isHot) {
        this.isHot = isHot;
    }
}
